/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.NotificationChannel;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Activator;
import org.netxms.ui.eclipse.serverconfig.dialogs.NotificationChannelDialog;
import org.netxms.ui.eclipse.serverconfig.views.helpers.NotificationChannelLabelProvider;
import org.netxms.ui.eclipse.serverconfig.views.helpers.NotificationChannelListComparator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class NotificationChannelView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.NotificationChannelView";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_DRIVER_NAME = 2;
    private NXCSession session;
    private SessionListener listener;
    private List<NotificationChannel> notificationChannelList;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionNewChannel;
    private Action actionEditChannel;
    private Action actionDeleteChannel;
    private NotificationChannel selectedChannel;

    public void createPartControl(Composite parent) {
        int[] widths = new int[]{80, 200, 80};
        String[] names = new String[]{"Name", "Description", "DriverName"};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new NotificationChannelLabelProvider());
        this.viewer.setComparator((ViewerComparator)new NotificationChannelListComparator());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                NotificationChannelView.this.editChannel();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)NotificationChannelView.this.viewer.getSelection();
                NotificationChannelView.this.actionEditChannel.setEnabled(selection.size() == 1);
                NotificationChannelView.this.actionDeleteChannel.setEnabled(selection.size() > 0);
            }
        });
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)"NotificationChannelList");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)NotificationChannelView.this.viewer, (IDialogSettings)settings, (String)"NotificationChannelList");
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session = ConsoleSharedData.getSession();
        this.refresh();
        final Display display = this.getSite().getShell().getDisplay();
        this.listener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1042) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NotificationChannelView.this.refresh();
                        }
                    });
                }
            }
        };
        this.session.addListener(this.listener);
    }

    public void dispose() {
        if (this.listener != null && this.session != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                NotificationChannelView.this.refresh();
            }
        };
        this.actionNewChannel = new Action("Create new channel", SharedIcons.ADD_OBJECT){

            public void run() {
                NotificationChannelView.this.createNewChannel();
            }
        };
        this.actionEditChannel = new Action("Edit", SharedIcons.EDIT){

            public void run() {
                NotificationChannelView.this.editChannel();
            }
        };
        this.actionEditChannel.setEnabled(false);
        this.actionDeleteChannel = new Action("Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                NotificationChannelView.this.deleteChannel();
            }
        };
        this.actionDeleteChannel.setEnabled(false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNewChannel);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNewChannel);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                NotificationChannelView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNewChannel);
        mgr.add((IAction)this.actionEditChannel);
        mgr.add((IAction)this.actionDeleteChannel);
    }

    private void refresh() {
        new ConsoleJob("Get notification channels", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NotificationChannelView.this.notificationChannelList = NotificationChannelView.this.session.getNotificationChannels();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        NotificationChannelView.this.viewer.setInput((Object)NotificationChannelView.this.notificationChannelList);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Error while getting notificaiton channels";
            }
        }.start();
    }

    private void createNewChannel() {
        NotificationChannelDialog dlg = new NotificationChannelDialog(this.getSite().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        this.selectedChannel = dlg.getNotificaiotnChannel();
        new ConsoleJob("Create notification channel", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NotificationChannelView.this.session.createNotificationChannel(NotificationChannelView.this.selectedChannel);
            }

            protected String getErrorMessage() {
                return "Error creating notifiction channel";
            }
        }.start();
    }

    private void editChannel() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        this.selectedChannel = (NotificationChannel)selection.getFirstElement();
        final NotificationChannelDialog dlg = new NotificationChannelDialog(this.getSite().getShell(), this.selectedChannel);
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Update notification channel", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NotificationChannelView.this.session.updateNotificationChannel(NotificationChannelView.this.selectedChannel);
                if (dlg.isNameChanged()) {
                    NotificationChannelView.this.session.renameNotificaiotnChannel(NotificationChannelView.this.selectedChannel.getName(), dlg.getNewName());
                }
            }

            protected String getErrorMessage() {
                return "Error updating notifiction channel";
            }
        }.start();
    }

    private void deleteChannel() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Delete notification channels", (String)"Are you sure you want to delete notification channels?")) {
            return;
        }
        final ArrayList<String> channels = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof NotificationChannel)) continue;
            channels.add(((NotificationChannel)o).getName());
        }
        new ConsoleJob("Delete notification channel", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (String name : channels) {
                    NotificationChannelView.this.session.deleteNotificationChannel(name);
                }
            }

            protected String getErrorMessage() {
                return "Error deleting notifiction channel";
            }
        }.start();
    }
}

