/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.RadioInterface;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.topology.Activator;
import org.netxms.ui.eclipse.topology.Messages;
import org.netxms.ui.eclipse.topology.views.helpers.RadioInterfaceComparator;
import org.netxms.ui.eclipse.topology.views.helpers.RadioInterfaceLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class RadioInterfaces
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.topology.views.RadioInterfaces";
    public static final int COLUMN_AP_NAME = 0;
    public static final int COLUMN_AP_MAC_ADDR = 1;
    public static final int COLUMN_AP_VENDOR = 2;
    public static final int COLUMN_AP_MODEL = 3;
    public static final int COLUMN_AP_SERIAL = 4;
    public static final int COLUMN_INDEX = 5;
    public static final int COLUMN_NAME = 6;
    public static final int COLUMN_MAC_ADDR = 7;
    public static final int COLUMN_CHANNEL = 8;
    public static final int COLUMN_TX_POWER_DBM = 9;
    public static final int COLUMN_TX_POWER_MW = 10;
    private NXCSession session;
    private long rootObject;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            this.rootObject = Long.parseLong(site.getSecondaryId());
        }
        catch (NumberFormatException e) {
            this.rootObject = 0L;
        }
        this.session = ConsoleSharedData.getSession();
        Messages.get();
        this.setPartName(String.format(Messages.RadioInterfaces_PartName, this.session.getObjectName(this.rootObject)));
    }

    public void createPartControl(Composite parent) {
        String[] stringArray = new String[11];
        Messages.get();
        stringArray[0] = Messages.RadioInterfaces_ColApName;
        Messages.get();
        stringArray[1] = Messages.RadioInterfaces_ColApMac;
        Messages.get();
        stringArray[2] = Messages.RadioInterfaces_ColApVendor;
        Messages.get();
        stringArray[3] = Messages.RadioInterfaces_ColApModel;
        Messages.get();
        stringArray[4] = Messages.RadioInterfaces_ColApSerial;
        Messages.get();
        stringArray[5] = Messages.RadioInterfaces_ColRadioIndex;
        Messages.get();
        stringArray[6] = Messages.RadioInterfaces_ColRadioName;
        Messages.get();
        stringArray[7] = Messages.RadioInterfaces_ColRadioMac;
        Messages.get();
        stringArray[8] = Messages.RadioInterfaces_ColChannel;
        Messages.get();
        stringArray[9] = Messages.RadioInterfaces_ColTxPowerDbm;
        Messages.get();
        stringArray[10] = Messages.RadioInterfaces_ColTxPowerMw;
        String[] names = stringArray;
        int[] widths = new int[]{120, 100, 140, 140, 100, 90, 120, 100, 90, 90, 90};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RadioInterfaceLabelProvider());
        this.viewer.setComparator((ViewerComparator)new RadioInterfaceComparator());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"RadioInterfaces");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)RadioInterfaces.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"RadioInterfaces");
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                RadioInterfaces.this.refresh();
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                RadioInterfaces.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void refresh() {
        Node node = (Node)this.session.findObjectById(this.rootObject, Node.class);
        if (node == null) {
            return;
        }
        ArrayList<RadioInterface> list = new ArrayList<RadioInterface>();
        for (AbstractObject o : node.getAllChildren(33)) {
            if (!(o instanceof AccessPoint)) continue;
            RadioInterface[] radioInterfaceArray = ((AccessPoint)o).getRadios();
            int n = radioInterfaceArray.length;
            int n2 = 0;
            while (n2 < n) {
                RadioInterface rif = radioInterfaceArray[n2];
                list.add(rif);
                ++n2;
            }
        }
        this.viewer.setInput((Object)list.toArray());
    }
}

