/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.TableThreshold;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.propertypages.TableColumns;
import org.netxms.ui.eclipse.datacollection.widgets.TableConditionsEditor;
import org.netxms.ui.eclipse.eventmanager.widgets.EventSelector;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;

public class EditTableThresholdDialog
extends Dialog {
    private TableThreshold threshold;
    private EventSelector activationEvent;
    private EventSelector deactivationEvent;
    private LabeledSpinner sampleCount;
    private TableConditionsEditor conditionsEditor;
    private TableColumns.TableColumnDataProvider columnCallback;

    public EditTableThresholdDialog(Shell parentShell, TableThreshold threshold, TableColumns.TableColumnDataProvider columnCallback) {
        super(parentShell);
        this.threshold = threshold;
        this.columnCallback = columnCallback;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.EditTableThresholdDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.activationEvent = new EventSelector(dialogArea, 0);
        Messages.get();
        this.activationEvent.setLabel(Messages.EditTableThresholdDialog_ActivationEvent);
        this.activationEvent.setEventCode((long)this.threshold.getActivationEvent());
        this.activationEvent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.deactivationEvent = new EventSelector(dialogArea, 0);
        Messages.get();
        this.deactivationEvent.setLabel(Messages.EditTableThresholdDialog_DeactivationEvent);
        this.deactivationEvent.setEventCode((long)this.threshold.getDeactivationEvent());
        this.deactivationEvent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sampleCount = new LabeledSpinner(dialogArea, 0);
        this.sampleCount.setLabel("Sample count");
        this.sampleCount.setRange(1, 100000);
        this.sampleCount.setSelection(this.threshold.getSampleCount());
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.EditTableThresholdDialog_Conditions);
        this.conditionsEditor = new TableConditionsEditor(dialogArea, 2048, this.columnCallback);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 700;
        gd.heightHint = 400;
        this.conditionsEditor.setLayoutData(gd);
        this.conditionsEditor.setConditions(this.threshold.getConditions());
        return dialogArea;
    }

    protected void okPressed() {
        this.threshold.setActivationEvent((int)this.activationEvent.getEventCode());
        this.threshold.setDeactivationEvent((int)this.deactivationEvent.getEventCode());
        this.threshold.setSampleCount(this.sampleCount.getSelection());
        this.threshold.setConditions(this.conditionsEditor.getConditions());
        super.okPressed();
    }
}

