/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.helpers;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.LogParserEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserContext;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserEvent;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserMatch;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserRule;
import org.netxms.ui.eclipse.eventmanager.widgets.EventSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CGroup;
import org.netxms.ui.eclipse.widgets.DashboardComposite;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class LogParserRuleEditor
extends DashboardComposite {
    private static final Color CONDITION_BORDER_COLOR = new Color((Device)Display.getCurrent(), 198, 214, 172);
    private static final Color ACTION_BORDER_COLOR = new Color((Device)Display.getCurrent(), 186, 176, 201);
    private static final Color TITLE_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private FormToolkit toolkit;
    private LogParserRule rule;
    private LogParserEditor editor;
    private LabeledText name;
    private LabeledText regexp;
    private Button checkboxInvert;
    private Button checkboxReset;
    private Spinner repeatCount;
    private Spinner timeRange;
    private Combo timeUnits;
    private LabeledText severity;
    private LabeledText facility;
    private LabeledText tag;
    private LabeledText activeContext;
    private LabeledText description;
    private LabeledText agentAction;
    private EventSelector event;
    private LabeledText context;
    private Combo contextAction;
    private Combo contextResetMode;
    private Button checkboxBreak;

    public LogParserRuleEditor(Composite parent, FormToolkit toolkit, LogParserRule rule, final LogParserEditor editor) {
        super(parent, 2048);
        this.toolkit = toolkit;
        this.rule = rule;
        this.editor = editor;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.setLayout((Layout)layout);
        Composite controlBar = new Composite((Composite)this, 0);
        controlBar.setLayout((Layout)new RowLayout(256));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 131072;
        controlBar.setLayoutData((Object)gd);
        this.fillControlBar(controlBar);
        this.name = new LabeledText((Composite)this, 0);
        this.name.setLabel("Name");
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.name.setLayoutData((Object)gd);
        this.name.setText(rule.getName() != null ? rule.getName() : "");
        this.name.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                editor.fireModifyListeners();
            }
        });
        Messages.get();
        CGroup condition = new CGroup((Composite)this, Messages.LogParserRuleEditor_Condition){

            protected Control createClientArea(Composite parent) {
                this.setBorderColor(CONDITION_BORDER_COLOR);
                this.setTitleColor(TITLE_COLOR);
                return LogParserRuleEditor.this.createMatchingArea(parent);
            }
        };
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        condition.setLayoutData((Object)gd);
        Messages.get();
        CGroup action = new CGroup((Composite)this, Messages.LogParserRuleEditor_Action){

            protected Control createClientArea(Composite parent) {
                this.setBorderColor(ACTION_BORDER_COLOR);
                this.setTitleColor(TITLE_COLOR);
                return LogParserRuleEditor.this.createActionArea(parent);
            }
        };
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        action.setLayoutData((Object)gd);
    }

    private void fillControlBar(Composite parent) {
        ImageHyperlink link = this.toolkit.createImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_UP);
        Messages.get();
        link.setToolTipText(Messages.LogParserRuleEditor_MoveUp);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserRuleEditor.this.editor.moveRuleUp(LogParserRuleEditor.this.rule);
            }
        });
        link = this.toolkit.createImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_DOWN);
        Messages.get();
        link.setToolTipText(Messages.LogParserRuleEditor_MoveDown);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserRuleEditor.this.editor.moveRuleDown(LogParserRuleEditor.this.rule);
            }
        });
        link = this.toolkit.createImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        Messages.get();
        link.setToolTipText(Messages.LogParserRuleEditor_DeleteRule);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserRuleEditor.this.editor.deleteRule(LogParserRuleEditor.this.rule);
            }
        });
    }

    private Composite createMatchingArea(Composite parent) {
        String string;
        String string2;
        String string3;
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        area.setLayout((Layout)layout);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }
        };
        Composite matcher = new Composite(area, 0);
        this.toolkit.adapt(matcher);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        matcher.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        matcher.setLayout((Layout)layout);
        this.regexp = new LabeledText(matcher, 0);
        Messages.get();
        this.regexp.setLabel(Messages.LogParserRuleEditor_MatchingRegExp);
        this.regexp.setText(this.rule.getMatch().getMatch());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.regexp.setLayoutData((Object)gd);
        this.regexp.getTextControl().addModifyListener(listener);
        this.checkboxInvert = this.toolkit.createButton(matcher, "Invert", 32);
        this.checkboxInvert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }
        });
        this.checkboxInvert.setSelection(this.rule.getMatch().getInvert());
        Composite matcherRepeatConf = new Composite(matcher, 0);
        this.toolkit.adapt(matcherRepeatConf);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        matcherRepeatConf.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        matcherRepeatConf.setLayout((Layout)layout);
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new Spinner(parent, style);
            }
        };
        this.repeatCount = (Spinner)WidgetHelper.createLabeledControl((Composite)matcherRepeatConf, (int)2048, (WidgetFactory)factory, (String)"Repeat count", (Object)"WidgetHelper::default_layout_data");
        this.toolkit.adapt((Composite)this.repeatCount);
        this.repeatCount.setMinimum(0);
        this.repeatCount.setSelection(this.rule.getMatch().getRepeatCount().intValue());
        this.repeatCount.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.repeatCount.setLayoutData((Object)gd);
        Composite timeBackGroup = new Composite(matcherRepeatConf, 0);
        this.toolkit.adapt(timeBackGroup);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        timeBackGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        timeBackGroup.setLayoutData((Object)gd);
        this.timeRange = WidgetHelper.createLabeledSpinner((Composite)timeBackGroup, (int)2048, (String)"Repeat interval", (int)1, (int)10000, (Object)"WidgetHelper::default_layout_data");
        this.timeRange.setSelection(this.rule.getMatch().getTimeRagne());
        this.toolkit.adapt((Composite)this.timeRange);
        this.timeUnits = WidgetHelper.createLabeledCombo((Composite)timeBackGroup, (int)8, (String)"", (Object)"WidgetHelper::default_layout_data");
        this.timeUnits.add("Seconds");
        this.timeUnits.add("Minutes");
        this.timeUnits.add("Hours");
        this.timeUnits.select(this.rule.getMatch().getTimeUnit());
        this.toolkit.adapt((Composite)this.timeUnits);
        this.checkboxReset = this.toolkit.createButton(matcherRepeatConf, "Reset repeat count", 32);
        this.checkboxReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }
        });
        this.checkboxReset.setSelection(this.rule.getMatch().getReset());
        this.severity = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.severity);
        if (this.editor.isSyslogParser()) {
            Messages.get();
            string3 = Messages.LogParserRuleEditor_Severity;
        } else {
            string3 = "Level";
        }
        this.severity.setLabel(string3);
        this.severity.setText(this.rule.getSeverityOrLevel(this.editor.isSyslogParser()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.severity.setLayoutData((Object)gd);
        this.severity.getTextControl().addModifyListener(listener);
        this.facility = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.facility);
        if (this.editor.isSyslogParser()) {
            Messages.get();
            string2 = Messages.LogParserRuleEditor_Facility;
        } else {
            string2 = "Id";
        }
        this.facility.setLabel(string2);
        this.facility.setText(this.rule.getFacilityOrId(this.editor.isSyslogParser()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.facility.setLayoutData((Object)gd);
        this.facility.getTextControl().addModifyListener(listener);
        this.tag = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.tag);
        if (this.editor.isSyslogParser()) {
            Messages.get();
            string = Messages.LogParserRuleEditor_SyslogTag;
        } else {
            string = "Source";
        }
        this.tag.setLabel(string);
        this.tag.setText(this.rule.getTagOrSource(this.editor.isSyslogParser()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.tag.setLayoutData((Object)gd);
        this.tag.getTextControl().addModifyListener(listener);
        this.activeContext = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.activeContext);
        Messages.get();
        this.activeContext.setLabel(Messages.LogParserRuleEditor_ActiveContext);
        this.activeContext.setText(this.rule.getContext() != null ? this.rule.getContext() : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.activeContext.setLayoutData((Object)gd);
        this.activeContext.getTextControl().addModifyListener(listener);
        this.description = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.description);
        this.description.setLabel("Description");
        this.description.setText(this.rule.getDescription() != null ? this.rule.getDescription() : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.description.setLayoutData((Object)gd);
        this.description.getTextControl().addModifyListener(listener);
        this.updateWindowsEventLogFields();
        return area;
    }

    public void updateWindowsEventLogFields() {
        if (this.editor.isSyslogParser()) {
            return;
        }
        if (this.editor.isWindowsEventLogParser()) {
            this.severity.setEnabled(true);
            this.facility.setEnabled(true);
            this.tag.setEnabled(true);
        } else {
            this.severity.setEnabled(false);
            this.facility.setEnabled(false);
            this.tag.setEnabled(false);
        }
    }

    private Composite createActionArea(Composite parent) {
        long eventCode;
        GridLayout layout;
        Composite area;
        block7: {
            area = new Composite(parent, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            area.setLayout((Layout)layout);
            eventCode = 0L;
            if (this.rule.getEvent() != null) {
                try {
                    eventCode = Long.parseLong(this.rule.getEvent().getEvent());
                }
                catch (NumberFormatException e) {
                    EventTemplate tmpl = ConsoleSharedData.getSession().findEventTemplateByName(this.rule.getEvent().getEvent());
                    if (tmpl == null) break block7;
                    eventCode = tmpl.getCode();
                }
            }
        }
        this.event = new EventSelector(area, 0, true);
        this.toolkit.adapt((Composite)this.event);
        Messages.get();
        this.event.setLabel(Messages.LogParserRuleEditor_GenerateEvent);
        this.event.setEventCode(eventCode);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.event.setLayoutData((Object)gd);
        this.event.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }
        });
        LogParserContext contextDefinition = this.rule.getContextDefinition();
        this.context = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.context);
        Messages.get();
        this.context.setLabel(Messages.LogParserRuleEditor_ChangeContext);
        this.context.setText(contextDefinition != null ? contextDefinition.getData() : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.context.setLayoutData((Object)gd);
        this.context.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean contextSet = !LogParserRuleEditor.this.context.getText().trim().isEmpty();
                LogParserRuleEditor.this.contextAction.setEnabled(contextSet);
                LogParserRuleEditor.this.contextResetMode.setEnabled(contextSet && LogParserRuleEditor.this.contextAction.getSelectionIndex() == 0);
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }
        });
        Composite contextOptions = new Composite(area, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        contextOptions.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        contextOptions.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.contextAction = WidgetHelper.createLabeledCombo((Composite)contextOptions, (int)8, (String)Messages.LogParserRuleEditor_ContextAction, (Object)gd);
        this.toolkit.adapt((Composite)this.contextAction);
        Messages.get();
        this.contextAction.add(Messages.LogParserRuleEditor_CtxActionActivate);
        Messages.get();
        this.contextAction.add(Messages.LogParserRuleEditor_CtxActionClear);
        if (contextDefinition != null) {
            this.contextAction.select(contextDefinition.getAction());
        } else {
            this.contextAction.select(0);
            this.contextAction.setEnabled(false);
        }
        this.contextAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LogParserRuleEditor.this.contextResetMode.setEnabled(LogParserRuleEditor.this.contextAction.getSelectionIndex() == 0);
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.contextResetMode = WidgetHelper.createLabeledCombo((Composite)contextOptions, (int)8, (String)Messages.LogParserRuleEditor_ContextResetMode, (Object)gd);
        this.toolkit.adapt((Composite)this.contextResetMode);
        Messages.get();
        this.contextResetMode.add(Messages.LogParserRuleEditor_CtxModeAuto);
        Messages.get();
        this.contextResetMode.add(Messages.LogParserRuleEditor_CtxModeManual);
        if (contextDefinition != null) {
            this.contextResetMode.select(contextDefinition.getReset());
            this.contextResetMode.setEnabled(contextDefinition.getAction() == 0);
        } else {
            this.contextResetMode.select(0);
            this.contextResetMode.setEnabled(false);
        }
        this.contextResetMode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LogParserRuleEditor.this.editor.fireModifyListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.agentAction = new LabeledText(area, 0);
        this.toolkit.adapt((Composite)this.agentAction);
        this.agentAction.setLabel("Execute action");
        this.agentAction.setText(this.rule.getAgentAction() != null ? this.rule.getAgentAction().getAction() : "");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.agentAction.setLayoutData((Object)gd);
        this.checkboxBreak = this.toolkit.createButton(area, "Process all", 32);
        this.checkboxBreak.setText("Break");
        this.checkboxBreak.setSelection(this.rule.isBreakProcessing());
        return area;
    }

    public void save() {
        this.rule.setName(this.name.getText().trim());
        this.rule.setMatch(new LogParserMatch(this.regexp.getText(), this.checkboxInvert.getSelection(), this.intOrNull(this.repeatCount.getText()), Integer.parseInt(this.timeRange.getText()) * (this.timeUnits.getSelectionIndex() * 60), this.checkboxReset.getSelection()));
        this.rule.setFacilityOrId(this.intOrNull(this.facility.getText()));
        this.rule.setSeverityOrLevel(this.intOrNull(this.severity.getText()));
        this.rule.setTagOrSource(this.tag.getText());
        this.rule.setContext(this.activeContext.getText().trim().isEmpty() ? null : this.activeContext.getText());
        this.rule.setBreakProcessing(this.checkboxBreak.getSelection());
        this.rule.setDescription(this.description.getText());
        if (this.event.getEventCode() != 0L) {
            this.rule.setEvent(new LogParserEvent(this.event.getEventName() != null ? this.event.getEventName() : Long.toString(this.event.getEventCode()), null));
        } else {
            this.rule.setEvent(null);
        }
        if (this.context.getText().trim().isEmpty()) {
            this.rule.setContextDefinition(null);
        } else {
            LogParserContext ctx = new LogParserContext();
            ctx.setData(this.context.getText());
            ctx.setAction(this.contextAction.getSelectionIndex());
            ctx.setReset(this.contextResetMode.getSelectionIndex());
            this.rule.setContextDefinition(ctx);
        }
        if (!this.agentAction.getText().trim().isEmpty()) {
            this.rule.setAgentAction(this.agentAction.getText().trim());
        }
    }

    private Integer intOrNull(String text) {
        if (text.trim().isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean isSyslogParser() {
        return this.editor.isSyslogParser();
    }
}

