/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.ui.eclipse.objectbrowser.widgets.ZoneSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.topology.Activator;
import org.netxms.ui.eclipse.topology.Messages;

public class EnterPrimaryHostnameDlg
extends Dialog {
    private Text hostnameText;
    private ZoneSelector zoneSelector;
    private String hostname;
    private long zoneUIN;
    private boolean zoningEnabled = ConsoleSharedData.getSession().isZoningEnabled();

    public EnterPrimaryHostnameDlg(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Enter Hostname");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.hostnameText = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)"Enter hostname", (String)"", (Object)gd);
        if (this.zoningEnabled) {
            this.zoneSelector = new ZoneSelector(dialogArea, 0, false);
            Messages.get();
            this.zoneSelector.setLabel(Messages.EnterIpAddressDlg_Zone);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 300;
            this.zoneSelector.setLayoutData((Object)gd);
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            try {
                long uin = settings.getLong("HostNameSelection.ZoneUIN");
                if (ConsoleSharedData.getSession().findZone(uin) != null) {
                    this.zoneSelector.setZoneUIN(uin);
                }
            }
            catch (Exception e) {
                this.zoneSelector.setZoneUIN(0L);
            }
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.hostname = this.hostnameText.getText();
        if (this.zoningEnabled) {
            this.zoneUIN = this.zoneSelector.getZoneUIN();
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            settings.put("HostNameSelection.ZoneUIN", this.zoneUIN);
        } else {
            this.zoneUIN = 0L;
        }
        super.okPressed();
    }

    public long getZoneId() {
        return this.zoneUIN;
    }

    public String getHostname() {
        return this.hostname;
    }
}

