/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class CreatePolicyDialog
extends Dialog {
    private String policyName;
    private String policyType;
    private Text textName;
    private Combo typeSelector;
    private AgentPolicy policy;

    public CreatePolicyDialog(Shell parentShell, AgentPolicy policy) {
        super(parentShell);
        this.policy = policy;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create new policy");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.textName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Policy name", (String)"", (Object)"WidgetHelper::default_layout_data");
        this.textName.getShell().setMinimumSize(300, 0);
        this.textName.setTextLimit(63);
        this.textName.setFocus();
        if (this.policy != null) {
            this.textName.setText(this.policy.getName());
        } else {
            this.typeSelector = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)"Policy type", (Object)"WidgetHelper::default_layout_data");
            this.typeSelector.add("AgentConfig");
            this.typeSelector.add("LogParserConfig");
            this.typeSelector.add("SupportApplicationConfig");
            this.typeSelector.select(0);
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.policyName = this.textName.getText().trim();
        if (this.policy == null) {
            this.policyType = this.typeSelector.getText();
        }
        if (this.policyName.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Policy name can not be empty");
            return;
        }
        super.okPressed();
    }

    public AgentPolicy getPolicy() {
        if (this.policy == null) {
            return new AgentPolicy(this.policyName, this.policyType);
        }
        this.policy.setName(this.policyName);
        return this.policy;
    }
}

