/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.ui.eclipse.datacollection.widgets.AbstractPolicyEditor;
import org.netxms.ui.eclipse.widgets.AgentConfigEditor;

public class AgentConfigPolicyEditor
extends AbstractPolicyEditor {
    private AgentConfigEditor editor;

    public AgentConfigPolicyEditor(Composite parent, int style, AgentPolicy policy) {
        super(parent, style);
        this.policy = policy;
        this.setLayout((Layout)new FillLayout());
        this.editor = new AgentConfigEditor((Composite)this, 2048, 768);
        this.editor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AgentConfigPolicyEditor.this.fireModifyListeners();
                AgentConfigPolicyEditor.this.actionFindReplace.update();
            }
        });
        this.updateControlsFromPolicy();
    }

    @Override
    protected void updateControlsFromPolicy() {
        this.editor.setText(this.policy.getContent());
    }

    @Override
    public AgentPolicy getUpdatedPolicy() {
        this.policy.setContent(this.editor.getText());
        return this.policy;
    }

    public boolean setFocus() {
        return this.editor.setFocus();
    }

    public boolean canPerformFind() {
        return this.editor.getFindReplaceTarget().canPerformFind();
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.editor.getFindReplaceTarget().findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
    }

    public Point getSelection() {
        return this.editor.getFindReplaceTarget().getSelection();
    }

    public String getSelectionText() {
        return this.editor.getFindReplaceTarget().getSelectionText();
    }

    public boolean isEditable() {
        return true;
    }

    public void replaceSelection(String text) {
        this.editor.getFindReplaceTarget().replaceSelection(text);
    }

    @Override
    public boolean isFindReplaceRequired() {
        return true;
    }
}

