/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ServiceComponentsConfig;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class ServiceComponents
extends PropertyPage {
    private ServiceComponentsConfig config;
    private ObjectSelector objectSelector;
    private LabeledText title;
    private Scale zoomLevelScale;
    private Spinner zoomLevelSpinner;
    private Button enableObjectDoubleClick;
    private Button checkShowStatusIcon;
    private Button checkShowStatusFrame;
    private Button checkShowStatusBkgnd;
    private Combo objectDisplayMode;
    private Combo routingAlgorithm;
    private Combo layoutAlgorithm;
    private Button radioColorDefault;
    private Button radioColorCustom;
    private ColorSelector linkColor;

    protected Control createContents(Composite parent) {
        this.config = (ServiceComponentsConfig)this.getElement().getAdapter(ServiceComponentsConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, false);
        this.objectSelector.setLabel("Container");
        this.objectSelector.setClassFilter(ObjectSelectionDialog.createContainerSelectionFilter());
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.title = new LabeledText(dialogArea, 0);
        this.title.setLabel("Title");
        this.title.setText(this.config.getTitle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        Label label = new Label(dialogArea, 0);
        label.setText("Zoom level (%)");
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.zoomLevelScale = new Scale(dialogArea, 256);
        this.zoomLevelScale.setMinimum(10);
        this.zoomLevelScale.setMaximum(400);
        this.zoomLevelScale.setSelection(this.config.getZoomLevel());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.zoomLevelScale.setLayoutData((Object)gd);
        this.zoomLevelScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceComponents.this.zoomLevelSpinner.setSelection(ServiceComponents.this.zoomLevelScale.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.zoomLevelSpinner = new Spinner(dialogArea, 2048);
        this.zoomLevelSpinner.setMinimum(10);
        this.zoomLevelSpinner.setMaximum(400);
        this.zoomLevelSpinner.setSelection(this.config.getZoomLevel());
        this.zoomLevelSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceComponents.this.zoomLevelScale.setSelection(ServiceComponents.this.zoomLevelSpinner.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.enableObjectDoubleClick = new Button(dialogArea, 32);
        this.enableObjectDoubleClick.setText("Enable double click action on objects");
        this.enableObjectDoubleClick.setSelection(this.config.isObjectDoubleClickEnabled());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.enableObjectDoubleClick.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 2;
        this.layoutAlgorithm = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Layout algorithm", (Object)gd);
        this.layoutAlgorithm.add("Spring");
        this.layoutAlgorithm.add("Radial");
        this.layoutAlgorithm.add("Horizontal tree");
        this.layoutAlgorithm.add("Vertical tree");
        this.layoutAlgorithm.add("Sparse vertical tree");
        this.layoutAlgorithm.select(this.config.getDefaultLayoutAlgorithm().getValue());
        Group objectDisplayGroup = new Group(dialogArea, 0);
        objectDisplayGroup.setText("Default display options");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        objectDisplayGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        objectDisplayGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectDisplayMode = WidgetHelper.createLabeledCombo((Composite)objectDisplayGroup, (int)8, (String)"Display object as", (Object)gd);
        this.objectDisplayMode.add("Icons");
        this.objectDisplayMode.add("Small labels");
        this.objectDisplayMode.add("Large labels");
        this.objectDisplayMode.add("Status icons");
        this.objectDisplayMode.select(this.config.getObjectDisplayMode().getValue());
        this.checkShowStatusIcon = new Button((Composite)objectDisplayGroup, 32);
        this.checkShowStatusIcon.setText("Show status icon");
        this.checkShowStatusIcon.setSelection((this.config.getFlags() & 1) != 0);
        this.checkShowStatusFrame = new Button((Composite)objectDisplayGroup, 32);
        this.checkShowStatusFrame.setText("Show status frame");
        this.checkShowStatusFrame.setSelection((this.config.getFlags() & 2) != 0);
        this.checkShowStatusBkgnd = new Button((Composite)objectDisplayGroup, 32);
        this.checkShowStatusBkgnd.setText("Show status background");
        this.checkShowStatusBkgnd.setSelection((this.config.getFlags() & 4) != 0);
        Group linkGroup = new Group(dialogArea, 0);
        linkGroup.setText("Default connection options");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        linkGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        linkGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.routingAlgorithm = WidgetHelper.createLabeledCombo((Composite)linkGroup, (int)8, (String)"Routing algorithm", (Object)gd);
        this.routingAlgorithm.add("Direct");
        this.routingAlgorithm.add("Manhattan");
        this.routingAlgorithm.select(this.config.getDefaultLinkRouting() - 1);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceComponents.this.linkColor.setEnabled(ServiceComponents.this.radioColorCustom.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioColorDefault = new Button((Composite)linkGroup, 16);
        this.radioColorDefault.setText("Default color");
        this.radioColorDefault.setSelection(this.config.getDefaultLinkColor() < 0);
        this.radioColorDefault.addSelectionListener(listener);
        gd = new GridData();
        gd.verticalIndent = 8;
        this.radioColorDefault.setLayoutData((Object)gd);
        this.radioColorCustom = new Button((Composite)linkGroup, 16);
        this.radioColorCustom.setText("Custom color");
        this.radioColorCustom.setSelection(this.config.getDefaultLinkColor() >= 0);
        this.radioColorCustom.addSelectionListener(listener);
        this.linkColor = new ColorSelector((Composite)linkGroup);
        this.linkColor.setColorValue(ColorConverter.rgbFromInt((int)this.config.getDefaultLinkColor()));
        this.linkColor.setEnabled(this.config.getDefaultLinkColor() >= 0);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.linkColor.getButton().setLayoutData((Object)gd);
        return dialogArea;
    }

    public boolean performOk() {
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setTitle(this.title.getText());
        this.config.setZoomLevel(this.zoomLevelSpinner.getSelection());
        this.config.setObjectDoubleClickEnabled(this.enableObjectDoubleClick.getSelection());
        this.config.setObjectDisplayMode(MapObjectDisplayMode.getByValue((int)this.objectDisplayMode.getSelectionIndex()));
        this.config.setDefaultLayoutAlgorithm(MapLayoutAlgorithm.getByValue((int)this.layoutAlgorithm.getSelectionIndex()));
        if (this.checkShowStatusIcon.getSelection()) {
            this.config.setFlags(this.config.getFlags() | 1);
        } else {
            this.config.setFlags(this.config.getFlags() & 0xFFFFFFFE);
        }
        if (this.checkShowStatusFrame.getSelection()) {
            this.config.setFlags(this.config.getFlags() | 2);
        } else {
            this.config.setFlags(this.config.getFlags() & 0xFFFFFFFD);
        }
        if (this.checkShowStatusBkgnd.getSelection()) {
            this.config.setFlags(this.config.getFlags() | 4);
        } else {
            this.config.setFlags(this.config.getFlags() & 0xFFFFFFFB);
        }
        this.config.setDefaultLinkRouting(this.routingAlgorithm.getSelectionIndex() + 1);
        if (this.radioColorDefault.getSelection()) {
            this.config.setDefaultLinkColor(-1);
        } else {
            this.config.setDefaultLinkColor(ColorConverter.rgbToInt((RGB)this.linkColor.getColorValue()));
        }
        return true;
    }
}

