/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditGroupBoxDialog
extends Dialog {
    private static final RGB DEFAULT_COLOR = new RGB(64, 105, 156);
    private LabeledText textTitle;
    private Spinner spinnerWidth;
    private Spinner spinnerHeight;
    private ColorSelector colorSelector;
    private NetworkMapDecoration groupBox;

    public EditGroupBoxDialog(Shell parentShell, NetworkMapDecoration groupBox) {
        super(parentShell);
        this.groupBox = groupBox;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.AddGroupBoxDialog_DialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        this.textTitle = new LabeledText(dialogArea, 0);
        Messages.get();
        this.textTitle.setLabel(Messages.AddGroupBoxDialog_Title);
        this.textTitle.setText(this.groupBox.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textTitle.setLayoutData((Object)gd);
        Composite attrArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 4;
        attrArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        attrArea.setLayoutData((Object)gd);
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                Spinner spinner = new Spinner(parent, style | 0x800);
                spinner.setMinimum(20);
                spinner.setMaximum(4096);
                return spinner;
            }
        };
        Messages.get();
        this.spinnerWidth = (Spinner)WidgetHelper.createLabeledControl((Composite)attrArea, (int)0, (WidgetFactory)factory, (String)Messages.AddGroupBoxDialog_Width, (Object)"WidgetHelper::default_layout_data");
        this.spinnerWidth.setSelection(this.groupBox.getWidth());
        Messages.get();
        this.spinnerHeight = (Spinner)WidgetHelper.createLabeledControl((Composite)attrArea, (int)0, (WidgetFactory)factory, (String)Messages.AddGroupBoxDialog_Height, (Object)"WidgetHelper::default_layout_data");
        this.spinnerHeight.setSelection(this.groupBox.getHeight());
        Messages.get();
        this.colorSelector = WidgetHelper.createLabeledColorSelector((Composite)attrArea, (String)Messages.AddGroupBoxDialog_Color, (Object)"WidgetHelper::default_layout_data");
        this.colorSelector.setColorValue(DEFAULT_COLOR);
        return dialogArea;
    }

    protected void okPressed() {
        this.groupBox.setTitle(this.textTitle.getText());
        this.groupBox.setSize(this.spinnerWidth.getSelection(), this.spinnerHeight.getSelection());
        this.groupBox.setColor(ColorConverter.rgbToInt((RGB)this.colorSelector.getColorValue()));
        super.okPressed();
    }
}

