/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyCode;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyGenerator$generator_throw$_exposer;
import org.python.core.PyGenerator$gi_frame_descriptor;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTraceback;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.Visitproc;
import org.python.core.finalization.FinalizableBuiltin;
import org.python.core.finalization.FinalizeTrigger;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedType;

@ExposedType(name="generator", base=PyObject.class, isBaseType=false)
public class PyGenerator
extends PyIterator
implements FinalizableBuiltin {
    public static final PyType TYPE;
    protected PyFrame gi_frame;
    protected PyCode gi_code = null;
    protected boolean gi_running;
    private PyObject closure;

    public PyGenerator(PyFrame frame, PyObject closure) {
        super(TYPE);
        this.gi_frame = frame;
        if (this.gi_frame != null) {
            this.gi_code = this.gi_frame.f_code;
        }
        this.closure = closure;
        FinalizeTrigger.ensureFinalizer(this);
    }

    public String getName() {
        return this.gi_code.co_name;
    }

    public PyObject send(PyObject value) {
        return this.generator_send(value);
    }

    final PyObject generator_send(PyObject value) {
        if (this.gi_frame == null) {
            throw Py.StopIteration("");
        }
        if (this.gi_frame.f_lasti == 0 && value != Py.None) {
            throw Py.TypeError("can't send non-None value to a just-started generator");
        }
        this.gi_frame.setGeneratorInput(value);
        return this.next();
    }

    public PyObject throw$(PyObject type, PyObject value, PyObject tb) {
        return this.generator_throw$(type, value, tb);
    }

    final PyObject generator_throw$(PyObject type, PyObject value, PyObject tb) {
        if (tb == Py.None) {
            tb = null;
        } else if (tb != null && !(tb instanceof PyTraceback)) {
            throw Py.TypeError("throw() third argument must be a traceback object");
        }
        return this.raiseException(Py.makeException(type, value, tb));
    }

    public PyObject close() {
        return this.generator_close();
    }

    final PyObject generator_close() {
        try {
            this.raiseException(Py.makeException(Py.GeneratorExit));
            throw Py.RuntimeError("generator ignored GeneratorExit");
        }
        catch (PyException e) {
            if (e.type != Py.StopIteration && e.type != Py.GeneratorExit) {
                throw e;
            }
            return Py.None;
        }
    }

    @Override
    public PyObject next() {
        return this.generator_next();
    }

    final PyObject generator_next() {
        return super.next();
    }

    @Override
    public PyObject __iter__() {
        return this.generator___iter__();
    }

    final PyObject generator___iter__() {
        return this;
    }

    private PyObject raiseException(PyException ex) {
        if (this.gi_frame == null || this.gi_frame.f_lasti == 0) {
            this.gi_frame = null;
            throw ex;
        }
        this.gi_frame.setGeneratorInput(ex);
        return this.next();
    }

    @Override
    public void __del_builtin__() {
        if (this.gi_frame == null || this.gi_frame.f_lasti == -1) {
            return;
        }
        try {
            this.close();
        }
        catch (PyException pye) {
            String className = PyException.exceptionClassName(pye.type);
            int lastDot = className.lastIndexOf(46);
            if (lastDot != -1) {
                className = className.substring(lastDot + 1);
            }
            String msg = String.format("Exception %s: %s in %s", className, pye.value.__repr__(), this.__repr__());
            Py.println(Py.getSystemState().stderr, Py.newString(msg));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public PyObject __iternext__() {
        return this.__iternext__(Py.getThreadState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyObject __iternext__(ThreadState state) {
        if (this.gi_running) {
            throw Py.ValueError("generator already executing");
        }
        if (this.gi_frame == null) {
            return null;
        }
        if (this.gi_frame.f_lasti == -1) {
            this.gi_frame = null;
            return null;
        }
        this.gi_running = true;
        PyObject result2 = null;
        try {
            result2 = this.gi_frame.f_code.call(state, this.gi_frame, this.closure);
        }
        catch (PyException pye) {
            if (pye.type != Py.StopIteration && pye.type != Py.GeneratorExit) {
                this.gi_frame = null;
                throw pye;
            }
            this.stopException = pye;
            this.gi_frame = null;
            PyObject pyObject = null;
            return pyObject;
        }
        finally {
            this.gi_running = false;
        }
        if (result2 == Py.None && this.gi_frame.f_lasti == -1) {
            return null;
        }
        return result2;
    }

    @Override
    public String toString() {
        return this.generator_toString();
    }

    final String generator_toString() {
        return String.format("<generator object %s at %s>", this.getName(), Py.idstr(this));
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retValue = super.traverse(visit, arg);
        if (retValue != 0) {
            return retValue;
        }
        if (this.gi_frame != null && (retValue = visit.visit(this.gi_frame, arg)) != 0) {
            return retValue;
        }
        if (this.gi_code != null && (retValue = visit.visit(this.gi_code, arg)) != 0) {
            return retValue;
        }
        return this.closure == null ? 0 : visit.visit(this.closure, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.gi_frame || ob == this.gi_code || ob == this.closure || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(PyGenerator.class, new PyGenerator$PyExposer());
        TYPE = PyType.fromClass(PyGenerator.class);
    }

    public class PyGenerator$generator_send_exposer
    extends PyBuiltinMethodNarrow {
        public PyGenerator$generator_send_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyGenerator$generator_send_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyGenerator$generator_send_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyGenerator)this.self).generator_send(pyObject);
        }
    }

    public class PyGenerator$generator_close_exposer
    extends PyBuiltinMethodNarrow {
        public PyGenerator$generator_close_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyGenerator$generator_close_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyGenerator$generator_close_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyGenerator)this.self).generator_close();
        }
    }

    public class PyGenerator$generator_next_exposer
    extends PyBuiltinMethodNarrow {
        public PyGenerator$generator_next_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.next() -> the next value, or raise StopIteration";
        }

        public PyGenerator$generator_next_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.next() -> the next value, or raise StopIteration";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyGenerator$generator_next_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyGenerator)this.self).generator_next();
        }
    }

    public class PyGenerator$generator___iter___exposer
    extends PyBuiltinMethodNarrow {
        public PyGenerator$generator___iter___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyGenerator$generator___iter___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyGenerator$generator___iter___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyGenerator)this.self).generator___iter__();
        }
    }

    public class PyGenerator$generator_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyGenerator$generator_toString_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyGenerator$generator_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyGenerator$generator_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            String string2 = ((PyGenerator)this.self).generator_toString();
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyGenerator$gi_code_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyGenerator$gi_code_descriptor() {
            super("gi_code", PyCode.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PyGenerator)pyObject).gi_code;
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyGenerator$__name___descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyGenerator$__name___descriptor() {
            super("__name__", String.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            String string2 = ((PyGenerator)pyObject).getName();
            return string2 == null ? Py.None : Py.newString(string2);
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyGenerator$gi_running_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PyGenerator$gi_running_descriptor() {
            super("gi_running", Boolean.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return Py.newBoolean(((PyGenerator)pyObject).gi_running);
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PyGenerator$PyExposer
    extends BaseTypeBuilder {
        public PyGenerator$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyGenerator$generator_send_exposer("send"), new PyGenerator$generator_throw$_exposer("throw"), new PyGenerator$generator_close_exposer("close"), new PyGenerator$generator_next_exposer("next"), new PyGenerator$generator___iter___exposer("__iter__"), new PyGenerator$generator_toString_exposer("__repr__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PyGenerator$gi_code_descriptor(), new PyGenerator$__name___descriptor(), new PyGenerator$gi_frame_descriptor(), new PyGenerator$gi_running_descriptor()};
            super("generator", PyGenerator.class, PyObject.class, false, null, pyBuiltinMethodArray, pyDataDescrArray, null);
        }
    }
}

