/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.DeflaterOutputStream;
import com.jcraft.jzlib.InflaterInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.CRC32;
import org.netxms.base.EncryptionContext;
import org.netxms.base.InetAddressEx;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPDataInputStream;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPMessageField;

public class NXCPMessage {
    public static final int HEADER_SIZE = 16;
    public static final int ENCRYPTION_HEADER_SIZE = 8;
    public static final int MF_BINARY = 1;
    public static final int MF_END_OF_FILE = 2;
    public static final int MF_DONT_ENCRYPT = 4;
    public static final int MF_END_OF_SEQUENCE = 8;
    public static final int MF_REVERSE_ORDER = 16;
    public static final int MF_CONTROL = 32;
    public static final int MF_COMPRESSED = 64;
    public static final int MF_STREAM = 128;
    private int messageCode;
    private int messageFlags;
    private long messageId;
    private Map<Long, NXCPMessageField> fields = new HashMap<Long, NXCPMessageField>(0);
    private long timestamp;
    private byte[] binaryData = null;
    private long controlData = 0L;

    public NXCPMessage(int msgCode) {
        this.messageCode = msgCode;
        this.messageId = 0L;
        this.messageFlags = 0;
    }

    public NXCPMessage(int msgCode, long msgId) {
        this.messageCode = msgCode;
        this.messageId = msgId;
        this.messageFlags = 0;
    }

    public NXCPMessage(byte[] nxcpMessage, EncryptionContext ectx) throws IOException, NXCPException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(nxcpMessage);
        NXCPDataInputStream inputStream = new NXCPDataInputStream(byteArrayInputStream);
        this.messageCode = inputStream.readUnsignedShort();
        if (this.messageCode == 131) {
            byte[] payload;
            if (ectx == null) {
                inputStream.close();
                throw new NXCPException(4);
            }
            byte padding = inputStream.readByte();
            inputStream.skipBytes(1);
            int msgLen = inputStream.readInt();
            try {
                payload = ectx.decryptMessage(inputStream, msgLen - padding - 8);
            }
            catch (GeneralSecurityException e) {
                throw new NXCPException(4, (Throwable)e);
            }
            ByteArrayInputStream payloadByteArrayInputStream = new ByteArrayInputStream(payload);
            NXCPDataInputStream payloadInputStream = new NXCPDataInputStream(payloadByteArrayInputStream);
            CRC32 crc32 = new CRC32();
            crc32.update(payload, 8, payload.length - 8);
            if (payloadInputStream.readUnsignedInt() != crc32.getValue()) {
                payloadInputStream.close();
                throw new NXCPException(4);
            }
            payloadInputStream.skip(4L);
            this.messageCode = payloadInputStream.readUnsignedShort();
            this.createFromStream(payloadInputStream);
        } else {
            this.createFromStream(inputStream);
        }
    }

    private void createFromStream(NXCPDataInputStream inputStream) throws IOException {
        this.messageFlags = inputStream.readUnsignedShort();
        inputStream.skipBytes(4);
        this.messageId = inputStream.readInt();
        if ((this.messageFlags & 1) == 1) {
            int size = inputStream.readInt();
            this.binaryData = new byte[size];
            if ((this.messageFlags & 0x40) == 64 && (this.messageFlags & 0x80) == 0) {
                inputStream.skip(4L);
                inputStream = new NXCPDataInputStream(new InflaterInputStream(inputStream));
            }
            inputStream.readFully(this.binaryData);
        } else if ((this.messageFlags & 0x20) == 32) {
            this.controlData = inputStream.readUnsignedInt();
        } else {
            int numVars = inputStream.readInt();
            if ((this.messageFlags & 0x40) == 64) {
                inputStream.skip(4L);
                inputStream = new NXCPDataInputStream(new InflaterInputStream(inputStream));
            }
            for (int i = 0; i < numVars; ++i) {
                byte[] df = new byte[32];
                inputStream.readFully(df, 0, 8);
                switch (df[4]) {
                    case 3: {
                        break;
                    }
                    case 0: 
                    case 2: 
                    case 5: {
                        inputStream.readFully(df, 8, 8);
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 7: {
                        int size = inputStream.readInt();
                        df = Arrays.copyOf(df, size + 12);
                        NXCPMessage.intToBytes(size, df, 8);
                        inputStream.readFully(df, 12, size);
                        int rem = (size + 12) % 8;
                        if (rem == 0) break;
                        inputStream.skipBytes(8 - rem);
                        break;
                    }
                    case 6: {
                        inputStream.readFully(df, 8, 24);
                    }
                }
                NXCPMessageField variable = new NXCPMessageField(df);
                this.fields.put(variable.getId(), variable);
            }
        }
    }

    private static void intToBytes(int value, byte[] data, int offset) throws ArrayIndexOutOfBoundsException {
        data[offset] = (byte)(value >> 24);
        data[offset + 1] = (byte)(value >> 16 & 0xFF);
        data[offset + 2] = (byte)(value >> 8 & 0xFF);
        data[offset + 3] = (byte)(value & 0xFF);
    }

    public int getMessageCode() {
        return this.messageCode;
    }

    public void setMessageCode(int msgCode) {
        this.messageCode = msgCode;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(long msgId) {
        this.messageId = msgId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public NXCPMessageField findField(long fieldId) {
        return this.fields.get(fieldId);
    }

    public boolean isFieldPresent(long fieldId) {
        return this.fields.containsKey(fieldId);
    }

    public void setField(NXCPMessageField src) {
        this.fields.put(src.getId(), src);
    }

    public void setField(long fieldId, byte[] value) {
        this.setField(new NXCPMessageField(fieldId, value));
    }

    public void setField(long fieldId, long[] value) {
        this.setField(new NXCPMessageField(fieldId, value));
    }

    public void setField(long fieldId, Long[] value) {
        this.setField(new NXCPMessageField(fieldId, value));
    }

    public void setField(long fieldId, String value) {
        this.setField(new NXCPMessageField(fieldId, value));
    }

    public void setField(long fieldId, String value, boolean forceUcsEncoding) {
        this.setField(new NXCPMessageField(fieldId, value, forceUcsEncoding));
    }

    public void setField(long fieldId, Double value) {
        this.setField(new NXCPMessageField(fieldId, value));
    }

    public void setField(long fieldId, InetAddress value) {
        this.setField(new NXCPMessageField(fieldId, value));
    }

    public void setField(long fieldId, InetAddressEx value) {
        this.setField(new NXCPMessageField(fieldId, value));
    }

    public void setField(long fieldId, UUID value) {
        this.setField(new NXCPMessageField(fieldId, value));
    }

    public void setFieldInt64(long fieldId, long value) {
        this.setField(new NXCPMessageField(fieldId, 2, value));
    }

    public void setFieldInt32(long fieldId, int value) {
        this.setField(new NXCPMessageField(fieldId, 0, Long.valueOf(value)));
    }

    public void setFieldInt16(long fieldId, int value) {
        this.setField(new NXCPMessageField(fieldId, 3, Long.valueOf(value)));
    }

    public void setField(long fieldId, boolean value) {
        this.setField(new NXCPMessageField(fieldId, 3, value ? 1L : 0L));
    }

    public void setField(long fieldId, Date value) {
        this.setField(new NXCPMessageField(fieldId, 2, value != null ? value.getTime() / 1000L : 0L));
    }

    public void setField(long fieldId, MacAddress value) {
        if (value == null) {
            return;
        }
        this.setField(fieldId, value.getValue());
    }

    public byte[] getFieldAsBinary(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsBinary() : null;
    }

    public String getFieldAsString(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsString() : "";
    }

    public Double getFieldAsDouble(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsReal() : 0.0;
    }

    public short getFieldAsInt16(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsInteger().shortValue() : (short)0;
    }

    public int getFieldAsInt32(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsInteger().intValue() : 0;
    }

    public long getFieldAsInt64(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsInteger() : 0L;
    }

    public InetAddress getFieldAsInetAddress(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsInetAddress() : null;
    }

    public MacAddress getFieldAsMacAddress(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? new MacAddress(var.getAsBinary()) : null;
    }

    public InetAddressEx getFieldAsInetAddressEx(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsInetAddressEx() : null;
    }

    public UUID getFieldAsUUID(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsUUID() : null;
    }

    public long[] getFieldAsUInt32Array(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsUInt32Array() : null;
    }

    public Long[] getFieldAsUInt32ArrayEx(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsUInt32ArrayEx() : null;
    }

    public boolean getFieldAsBoolean(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? var.getAsInteger() != 0L : false;
    }

    public Date getFieldAsDate(long fieldId) {
        NXCPMessageField var = this.findField(fieldId);
        return var != null ? new Date(var.getAsInteger() * 1000L) : null;
    }

    public byte[] createNXCPMessage(boolean allowCompression) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteStream);
        if ((this.messageFlags & 0x20) == 32) {
            outputStream.writeShort(this.messageCode);
            outputStream.writeShort(this.messageFlags);
            outputStream.writeInt(16);
            outputStream.writeInt((int)this.messageId);
            outputStream.writeInt((int)this.controlData);
        } else if ((this.messageFlags & 1) == 1) {
            byte[] payload = this.binaryData;
            boolean compressed = false;
            if (allowCompression && (this.messageFlags & 0x80) == 0 && this.binaryData.length > 128) {
                ByteArrayOutputStream compDataByteStream = new ByteArrayOutputStream();
                byte[] length = new byte[4];
                int unpackedPadding = 8 - (this.binaryData.length + 16) % 8 & 7;
                NXCPMessage.intToBytes(unpackedPadding + 16, length, 0);
                compDataByteStream.write(length);
                DeflaterOutputStream deflaterStream = new DeflaterOutputStream(compDataByteStream, new Deflater(9));
                deflaterStream.write(this.binaryData);
                deflaterStream.close();
                byte[] compPayload = compDataByteStream.toByteArray();
                if (compPayload.length < this.binaryData.length) {
                    payload = compPayload;
                    compressed = true;
                }
            }
            outputStream.writeShort(this.messageCode);
            outputStream.writeShort(compressed ? this.messageFlags | 0x40 : this.messageFlags);
            int length = payload.length;
            int padding = 8 - (length + 16) % 8 & 7;
            int packetSize = length + 16 + padding;
            outputStream.writeInt(packetSize);
            outputStream.writeInt((int)this.messageId);
            outputStream.writeInt(this.binaryData.length);
            outputStream.write(payload);
            for (int i = 0; i < padding; ++i) {
                outputStream.writeByte(0);
            }
        } else {
            for (NXCPMessageField nxcpVariable : this.fields.values()) {
                byte[] field = nxcpVariable.createNXCPDataField();
                outputStream.write(field);
            }
            Object payload = byteStream.toByteArray();
            boolean compressed = false;
            if (allowCompression && ((Object)payload).length > 128) {
                byteStream = new ByteArrayOutputStream();
                byte[] length = new byte[4];
                NXCPMessage.intToBytes(((Object)payload).length + 16, length, 0);
                byteStream.write(length);
                DeflaterOutputStream deflaterStream = new DeflaterOutputStream(byteStream, new Deflater(9));
                deflaterStream.write((byte[])payload);
                deflaterStream.close();
                int padding = 8 - byteStream.size() % 8 & 7;
                for (int i = 0; i < padding; ++i) {
                    byteStream.write(0);
                }
                byte[] compPayload = byteStream.toByteArray();
                if (compPayload.length < ((Object)payload).length - 4) {
                    payload = compPayload;
                    compressed = true;
                }
            }
            byteStream = new ByteArrayOutputStream();
            outputStream = new DataOutputStream(byteStream);
            outputStream.writeShort(this.messageCode);
            outputStream.writeShort(this.messageFlags | (compressed ? 64 : 0));
            outputStream.writeInt(((Object)payload).length + 16);
            outputStream.writeInt((int)this.messageId);
            outputStream.writeInt(this.fields.size());
            outputStream.write((byte[])payload);
        }
        return byteStream.toByteArray();
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }

    public boolean isBinaryMessage() {
        return (this.messageFlags & 1) == 1;
    }

    public void setBinaryMessage(boolean isRaw) {
        this.messageFlags = isRaw ? (this.messageFlags |= 1) : (this.messageFlags &= 0xFFFFFFFE);
    }

    public boolean isControlMessage() {
        return (this.messageFlags & 0x20) == 32;
    }

    public void setControl(boolean isControl) {
        this.messageFlags = isControl ? (this.messageFlags |= 0x20) : (this.messageFlags &= 0xFFFFFFDF);
    }

    public boolean isEndOfFile() {
        return (this.messageFlags & 2) == 2;
    }

    public void setEndOfFile(boolean isEOF) {
        this.messageFlags = isEOF ? (this.messageFlags |= 2) : (this.messageFlags &= 0xFFFFFFFD);
    }

    public boolean isEndOfSequence() {
        return (this.messageFlags & 8) == 8;
    }

    public void setEndOfSequence(boolean isEOS) {
        this.messageFlags = isEOS ? (this.messageFlags |= 8) : (this.messageFlags &= 0xFFFFFFF7);
    }

    public boolean isEncryptionDisabled() {
        return (this.messageFlags & 4) == 4;
    }

    public void setEncryptionDisabled(boolean disabled) {
        this.messageFlags = disabled ? (this.messageFlags |= 4) : (this.messageFlags &= 0xFFFFFFFB);
    }

    public long getControlData() {
        return this.controlData;
    }

    public void setControlData(long controlData) {
        this.controlData = controlData;
    }

    public boolean isStream() {
        return (this.messageFlags & 0x80) == 128;
    }

    public boolean isCompressedStream() {
        return (this.messageFlags & 0xC0) == 192;
    }

    public void setStream(boolean isStream, boolean isCompressed) {
        if (isStream) {
            this.messageFlags |= 0x80;
            this.messageFlags = isCompressed ? (this.messageFlags |= 0x40) : (this.messageFlags &= 0xFFFFFFBF);
        } else {
            this.messageFlags &= 0xFFFFFF3F;
        }
    }

    public void setFieldsFromStringCollection(Collection<String> strings, long baseId, long countId) {
        this.setFieldInt32(countId, strings.size());
        long fieldId = baseId;
        for (String s : strings) {
            this.setField(fieldId++, s);
        }
    }

    public List<String> getStringListFromFields(long baseId, long countId) {
        int count2 = this.getFieldAsInt32(countId);
        ArrayList<String> list = new ArrayList<String>(count2);
        for (int i = 0; i < count2; ++i) {
            list.add(this.getFieldAsString(baseId + (long)i));
        }
        return list;
    }

    public String toString() {
        return "NXCPMessage [messageCode=" + this.messageCode + ", messageFlags=" + this.messageFlags + ", messageId=" + this.messageId + ", variableMap=" + this.fields + ", timestamp=" + this.timestamp + "]";
    }
}

