/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.python.core.ArgParser;
import org.python.core.ClasspathPyImporter$ClasspathPyImporter_load_module_exposer;
import org.python.core.ClasspathPyImporterDerived;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PyType;
import org.python.core.Untraversable;
import org.python.core.imp;
import org.python.core.util.FileUtil;
import org.python.core.util.StringUtil;
import org.python.core.util.importer;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.util.Generic;

@Untraversable
@ExposedType(name="ClasspathPyImporter")
public class ClasspathPyImporter
extends importer<String> {
    public static final String PYCLASSPATH_PREFIX = "__pyclasspath__/";
    public static final PyType TYPE;
    private Map<String, InputStream> entries = Generic.map();
    private String path;

    public ClasspathPyImporter(PyType subType) {
        super(subType);
    }

    public ClasspathPyImporter() {
    }

    @ExposedNew
    final void ClasspathPyImporter___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("__init__", args, kwds, new String[]{"path"});
        String path = ap.getString(0);
        if (path == null || !path.startsWith(PYCLASSPATH_PREFIX)) {
            throw Py.ImportError("path isn't for classpath importer");
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.path = path;
    }

    @Override
    public String get_data(String path) {
        return this.ClasspathPyImporter_get_data(path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String ClasspathPyImporter_get_data(String path) {
        int len = PYCLASSPATH_PREFIX.length();
        if (len < path.length() && path.startsWith(PYCLASSPATH_PREFIX)) {
            path = path.substring(len);
        }
        try (importer.Bundle bundle = this.makeBundle(path, this.makeEntry(path));){
            byte[] data = FileUtil.readBytes(bundle.inputStream);
            String string2 = StringUtil.fromBytes(data);
            return string2;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public String get_source(String fullname) {
        return this.ClasspathPyImporter_get_source(fullname);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String ClasspathPyImporter_get_source(String fullname) {
        importer.ModuleInfo moduleInfo = this.getModuleInfo(fullname);
        if (moduleInfo == importer.ModuleInfo.ERROR) {
            return null;
        }
        if (moduleInfo == importer.ModuleInfo.NOT_FOUND) {
            throw Py.ImportError(String.format("can't find module '%s'", fullname));
        }
        String path = this.makeFilename(fullname);
        path = moduleInfo == importer.ModuleInfo.PACKAGE ? path + File.separator + "__init__.py" : path + ".py";
        try (importer.Bundle bundle = this.makeBundle(path, this.makeEntry(path));){
            InputStream is = bundle.inputStream;
            if (is != null) {
                byte[] data = FileUtil.readBytes(is);
                String string2 = StringUtil.fromBytes(data);
                return string2;
            }
            String string3 = null;
            return string3;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    final PyObject ClasspathPyImporter_find_module(String fullname, String path) {
        return this.importer_find_module(fullname, path);
    }

    final boolean ClasspathPyImporter_is_package(String fullname) {
        return this.importer_is_package(fullname);
    }

    final PyObject ClasspathPyImporter_get_code(String fullname) {
        importer.ModuleCodeData moduleCodeData = this.getModuleCode(fullname);
        if (moduleCodeData != null) {
            return moduleCodeData.code;
        }
        return Py.None;
    }

    final PyObject ClasspathPyImporter_load_module(String fullname) {
        return this.importer_load_module(fullname);
    }

    @Override
    protected long getSourceMtime(String path) {
        return -1L;
    }

    @Override
    protected importer.Bundle makeBundle(String fullFilename, String entry) {
        InputStream is = this.entries.remove(entry);
        return new importer.Bundle(is){

            @Override
            public void close() {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    throw Py.JavaError(e);
                }
            }
        };
    }

    @Override
    protected String makeEntry(String filename) {
        if (!this.getSeparator().equals(File.separator)) {
            filename = filename.replace(File.separator, this.getSeparator());
        }
        if (this.entries.containsKey(filename)) {
            return filename;
        }
        InputStream is = Py.getSystemState().getClassLoader() != null ? this.tryClassLoader(filename, Py.getSystemState().getClassLoader(), "sys") : this.tryClassLoader(filename, imp.getParentClassLoader(), "parent");
        if (is != null) {
            this.entries.put(filename, is);
            return filename;
        }
        return null;
    }

    private InputStream tryClassLoader(String fullFilename, ClassLoader loader2, String name) {
        if (loader2 != null) {
            Py.writeDebug("import", "trying " + fullFilename + " in " + name + " class loader");
            return loader2.getResourceAsStream(fullFilename);
        }
        return null;
    }

    @Override
    protected String makeFilename(String fullname) {
        return this.path.replace(PYCLASSPATH_PREFIX, "") + fullname.replace('.', '/');
    }

    @Override
    protected String makeFilePath(String fullname) {
        return this.path + fullname.replace('.', '/');
    }

    @Override
    protected String makePackagePath(String fullname) {
        return this.path;
    }

    @Override
    protected String getSeparator() {
        return "/";
    }

    static {
        PyType.addBuilder(ClasspathPyImporter.class, new ClasspathPyImporter$PyExposer());
        TYPE = PyType.fromClass(ClasspathPyImporter.class);
    }

    public class ClasspathPyImporter$ClasspathPyImporter___init___exposer
    extends PyBuiltinMethod {
        public ClasspathPyImporter$ClasspathPyImporter___init___exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public ClasspathPyImporter$ClasspathPyImporter___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new ClasspathPyImporter$ClasspathPyImporter___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((ClasspathPyImporter)this.self).ClasspathPyImporter___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class ClasspathPyImporter$ClasspathPyImporter_get_data_exposer
    extends PyBuiltinMethodNarrow {
        public ClasspathPyImporter$ClasspathPyImporter_get_data_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public ClasspathPyImporter$ClasspathPyImporter_get_data_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new ClasspathPyImporter$ClasspathPyImporter_get_data_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            String string2 = ((ClasspathPyImporter)this.self).ClasspathPyImporter_get_data(pyObject.asString());
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class ClasspathPyImporter$ClasspathPyImporter_get_source_exposer
    extends PyBuiltinMethodNarrow {
        public ClasspathPyImporter$ClasspathPyImporter_get_source_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public ClasspathPyImporter$ClasspathPyImporter_get_source_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new ClasspathPyImporter$ClasspathPyImporter_get_source_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            String string2 = ((ClasspathPyImporter)this.self).ClasspathPyImporter_get_source(pyObject.asString());
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class ClasspathPyImporter$ClasspathPyImporter_find_module_exposer
    extends PyBuiltinMethodNarrow {
        public ClasspathPyImporter$ClasspathPyImporter_find_module_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "";
        }

        public ClasspathPyImporter$ClasspathPyImporter_find_module_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new ClasspathPyImporter$ClasspathPyImporter_find_module_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((ClasspathPyImporter)this.self).ClasspathPyImporter_find_module(pyObject.asString(), pyObject2.asStringOrNull());
        }

        public PyObject __call__(PyObject pyObject) {
            return ((ClasspathPyImporter)this.self).ClasspathPyImporter_find_module(pyObject.asString(), null);
        }
    }

    public class ClasspathPyImporter$ClasspathPyImporter_is_package_exposer
    extends PyBuiltinMethodNarrow {
        public ClasspathPyImporter$ClasspathPyImporter_is_package_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public ClasspathPyImporter$ClasspathPyImporter_is_package_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new ClasspathPyImporter$ClasspathPyImporter_is_package_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((ClasspathPyImporter)this.self).ClasspathPyImporter_is_package(pyObject.asString()));
        }
    }

    public class ClasspathPyImporter$ClasspathPyImporter_get_code_exposer
    extends PyBuiltinMethodNarrow {
        public ClasspathPyImporter$ClasspathPyImporter_get_code_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public ClasspathPyImporter$ClasspathPyImporter_get_code_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new ClasspathPyImporter$ClasspathPyImporter_get_code_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((ClasspathPyImporter)this.self).ClasspathPyImporter_get_code(pyObject.asString());
        }
    }

    public class ClasspathPyImporter$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            ClasspathPyImporter classpathPyImporter = new ClasspathPyImporter(this.for_type);
            if (bl) {
                classpathPyImporter.ClasspathPyImporter___init__(pyObjectArray, stringArray);
            }
            return classpathPyImporter;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new ClasspathPyImporterDerived(pyType);
        }
    }

    public class ClasspathPyImporter$PyExposer
    extends BaseTypeBuilder {
        public ClasspathPyImporter$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new ClasspathPyImporter$ClasspathPyImporter___init___exposer("__init__"), new ClasspathPyImporter$ClasspathPyImporter_get_data_exposer("get_data"), new ClasspathPyImporter$ClasspathPyImporter_get_source_exposer("get_source"), new ClasspathPyImporter$ClasspathPyImporter_find_module_exposer("find_module"), new ClasspathPyImporter$ClasspathPyImporter_is_package_exposer("is_package"), new ClasspathPyImporter$ClasspathPyImporter_get_code_exposer("get_code"), new ClasspathPyImporter$ClasspathPyImporter_load_module_exposer("load_module")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("ClasspathPyImporter", ClasspathPyImporter.class, Object.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new ClasspathPyImporter$exposed___new__());
        }
    }
}

