/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.sre;

import java.util.ArrayList;
import org.python.core.ArgParser;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyCallIter;
import org.python.core.PyDataDescr;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.imp;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposeAsSuperclass;
import org.python.expose.ExposedType;
import org.python.modules.sre.MatchObject;
import org.python.modules.sre.PatternObject$groups_descriptor;
import org.python.modules.sre.PatternObject$subn_exposer;
import org.python.modules.sre.SRE_STATE;
import org.python.modules.sre.ScannerObject;

@ExposedType(name="SRE_Pattern", doc="Compiled regular expression objects")
public class PatternObject
extends PyObject
implements Traverseproc {
    int[] code;
    public PyString pattern;
    public int groups;
    public PyObject groupindex;
    public int flags;
    PyObject indexgroup;
    public int codesize;

    public PatternObject(PyString pattern, int flags, int[] code2, int groups, PyObject groupindex, PyObject indexgroup) {
        if (pattern != null) {
            this.pattern = pattern;
        }
        this.flags = flags;
        this.code = code2;
        this.codesize = code2.length;
        this.groups = groups;
        this.groupindex = groupindex;
        this.indexgroup = indexgroup;
    }

    public PyString getPattern() {
        if (this.pattern == null) {
            return Py.EmptyString;
        }
        return this.pattern;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getGroups() {
        return this.groups;
    }

    public PyObject getGroupindex() {
        return this.groupindex;
    }

    public PyObject match(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("match", args, kws, "string", "pos", "endpos");
        PyString string2 = PatternObject.extractPyString(ap, 0);
        int start = ap.getInt(1, 0);
        int end = ap.getInt(2, string2.__len__());
        SRE_STATE state = new SRE_STATE(string2, start, end, this.flags);
        state.ptr = state.start;
        int status = state.SRE_MATCH(this.code, 0, 1);
        MatchObject matchObject = this._pattern_new_match(state, string2, status);
        return matchObject != null ? matchObject : Py.None;
    }

    public PyObject search(PyObject[] args, String[] kws) {
        int status;
        int end;
        int start;
        ArgParser ap = new ArgParser("search", args, kws, "string", "pos", "endpos");
        PyString string2 = PatternObject.extractPyString(ap, 0);
        SRE_STATE state = new SRE_STATE(string2, start = ap.getInt(1, 0), end = ap.getInt(2, string2.__len__()), this.flags);
        MatchObject matchObject = this._pattern_new_match(state, string2, status = state.SRE_SEARCH(this.code, 0));
        return matchObject != null ? matchObject : Py.None;
    }

    public PyObject sub(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("sub", args, kws, "repl", "string", "count");
        PyObject template = ap.getPyObject(0);
        int count2 = ap.getInt(2, 0);
        return this.subx(template, PatternObject.extractPyString(ap, 1), count2, false);
    }

    public PyObject subn(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("subn", args, kws, "repl", "string", "count");
        PyObject template = ap.getPyObject(0);
        int count2 = ap.getInt(2, 0);
        return this.subx(template, PatternObject.extractPyString(ap, 1), count2, true);
    }

    private PyObject subx(PyObject template, PyString instring, int count2, boolean subn) {
        PyString string2 = instring;
        PyObject filter = null;
        boolean filter_is_callable = false;
        if (template.isCallable()) {
            filter = template;
            filter_is_callable = true;
        } else {
            boolean literal = false;
            if (template instanceof PyString) {
                boolean bl = literal = template.toString().indexOf(92) < 0;
            }
            if (literal) {
                filter = template;
                filter_is_callable = false;
            } else {
                filter = this.call("re", "_subx", new PyObject[]{this, template});
                filter_is_callable = filter.isCallable();
            }
        }
        SRE_STATE state = new SRE_STATE(string2, 0, Integer.MAX_VALUE, this.flags);
        PyList list = new PyList();
        int n = 0;
        int i = 0;
        while (count2 == 0 || n < count2) {
            state.state_reset();
            state.ptr = state.start;
            int status = state.SRE_SEARCH(this.code, 0);
            if (status <= 0) {
                if (status == 0) break;
                this._error(status);
            }
            int b = state.start;
            int e = state.ptr;
            if (i < b) {
                list.append(string2.__getslice__(Py.newInteger(i), Py.newInteger(b)));
            }
            if (i != b || i != e || n <= 0) {
                PyObject item;
                if (filter_is_callable) {
                    MatchObject match = this._pattern_new_match(state, instring, 1);
                    item = filter.__call__(match);
                } else {
                    item = filter;
                }
                if (item != Py.None) {
                    list.append(item);
                }
                i = e;
                ++n;
            }
            if (state.ptr == state.start) {
                state.start = state.ptr + 1;
                continue;
            }
            state.start = state.ptr;
        }
        if (i < state.endpos) {
            list.append(string2.__getslice__(Py.newInteger(i), Py.newInteger(state.endpos)));
        }
        PyObject outstring = this.join_list(list, string2);
        if (subn) {
            return new PyTuple(outstring, Py.newInteger(n));
        }
        return outstring;
    }

    private PyObject join_list(PyList list, PyString string2) {
        PyObject joiner = string2.__getslice__(Py.Zero, Py.Zero);
        if (list.size() == 0) {
            return joiner;
        }
        return joiner.__getattr__("join").__call__(list);
    }

    public PyObject split(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("split", args, kws, "string", "maxsplit");
        PyString string2 = PatternObject.extractPyString(ap, 0);
        int maxsplit = ap.getInt(1, 0);
        SRE_STATE state = new SRE_STATE(string2, 0, Integer.MAX_VALUE, this.flags);
        PyList list = new PyList();
        int n = 0;
        int last = state.start;
        while (maxsplit == 0 || n < maxsplit) {
            state.state_reset();
            state.ptr = state.start;
            int status = state.SRE_SEARCH(this.code, 0);
            if (status <= 0) {
                if (status == 0) break;
                this._error(status);
            }
            if (state.start == state.ptr) {
                if (last == state.end) break;
                state.start = state.ptr + 1;
                continue;
            }
            PyObject item = string2.__getslice__(Py.newInteger(last), Py.newInteger(state.start));
            list.append(item);
            for (int i = 0; i < this.groups; ++i) {
                String s = state.getslice(i + 1, string2.toString(), false);
                if (s != null) {
                    list.append(string2.createInstance(s));
                    continue;
                }
                list.append(Py.None);
            }
            ++n;
            last = state.start = state.ptr;
        }
        list.append(string2.__getslice__(Py.newInteger(last), Py.newInteger(state.endpos)));
        return list;
    }

    private PyObject call(String module, String function, PyObject[] args) {
        PyObject sre2 = imp.importName(module, true);
        return sre2.invoke(function, args);
    }

    public PyObject findall(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("findall", args, kws, "string", "pos", "endpos");
        PyString string2 = PatternObject.extractPyString(ap, 0);
        int start = ap.getInt(1, 0);
        int end = ap.getInt(2, Integer.MAX_VALUE);
        SRE_STATE state = new SRE_STATE(string2, start, end, this.flags);
        ArrayList<PyObject> list = new ArrayList<PyObject>();
        while (state.start <= state.end) {
            state.state_reset();
            state.ptr = state.start;
            int status = state.SRE_SEARCH(this.code, 0);
            if (status > 0) {
                PyObject item;
                switch (this.groups) {
                    case 0: {
                        item = string2.__getslice__(Py.newInteger(state.start), Py.newInteger(state.ptr));
                        break;
                    }
                    case 1: {
                        item = string2.createInstance(state.getslice(1, string2.toString(), true));
                        break;
                    }
                    default: {
                        PyObject[] t = new PyObject[this.groups];
                        for (int i = 0; i < this.groups; ++i) {
                            t[i] = string2.createInstance(state.getslice(i + 1, string2.toString(), true));
                        }
                        item = new PyTuple(t);
                    }
                }
                list.add(item);
                if (state.ptr == state.start) {
                    state.start = state.ptr + 1;
                    continue;
                }
                state.start = state.ptr;
                continue;
            }
            if (status == 0) break;
            this._error(status);
        }
        return new PyList(list);
    }

    public PyObject finditer(PyObject[] args, String[] kws) {
        ScannerObject scanner2 = this.scanner(args, kws);
        PyObject search = scanner2.__findattr__("search");
        return new PyCallIter(search, Py.None);
    }

    public ScannerObject scanner(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("scanner", args, kws, "pattern", "pos", "endpos");
        PyString string2 = PatternObject.extractPyString(ap, 0);
        ScannerObject self = new ScannerObject();
        self.state = new SRE_STATE(string2, ap.getInt(1, 0), ap.getInt(2, Integer.MAX_VALUE), this.flags);
        self.pattern = this;
        self.string = string2;
        return self;
    }

    private void _error(int status) {
        if (status == -3) {
            throw Py.RuntimeError("maximum recursion limit exceeded");
        }
        throw Py.RuntimeError("internal error in regular expression engine");
    }

    MatchObject _pattern_new_match(SRE_STATE state, PyString string2, int status) {
        if (status > 0) {
            MatchObject match = new MatchObject();
            match.pattern = this;
            match.string = string2;
            match.regs = null;
            match.groups = this.groups + 1;
            int base2 = state.beginning;
            match.mark = new int[match.groups * 2];
            match.mark[0] = state.start - base2;
            match.mark[1] = state.ptr - base2;
            int j = 0;
            int i = 0;
            while (i < this.groups) {
                if (j + 1 <= state.lastmark && state.mark[j] != -1 && state.mark[j + 1] != -1) {
                    match.mark[j + 2] = state.mark[j] - base2;
                    match.mark[j + 3] = state.mark[j + 1] - base2;
                } else {
                    match.mark[j + 3] = -1;
                    match.mark[j + 2] = -1;
                }
                ++i;
                j += 2;
            }
            match.pos = state.pos;
            match.endpos = state.endpos;
            match.lastindex = state.lastindex;
            return match;
        }
        if (status == 0) {
            return null;
        }
        this._error(status);
        return null;
    }

    private static PyString extractPyString(ArgParser ap, int pos) {
        PyObject obj = ap.getPyObject(pos);
        if (obj instanceof PyString) {
            return (PyString)obj;
        }
        if (obj instanceof BufferProtocol) {
            try (PyBuffer buf = ((BufferProtocol)((Object)obj)).getBuffer(284);){
                PyString pyString = new PyString(buf.toString());
                return pyString;
            }
        }
        throw Py.TypeError("expected string or buffer, but got " + obj.getType());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.pattern != null && (retVal = visit.visit(this.pattern, arg)) != 0) {
            return retVal;
        }
        if (this.groupindex != null && (retVal = visit.visit(this.groupindex, arg)) != 0) {
            return retVal;
        }
        return this.indexgroup != null ? visit.visit(this.indexgroup, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.pattern || ob == this.groupindex || ob == this.indexgroup);
    }

    static {
        PyType.addBuilder(PatternObject.class, new PatternObject$PyExposer());
    }

    public class PatternObject$match_exposer
    extends PyBuiltinMethod {
        public PatternObject$match_exposer(String string2) {
            super(string2);
            this.doc = "match(string[, pos[, endpos]]) --> match object or None.\n    Matches zero or more characters at the beginning of the string";
        }

        public PatternObject$match_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "match(string[, pos[, endpos]]) --> match object or None.\n    Matches zero or more characters at the beginning of the string";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PatternObject$match_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PatternObject)this.self).match(pyObjectArray, stringArray);
        }
    }

    public class PatternObject$search_exposer
    extends PyBuiltinMethod {
        public PatternObject$search_exposer(String string2) {
            super(string2);
            this.doc = "search(string[, pos[, endpos]]) --> match object or None.\n    Scan through string looking for a match, and return a corresponding\n    match object instance. Return None if no position in the string matches.";
        }

        public PatternObject$search_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "search(string[, pos[, endpos]]) --> match object or None.\n    Scan through string looking for a match, and return a corresponding\n    match object instance. Return None if no position in the string matches.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PatternObject$search_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PatternObject)this.self).search(pyObjectArray, stringArray);
        }
    }

    public class PatternObject$sub_exposer
    extends PyBuiltinMethod {
        public PatternObject$sub_exposer(String string2) {
            super(string2);
            this.doc = "sub(repl, string[, count = 0]) --> newstring\n    Return the string obtained by replacing the leftmost non-overlapping\n    occurrences of pattern in string by the replacement repl.";
        }

        public PatternObject$sub_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "sub(repl, string[, count = 0]) --> newstring\n    Return the string obtained by replacing the leftmost non-overlapping\n    occurrences of pattern in string by the replacement repl.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PatternObject$sub_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PatternObject)this.self).sub(pyObjectArray, stringArray);
        }
    }

    public class PatternObject$split_exposer
    extends PyBuiltinMethod {
        public PatternObject$split_exposer(String string2) {
            super(string2);
            this.doc = "split(string[, maxsplit = 0])  --> list.\n    Split string by the occurrences of pattern.";
        }

        public PatternObject$split_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "split(string[, maxsplit = 0])  --> list.\n    Split string by the occurrences of pattern.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PatternObject$split_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PatternObject)this.self).split(pyObjectArray, stringArray);
        }
    }

    public class PatternObject$findall_exposer
    extends PyBuiltinMethod {
        public PatternObject$findall_exposer(String string2) {
            super(string2);
            this.doc = "findall(string[, pos[, endpos]]) --> list.\n   Return a list of all non-overlapping matches of pattern in string.";
        }

        public PatternObject$findall_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "findall(string[, pos[, endpos]]) --> list.\n   Return a list of all non-overlapping matches of pattern in string.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PatternObject$findall_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PatternObject)this.self).findall(pyObjectArray, stringArray);
        }
    }

    public class PatternObject$finditer_exposer
    extends PyBuiltinMethod {
        public PatternObject$finditer_exposer(String string2) {
            super(string2);
            this.doc = "finditer(string[, pos[, endpos]]) --> iterator.\n    Return an iterator over all non-overlapping matches for the \n    RE pattern in string. For each match, the iterator returns a\n    match object.";
        }

        public PatternObject$finditer_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "finditer(string[, pos[, endpos]]) --> iterator.\n    Return an iterator over all non-overlapping matches for the \n    RE pattern in string. For each match, the iterator returns a\n    match object.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PatternObject$finditer_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PatternObject)this.self).finditer(pyObjectArray, stringArray);
        }
    }

    public class PatternObject$scanner_exposer
    extends PyBuiltinMethod {
        public PatternObject$scanner_exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public PatternObject$scanner_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PatternObject$scanner_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            return ((PatternObject)this.self).scanner(pyObjectArray, stringArray);
        }
    }

    public class PatternObject$pattern_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PatternObject$pattern_descriptor() {
            super("pattern", PyString.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PatternObject)pyObject).getPattern();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PatternObject$flags_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PatternObject$flags_descriptor() {
            super("flags", Integer.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return Py.newInteger(((PatternObject)pyObject).getFlags());
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PatternObject$groupindex_descriptor
    extends PyDataDescr
    implements ExposeAsSuperclass {
        public PatternObject$groupindex_descriptor() {
            super("groupindex", PyObject.class, null);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((PatternObject)pyObject).getGroupindex();
        }

        public boolean implementsDescrGet() {
            return true;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class PatternObject$PyExposer
    extends BaseTypeBuilder {
        public PatternObject$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PatternObject$match_exposer("match"), new PatternObject$search_exposer("search"), new PatternObject$sub_exposer("sub"), new PatternObject$subn_exposer("subn"), new PatternObject$split_exposer("split"), new PatternObject$findall_exposer("findall"), new PatternObject$finditer_exposer("finditer"), new PatternObject$scanner_exposer("scanner")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new PatternObject$pattern_descriptor(), new PatternObject$flags_descriptor(), new PatternObject$groupindex_descriptor(), new PatternObject$groups_descriptor()};
            super("SRE_Pattern", PatternObject.class, Object.class, true, "Compiled regular expression objects", pyBuiltinMethodArray, pyDataDescrArray, null);
        }
    }
}

