/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.random;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Random;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Untraversable;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.random.PyRandomDerived;

@Untraversable
@ExposedType(name="_random.Random")
public class PyRandom
extends PyObject {
    public static final PyType TYPE;
    protected Random javaRandom = new Random();

    public PyRandom() {
        this(TYPE);
    }

    public PyRandom(PyType subType) {
        super(subType);
    }

    final void Random_seed(PyObject seed) {
        long n;
        if (seed == null) {
            seed = new PyLong(System.currentTimeMillis());
        }
        if (seed instanceof PyLong) {
            PyLong max = new PyLong(Long.MAX_VALUE);
            n = seed.__mod__(max).asLong();
        } else {
            n = seed instanceof PyInteger ? seed.asLong() : (long)seed.hashCode();
        }
        this.javaRandom.setSeed(n);
    }

    @ExposedNew
    final void Random___init__(PyObject[] args, String[] keywords) {
    }

    final void Random_jumpahead(PyObject arg0) {
        if (!(arg0 instanceof PyInteger) && !(arg0 instanceof PyLong)) {
            throw Py.TypeError(String.format("jumpahead requires an integer, not '%s'", arg0.getType().fastGetName()));
        }
        for (long i = arg0.asLong(); i > 0L; --i) {
            this.javaRandom.nextInt();
        }
    }

    final void Random_setstate(PyObject arg0) {
        if (!(arg0 instanceof PyTuple)) {
            throw Py.TypeError("state vector must be a tuple");
        }
        try {
            Object[] arr = ((PyTuple)arg0).toArray();
            byte[] b = new byte[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] instanceof Integer)) {
                    throw Py.TypeError("state vector of unexpected type: " + arr[i].getClass());
                }
                b[i] = ((Integer)arr[i]).byteValue();
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(b);
            ObjectInputStream oin = new ObjectInputStream(bin);
            this.javaRandom = (Random)oin.readObject();
        }
        catch (IOException e) {
            throw Py.SystemError("state vector invalid: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw Py.SystemError("state vector invalid: " + e.getMessage());
        }
    }

    final PyObject Random_getstate() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(this.javaRandom);
            byte[] b = bout.toByteArray();
            PyObject[] retarr = new PyInteger[b.length];
            for (int i = 0; i < b.length; ++i) {
                retarr[i] = new PyInteger(b[i]);
            }
            PyTuple ret = new PyTuple(retarr);
            return ret;
        }
        catch (IOException e) {
            throw Py.SystemError("creation of state vector failed: " + e.getMessage());
        }
    }

    final PyObject Random_random() {
        long a = this.javaRandom.nextInt() >>> 5;
        long b = this.javaRandom.nextInt() >>> 6;
        double ret = ((double)a * 6.7108864E7 + (double)b) * (double)1.110223E-16f;
        return new PyFloat(ret);
    }

    final PyLong Random_getrandbits(int k) {
        return new PyLong(new BigInteger(k, this.javaRandom));
    }

    static {
        PyType.addBuilder(PyRandom.class, new PyRandom$PyExposer());
        TYPE = PyType.fromClass(PyRandom.class);
    }

    public class PyRandom$Random_seed_exposer
    extends PyBuiltinMethodNarrow {
        public PyRandom$Random_seed_exposer(String string2) {
            super(string2, 1, 2);
            this.doc = "";
        }

        public PyRandom$Random_seed_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyRandom$Random_seed_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyRandom)this.self).Random_seed(pyObject);
            return Py.None;
        }

        public PyObject __call__() {
            ((PyRandom)this.self).Random_seed(null);
            return Py.None;
        }
    }

    public class PyRandom$Random___init___exposer
    extends PyBuiltinMethod {
        public PyRandom$Random___init___exposer(String string2) {
            super(string2);
            this.doc = "";
        }

        public PyRandom$Random___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyRandom$Random___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyRandom)this.self).Random___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyRandom$Random_jumpahead_exposer
    extends PyBuiltinMethodNarrow {
        public PyRandom$Random_jumpahead_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyRandom$Random_jumpahead_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyRandom$Random_jumpahead_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyRandom)this.self).Random_jumpahead(pyObject);
            return Py.None;
        }
    }

    public class PyRandom$Random_setstate_exposer
    extends PyBuiltinMethodNarrow {
        public PyRandom$Random_setstate_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyRandom$Random_setstate_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyRandom$Random_setstate_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyRandom)this.self).Random_setstate(pyObject);
            return Py.None;
        }
    }

    public class PyRandom$Random_getstate_exposer
    extends PyBuiltinMethodNarrow {
        public PyRandom$Random_getstate_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyRandom$Random_getstate_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyRandom$Random_getstate_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyRandom)this.self).Random_getstate();
        }
    }

    public class PyRandom$Random_random_exposer
    extends PyBuiltinMethodNarrow {
        public PyRandom$Random_random_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyRandom$Random_random_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyRandom$Random_random_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyRandom)this.self).Random_random();
        }
    }

    public class PyRandom$Random_getrandbits_exposer
    extends PyBuiltinMethodNarrow {
        public PyRandom$Random_getrandbits_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "";
        }

        public PyRandom$Random_getrandbits_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyRandom$Random_getrandbits_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyRandom)this.self).Random_getrandbits(Py.py2int(pyObject));
        }
    }

    public class PyRandom$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            PyRandom pyRandom = new PyRandom(this.for_type);
            if (bl) {
                pyRandom.Random___init__(pyObjectArray, stringArray);
            }
            return pyRandom;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new PyRandomDerived(pyType);
        }
    }

    public class PyRandom$PyExposer
    extends BaseTypeBuilder {
        public PyRandom$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyRandom$Random_seed_exposer("seed"), new PyRandom$Random___init___exposer("__init__"), new PyRandom$Random_jumpahead_exposer("jumpahead"), new PyRandom$Random_setstate_exposer("setstate"), new PyRandom$Random_getstate_exposer("getstate"), new PyRandom$Random_random_exposer("random"), new PyRandom$Random_getrandbits_exposer("getrandbits")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("_random.Random", PyRandom.class, Object.class, true, null, pyBuiltinMethodArray, pyDataDescrArray, new PyRandom$exposed___new__());
        }
    }
}

