/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.transform;

import org.simpleframework.xml.transform.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassTransform
implements Transform<Class> {
    ClassTransform() {
    }

    @Override
    public Class read(String target) throws Exception {
        ClassLoader loader2 = ClassTransform.getClassLoader();
        if (loader2 == null) {
            loader2 = this.getCallerClassLoader();
        }
        return loader2.loadClass(target);
    }

    @Override
    public String write(Class target) throws Exception {
        return target.getName();
    }

    private ClassLoader getCallerClassLoader() {
        return this.getClass().getClassLoader();
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

