/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.RackElement;
import org.netxms.client.objects.configs.PassiveRackElement;

public class Rack
extends GenericObject {
    private int height;
    private boolean topBottomNumbering;
    private List<PassiveRackElement> passiveElements;

    public Rack(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.height = msg.getFieldAsInt32(441L);
        this.topBottomNumbering = msg.getFieldAsBoolean(539L);
        this.passiveElements = new ArrayList<PassiveRackElement>();
        int count = msg.getFieldAsInt32(361L);
        long base = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            this.passiveElements.add(new PassiveRackElement(msg, base));
            base += 10L;
        }
    }

    @Override
    public String getObjectClassName() {
        return "Rack";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isTopBottomNumbering() {
        return this.topBottomNumbering;
    }

    public List<PassiveRackElement> getPassiveElements() {
        return this.passiveElements;
    }

    public List<RackElement> getUnits() {
        ArrayList<RackElement> units = new ArrayList<RackElement>();
        for (AbstractObject o : this.getChildrenAsArray()) {
            if (!(o instanceof RackElement)) continue;
            units.add((RackElement)((Object)o));
        }
        Collections.sort(units, new Comparator<RackElement>(){

            @Override
            public int compare(RackElement e1, RackElement e2) {
                return e1.getRackPosition() - e2.getRackPosition();
            }
        });
        return units;
    }

    public PassiveRackElement getPassiveElement(long id) {
        PassiveRackElement element = null;
        for (PassiveRackElement el : this.passiveElements) {
            if (el.getId() != id) continue;
            element = el;
        }
        return element;
    }
}

