/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.net.InetAddress;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;

public class AgentTunnel {
    private int id;
    private UUID guid;
    private InetAddress address;
    private long nodeId;
    private UUID agentId;
    private String systemName;
    private String systemInformation;
    private String platformName;
    private String agentVersion;
    private long zoneUIN;
    private int activeChannelCount;
    private String hostname;
    private boolean agentProxy;
    private boolean snmpProxy;
    private boolean snmpTrapProxy;
    private boolean userAgentInstalled;

    protected AgentTunnel(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt32(baseId);
        this.guid = msg.getFieldAsUUID(baseId + 1L);
        this.nodeId = msg.getFieldAsInt64(baseId + 2L);
        this.address = msg.getFieldAsInetAddress(baseId + 3L);
        this.systemName = msg.getFieldAsString(baseId + 4L);
        this.systemInformation = msg.getFieldAsString(baseId + 5L);
        this.platformName = msg.getFieldAsString(baseId + 6L);
        this.agentVersion = msg.getFieldAsString(baseId + 7L);
        this.activeChannelCount = msg.getFieldAsInt32(baseId + 8L);
        this.zoneUIN = msg.getFieldAsInt64(baseId + 9L);
        this.hostname = msg.getFieldAsString(baseId + 10L);
        this.agentId = msg.getFieldAsUUID(baseId + 11L);
        this.userAgentInstalled = msg.getFieldAsBoolean(baseId + 12L);
        this.agentProxy = msg.getFieldAsBoolean(baseId + 13L);
        this.snmpProxy = msg.getFieldAsBoolean(baseId + 14L);
        this.snmpTrapProxy = msg.getFieldAsBoolean(baseId + 15L);
    }

    public boolean isBound() {
        return this.nodeId != 0L;
    }

    public int getId() {
        return this.id;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public UUID getAgentId() {
        return this.agentId != null ? this.agentId : NXCommon.EMPTY_GUID;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getSystemInformation() {
        return this.systemInformation;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public long getZoneUIN() {
        return this.zoneUIN;
    }

    public int getActiveChannelCount() {
        return this.activeChannelCount;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isAgentProxy() {
        return this.agentProxy;
    }

    public boolean isSnmpProxy() {
        return this.snmpProxy;
    }

    public boolean isSnmpTrapProxy() {
        return this.snmpTrapProxy;
    }

    public boolean isUserAgentInstalled() {
        return this.userAgentInstalled;
    }

    public String toString() {
        return "AgentTunnel [id=" + this.id + ", guid=" + this.guid + ", address=" + this.address + ", nodeId=" + this.nodeId + ", systemName=" + this.systemName + ", hostname=" + this.hostname + ", systemInformation=" + this.systemInformation + ", platformName=" + this.platformName + ", agentVersion=" + this.agentVersion + ", zoneUIN=" + this.zoneUIN + ", activeChannelCount=" + this.activeChannelCount + ", userAgentInstalled=" + this.userAgentInstalled + "]";
    }
}

