/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import name.pachler.nio.file.impl.NativeLibLoader;
import name.pachler.nio.file.impl.Unix;

public abstract class BSD
extends Unix {
    public static final short EV_ADD;
    public static final short EV_ENABLE;
    public static final short EV_DISABLE;
    public static final short EV_DELETE;
    public static final short EV_ONESHOT;
    public static final short EV_CLEAR;
    public static final short EV_EOF;
    public static final short EV_ERROR;
    public static final short EVFILT_VNODE;
    public static final short EVFILT_PROC;
    public static final int NOTE_DELETE;
    public static final int NOTE_WRITE;
    public static final int NOTE_EXTEND;
    public static final int NOTE_ATTRIB;
    public static final int NOTE_LINK;
    public static final int NOTE_RENAME;
    public static final int NOTE_REVOKE;
    public static final int NOTE_EXIT;
    public static final int NOTE_FORK;
    public static final int NOTE_EXEC;
    public static final int NOTE_TRACK;
    public static final int NOTE_TRACKERR;

    public static native int kqueue();

    public static native int kevent(int var0, kevent[] var1, kevent[] var2, Unix.timespec var3);

    static {
        NativeLibLoader.loadLibrary("jpathwatch-native");
        EV_ADD = (short)BSD.getIntDefine("EV_ADD");
        EV_ENABLE = (short)BSD.getIntDefine("EV_ENABLE");
        EV_DISABLE = (short)BSD.getIntDefine("EV_DISABLE");
        EV_DELETE = (short)BSD.getIntDefine("EV_DELETE");
        EV_ONESHOT = (short)BSD.getIntDefine("EV_ONESHOT");
        EV_CLEAR = (short)BSD.getIntDefine("EV_CLEAR");
        EV_EOF = (short)BSD.getIntDefine("EV_EOF");
        EV_ERROR = (short)BSD.getIntDefine("EV_ERROR");
        EVFILT_VNODE = (short)BSD.getIntDefine("EVFILT_VNODE");
        EVFILT_PROC = (short)BSD.getIntDefine("EVFILT_PROC");
        NOTE_DELETE = BSD.getIntDefine("NOTE_DELETE");
        NOTE_WRITE = BSD.getIntDefine("NOTE_WRITE");
        NOTE_EXTEND = BSD.getIntDefine("NOTE_EXTEND");
        NOTE_ATTRIB = BSD.getIntDefine("NOTE_ATTRIB");
        NOTE_LINK = BSD.getIntDefine("NOTE_LINK");
        NOTE_RENAME = BSD.getIntDefine("NOTE_RENAME");
        NOTE_REVOKE = BSD.getIntDefine("NOTE_REVOKE");
        NOTE_EXIT = BSD.getIntDefine("NOTE_EXIT");
        NOTE_FORK = BSD.getIntDefine("NOTE_FORK");
        NOTE_EXEC = BSD.getIntDefine("NOTE_EXEC");
        NOTE_TRACK = BSD.getIntDefine("NOTE_TRACK");
        NOTE_TRACKERR = BSD.getIntDefine("NOTE_TRACKERR");
    }

    public static class kevent {
        IntStringMapping[] flagsMapping = new IntStringMapping[]{new IntStringMapping(EV_ADD, "EV_ADD"), new IntStringMapping(EV_ENABLE, "EV_ENABLE"), new IntStringMapping(EV_DISABLE, "EV_DISABLE"), new IntStringMapping(EV_DELETE, "EV_DELETE"), new IntStringMapping(EV_CLEAR, "EV_CLEAR"), new IntStringMapping(EV_ONESHOT, "EV_ONESHOT"), new IntStringMapping(EV_EOF, "EV_EOF"), new IntStringMapping(EV_ERROR, "EV_ERROR")};
        IntStringMapping[] vnodeNoteMapping = new IntStringMapping[]{new IntStringMapping(NOTE_DELETE, "NOTE_DELETE"), new IntStringMapping(NOTE_WRITE, "NOTE_WRITE"), new IntStringMapping(NOTE_EXTEND, "NOTE_EXTEND"), new IntStringMapping(NOTE_ATTRIB, "NOTE_ATTRIB"), new IntStringMapping(NOTE_LINK, "NOTE_LINK"), new IntStringMapping(NOTE_RENAME, "NOTE_RENAME"), new IntStringMapping(NOTE_REVOKE, "NOTE_REVOKE")};
        IntStringMapping[] procNoteMapping = new IntStringMapping[]{new IntStringMapping(NOTE_EXIT, "NOTE_EXIT"), new IntStringMapping(NOTE_FORK, "NOTE_FORK"), new IntStringMapping(NOTE_EXEC, "NOTE_EXEC"), new IntStringMapping(NOTE_TRACK, "NOTE_TRACK"), new IntStringMapping(NOTE_TRACKERR, "NOTE_TRACKERR")};
        private long peer = kevent.createPeer();

        private static native void initNative();

        private static native long createPeer();

        private static native void destroyPeer(long var0);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                kevent.destroyPeer(this.peer);
                this.peer = 0L;
            }
            finally {
                super.finalize();
            }
        }

        public native long get_ident();

        public native void set_ident(long var1);

        public native short get_filter();

        public native void set_filter(short var1);

        public native short get_flags();

        public native void set_flags(short var1);

        public native int get_fflags();

        public native void set_fflags(int var1);

        public native long get_data();

        public native void set_data(long var1);

        public native Object get_udata();

        public native void set_udata(Object var1);

        private String bitmaskToString(int value, IntStringMapping[] mapping) {
            String bitmaskString = "";
            for (int i = 0; i < mapping.length; ++i) {
                if ((value & mapping[i].i) == 0) continue;
                if (bitmaskString.length() != 0) {
                    bitmaskString = bitmaskString + '|';
                }
                bitmaskString = bitmaskString + mapping[i].s;
            }
            return bitmaskString;
        }

        public String toString() {
            String flags = this.bitmaskToString(this.get_flags(), this.flagsMapping);
            String filter = "?";
            String fflags = "?";
            if (this.get_filter() == EVFILT_VNODE) {
                fflags = this.bitmaskToString(this.get_fflags(), this.vnodeNoteMapping);
                filter = "EVFILT_VNODE";
            } else if (this.get_filter() == EVFILT_PROC) {
                fflags = this.bitmaskToString(this.get_fflags(), this.procNoteMapping);
                filter = "EVFILT_PROC";
            }
            return "{ident=" + this.get_ident() + ";filter=" + filter + ";flags=" + flags + ";fflags=" + fflags + ";data=" + this.get_data() + ";udata=" + this.get_udata() + "}";
        }

        static {
            kevent.initNative();
        }

        static class IntStringMapping {
            int i;
            String s;

            IntStringMapping(int i, String s) {
                this.i = i;
                this.s = s;
            }
        }
    }
}

