/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NativeLibLoader {
    private static PlatformArchLibSet[] libSets = new PlatformArchLibSet[]{new PlatformArchLibSet("Windows", "x86", new LibraryImplementation[]{new LibraryImplementation("jpathwatch-native", "Windows-x86/jpathwatch-native.dll")}, null), new PlatformArchLibSet("Windows", "amd64", new LibraryImplementation[]{new LibraryImplementation("jpathwatch-native", "Windows-amd64/jpathwatch-native.dll")}, null), new PlatformArchLibSet("FreeBSD", "i386", new LibraryImplementation[]{new LibraryImplementation("jpathwatch-native", "FreeBSD-i386/libjpathwatch-native.so")}, null), new PlatformArchLibSet("Mac OS X", "x86_64", new LibraryImplementation[]{new LibraryImplementation("jpathwatch-native", "GNU-MacOSX/libjpathwatch-native-64.dylib")}, null), new PlatformArchLibSet("Mac OS X", "ppc", new LibraryImplementation[]{new LibraryImplementation("jpathwatch-native", "GNU-MacOSX/libjpathwatch-native-ppc-32.dylib")}, null), new PlatformArchLibSet("Mac OS X", null, new LibraryImplementation[]{new LibraryImplementation("jpathwatch-native", "GNU-MacOSX/libjpathwatch-native-32.dylib")}, null), new PlatformArchLibSet("Linux", "i386", new LibraryImplementation[]{new LibraryImplementation("jpathwatch-native", "GNU-Linux-x86/libjpathwatch-native.so")}, null), new PlatformArchLibSet("Linux", "amd64", new LibraryImplementation[]{new LibraryImplementation("jpathwatch-native", "GNU-Linux-x86_64/libjpathwatch-native.so")}, null), new PlatformArchLibSet("Linux", "x86_64", new LibraryImplementation[]{new LibraryImplementation("jpathwatch-native", "GNU-Linux-x86_64/libjpathwatch-native.so")}, null), new PlatformArchLibSet("Linux", "s390", new LibraryImplementation[]{new LibraryImplementation("jpathwatch-native", "GNU-Linux-s390/libjpathwatch-native.so")}, null), new PlatformArchLibSet("Linux", "s390x", new LibraryImplementation[]{new LibraryImplementation("jpathwatch-native", "GNU-Linux-s390x/libjpathwatch-native.so")}, null)};
    private static Set<String> loadedLibraries = new HashSet<String>();
    private static PlatformArchLibSet libSet = NativeLibLoader.findPlatformArchLibSet();
    private static String PRODUCTNAME = "jpathwatch";
    private static int VERSION_MAJOR = 0;
    private static int VERSION_MINOR = 95;

    private static void loadDefaultLibrary(String name) {
        System.loadLibrary(name);
    }

    private static String stripPathFromResourceName(String s) {
        int slashPos = s.lastIndexOf(47);
        if (slashPos == -1) {
            return s;
        }
        return s.substring(slashPos + 1);
    }

    private static PlatformArchLibSet findPlatformArchLibSet() {
        String osName = System.getProperty("os.name");
        String archName = System.getProperty("os.arch");
        for (int i = 0; i < libSets.length; ++i) {
            PlatformArchLibSet libSet = libSets[i];
            int osNameTruncatedSize = Math.min(osName.length(), libSet.osName.length());
            String osNameTruncated = osName.substring(0, osNameTruncatedSize);
            if (!osNameTruncated.equals(libSet.osName) || libSet.archName != null && !libSet.archName.equals(archName)) continue;
            return libSet;
        }
        return null;
    }

    public static synchronized void loadLibrary(String name) {
        if (loadedLibraries.contains(name)) {
            return;
        }
        LibraryImplementation libImpl = null;
        if (libSet != null) {
            libImpl = libSet.findImplementation(name);
        }
        if (libImpl == null) {
            NativeLibLoader.loadDefaultLibrary(name);
            return;
        }
        String prefix = PRODUCTNAME + "-nativelib-v-" + VERSION_MAJOR + '-' + VERSION_MINOR + '-';
        String suffix = NativeLibLoader.stripPathFromResourceName(libImpl.libraryResource);
        boolean loaded = false;
        try {
            File parentDir = new File(System.getProperty("java.io.tmpdir"));
            NativeLibLoader.extractAndLoadLibrary(libImpl, new File(parentDir, prefix + suffix));
            loaded = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!loaded) {
            try {
                File tmpLibFile = File.createTempFile(prefix, suffix);
                NativeLibLoader.extractAndLoadLibrary(libImpl, tmpLibFile);
                loaded = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!loaded) {
            try {
                NativeLibLoader.loadDefaultLibrary(name);
                loaded = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (loaded) {
            loadedLibraries.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static void extractAndLoadLibrary(LibraryImplementation libImpl, File libraryFile) {
        block47: {
            is = null;
            readRaf = null;
            writeRaf = null;
            writeLock = null;
            readLock = null;
            nativeLibraryBuffer = null;
            resourceName = libImpl.libraryResource;
            classLoader = NativeLibLoader.class.getClassLoader();
            bos = new ByteArrayOutputStream();
            try {
                is = classLoader.getResourceAsStream(resourceName);
                buffer = new byte[8192];
                nread = 0;
                while (nread != -1) {
                    bos.write(buffer, 0, nread);
                    nread = is.read(buffer);
                }
                var14_23 = null;
                ** if (is == null) goto lbl-1000
            }
            catch (Throwable var13_25) {
                var14_24 = null;
                if (is != null) {
                    is.close();
                }
                throw var13_25;
            }
lbl-1000:
            // 1 sources

            {
                is.close();
            }
lbl-1000:
            // 2 sources

            {
            }
            nativeLibraryBuffer = bos.toByteArray();
            try {
                readRaf = new RandomAccessFile(libraryFile, "r");
                readLock = readRaf.getChannel().lock(0L, 0x7FFFFFFFFFFFFFFFL, true);
            }
            catch (FileNotFoundException fnfx) {
                // empty catch block
            }
            if (readLock != null) {
                hasIntegrity = true;
                libraryOnDiskBuffer = new byte[(int)readRaf.length()];
                for (libraryOnDiskSize = 0; libraryOnDiskSize < libraryOnDiskBuffer.length; libraryOnDiskSize += n) {
                    n = readRaf.read(libraryOnDiskBuffer, libraryOnDiskSize, libraryOnDiskBuffer.length - libraryOnDiskSize);
                    if (n != -1) continue;
                    hasIntegrity = false;
                    break;
                }
                if (hasIntegrity && libraryOnDiskSize != nativeLibraryBuffer.length) {
                    hasIntegrity = false;
                }
                if (hasIntegrity && !Arrays.equals(nativeLibraryBuffer, libraryOnDiskBuffer)) {
                    hasIntegrity = false;
                }
                if (!hasIntegrity) {
                    readLock.release();
                    readLock = null;
                    readRaf.close();
                    readRaf = null;
                }
            }
            if (readLock == null) {
                writeRaf = new RandomAccessFile(libraryFile, "rw");
                writeLock = writeRaf.getChannel().lock(0L, 0x7FFFFFFFFFFFFFFFL, false);
                writeRaf.write(nativeLibraryBuffer);
                writeRaf.setLength(nativeLibraryBuffer.length);
                if (PlatformArchLibSet.access$000(NativeLibLoader.libSet) != null) {
                    commandArray = new String[PlatformArchLibSet.access$000(NativeLibLoader.libSet).length];
                    for (n = 0; n < PlatformArchLibSet.access$000(NativeLibLoader.libSet).length; ++n) {
                        commandArray[n] = actualCommand = PlatformArchLibSet.access$000(NativeLibLoader.libSet)[n].replaceAll("\\{library-file\\}", libraryFile.getAbsolutePath());
                    }
                    p = Runtime.getRuntime().exec(commandArray, null, libraryFile.getAbsoluteFile().getParentFile());
                    while (true) {
                        try {
                            p.waitFor();
                        }
                        catch (InterruptedException ex) {
                            continue;
                        }
                        break;
                    }
                }
                writeLock.release();
                writeLock = null;
                writeRaf.close();
                writeRaf = null;
                libraryFile.deleteOnExit();
            }
            if (readLock == null) {
                readRaf = new RandomAccessFile(libraryFile, "r");
                readLock = readRaf.getChannel().lock(0L, 0x7FFFFFFFFFFFFFFFL, true);
            }
            libpath = libraryFile.getAbsolutePath();
            Logger.getLogger(NativeLibLoader.class.getName()).log(Level.FINE, "loading library from: " + libpath);
            System.load(libpath);
            readLock.release();
            readLock = null;
            readRaf.close();
            readRaf = null;
            var16_26 = null;
            try {
                if (writeLock != null) {
                    writeLock.release();
                }
                if (writeRaf != null) {
                    writeRaf.close();
                }
                if (readRaf != null) {
                    readRaf.close();
                }
                if (readLock != null) {
                    readLock.release();
                }
            }
            catch (IOException iox) {
                // empty catch block
            }
            try {
                if (is != null) {
                    is.close();
                }
                break block47;
            }
            catch (IOException iox) {}
            break block47;
            {
                catch (IOException iox) {
                    iox.printStackTrace();
                    var16_27 = null;
                    try {
                        if (writeLock != null) {
                            writeLock.release();
                        }
                        if (writeRaf != null) {
                            writeRaf.close();
                        }
                        if (readRaf != null) {
                            readRaf.close();
                        }
                        if (readLock != null) {
                            readLock.release();
                        }
                    }
                    catch (IOException iox) {
                        // empty catch block
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block47;
                    }
                    catch (IOException iox) {}
                }
            }
            catch (Throwable var15_32) {
                var16_28 = null;
                try {
                    if (writeLock != null) {
                        writeLock.release();
                    }
                    if (writeRaf != null) {
                        writeRaf.close();
                    }
                    if (readRaf != null) {
                        readRaf.close();
                    }
                    if (readLock != null) {
                        readLock.release();
                    }
                }
                catch (IOException iox) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iox) {
                    // empty catch block
                }
                throw var15_32;
            }
        }
    }

    private static class PlatformArchLibSet {
        public String osName;
        public String archName;
        public LibraryImplementation[] implementations;
        private String[] command;

        PlatformArchLibSet(String osName, String archName, LibraryImplementation[] implementations, String[] command) {
            this.osName = osName;
            this.archName = archName;
            this.implementations = implementations;
            this.command = command;
        }

        LibraryImplementation findImplementation(String name) {
            for (int i = 0; i < this.implementations.length; ++i) {
                if (!name.equals(this.implementations[i].libraryName)) continue;
                return this.implementations[i];
            }
            return null;
        }

        static /* synthetic */ String[] access$000(PlatformArchLibSet x0) {
            return x0.command;
        }
    }

    private static class LibraryImplementation {
        public String libraryName;
        public String libraryResource;

        LibraryImplementation(String libraryName, String libraryResource) {
            this.libraryName = libraryName;
            this.libraryResource = libraryResource;
        }
    }
}

