/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.Arrays;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.api.DataCollectionObjectEditor;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.DCIPropertyPageDialog;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class InstanceDiscovery
extends DCIPropertyPageDialog {
    private static final String[] DCI_FUNCTIONS = new String[]{"FindDCIByName", "FindDCIByDescription", "GetDCIObject", "GetDCIValue", "GetDCIValueByDescription", "GetDCIValueByName"};
    private static final String[] DCI_VARIABLES = new String[]{"$dci", "$node"};
    private DataCollectionObjectEditor editor;
    private DataCollectionObject dco;
    private Combo discoveryMethod;
    private LabeledText discoveryData;
    private ScriptEditor filterScript;
    private Group groupRetention;
    private Combo instanceRetentionMode;
    private Spinner instanceRetentionTime;

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.editor = (DataCollectionObjectEditor)this.getElement().getAdapter(DataCollectionObjectEditor.class);
        this.dco = this.editor.getObject();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Messages.get();
        this.discoveryMethod = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)Messages.InstanceDiscovery_Method, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_None);
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_AgentList);
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_AgentTable);
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_SnmpWalkValues);
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_SnmpWalkOids);
        Messages.get();
        this.discoveryMethod.add(Messages.InstanceDiscovery_Script);
        this.discoveryMethod.select(this.dco.getInstanceDiscoveryMethod());
        this.discoveryMethod.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int method = InstanceDiscovery.this.discoveryMethod.getSelectionIndex();
                InstanceDiscovery.this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(method));
                InstanceDiscovery.this.discoveryData.setEnabled(method != 0);
                InstanceDiscovery.this.filterScript.setEnabled(method != 0);
                InstanceDiscovery.this.instanceRetentionMode.setEnabled(method != 0);
                InstanceDiscovery.this.instanceRetentionTime.setEnabled(method != 0 && InstanceDiscovery.this.instanceRetentionMode.getSelectionIndex() > 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.discoveryData = new LabeledText(dialogArea, 0);
        this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(this.dco.getInstanceDiscoveryMethod()));
        this.discoveryData.setText(this.dco.getInstanceDiscoveryData());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.discoveryData.setLayoutData((Object)gd);
        this.discoveryData.setEnabled(this.dco.getInstanceDiscoveryMethod() != 0);
        this.groupRetention = new Group(dialogArea, 0);
        this.groupRetention.setText("Instance retention");
        gd = new GridData();
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        this.groupRetention.setLayoutData((Object)gd);
        GridLayout retentionLayout = new GridLayout();
        retentionLayout.numColumns = 2;
        retentionLayout.horizontalSpacing = 4;
        this.groupRetention.setLayout((Layout)retentionLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.instanceRetentionMode = WidgetHelper.createLabeledCombo((Composite)this.groupRetention, (int)8, (String)"Instance retention mode", (Object)gd);
        this.instanceRetentionMode.add("Server default");
        this.instanceRetentionMode.add("Custom");
        this.instanceRetentionMode.select(this.dco.getInstanceRetentionTime() == -1 ? 0 : 1);
        this.instanceRetentionMode.setEnabled(this.dco.getInstanceDiscoveryMethod() != 0);
        this.instanceRetentionMode.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InstanceDiscovery.this.instanceRetentionTime.setEnabled(InstanceDiscovery.this.instanceRetentionMode.getSelectionIndex() == 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.instanceRetentionTime = WidgetHelper.createLabeledSpinner((Composite)this.groupRetention, (int)2048, (String)"Instance retention time (days)", (int)0, (int)100, (Object)new GridData());
        this.instanceRetentionTime.setSelection(this.dco.getInstanceRetentionTime());
        this.instanceRetentionTime.setEnabled(this.instanceRetentionMode.getSelectionIndex() > 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 0;
        gd.heightHint = 0;
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new ScriptEditor(parent, style, 768, false, "Variables:\r\n\t$1\t\t\tInstance to test;\r\n\t$2\t\t\tInstance data (value for given OID for SNMP Walk - OIDs method, secondary value for Script method);\r\n\t$dci\t\tthis DCI object;\r\n\t$isCluster\ttrue if DCI is on cluster;\r\n\t$node\t\tcurrent node object (null if DCI is not on the node);\r\n\t$object\t\tcurrent object.\r\n\r\nReturn value:\r\n\ttrue/false to accept or reject instance without additional changes or\r\n\tarray of two or three elements to modify instance:\r\n\t\t1st element - true/false to indicate acceptance;\r\n\t\t2nd element - new instance name;\r\n\t\t3rd element - new instance display name.");
            }
        };
        Messages.get();
        this.filterScript = (ScriptEditor)WidgetHelper.createLabeledControl((Composite)dialogArea, (int)2048, (WidgetFactory)factory, (String)Messages.InstanceDiscovery_FilterScript, (Object)gd);
        this.filterScript.addFunctions(Arrays.asList(DCI_FUNCTIONS));
        this.filterScript.addVariables(Arrays.asList(DCI_VARIABLES));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.filterScript.setLayoutData((Object)gd);
        this.filterScript.setText(this.dco.getInstanceDiscoveryFilter());
        this.filterScript.setEnabled(this.dco.getInstanceDiscoveryMethod() != 0);
        return dialogArea;
    }

    private static String getDataLabel(int method) {
        switch (method) {
            case 0: {
                Messages.get();
                return Messages.InstanceDiscovery_DiscoveryData;
            }
            case 1: {
                Messages.get();
                return Messages.InstanceDiscovery_ListName;
            }
            case 2: {
                Messages.get();
                return Messages.InstanceDiscovery_TableName;
            }
            case 3: 
            case 4: {
                Messages.get();
                return Messages.InstanceDiscovery_BaseOid;
            }
            case 5: {
                return "Script name";
            }
        }
        return "";
    }

    protected void applyChanges(boolean isApply) {
        this.dco.setInstanceDiscoveryMethod(this.discoveryMethod.getSelectionIndex());
        this.dco.setInstanceDiscoveryData(this.discoveryData.getText());
        this.dco.setInstanceDiscoveryFilter(this.filterScript.getText());
        if (this.instanceRetentionMode.getSelectionIndex() == 0) {
            this.dco.setInstanceRetentionTime(-1);
        } else {
            this.dco.setInstanceRetentionTime(this.instanceRetentionTime.getSelection());
        }
        this.editor.modify();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.discoveryMethod.select(0);
        this.discoveryData.setLabel(InstanceDiscovery.getDataLabel(0));
        this.discoveryData.setText("");
        this.discoveryData.setEnabled(false);
        this.filterScript.setText("");
        this.filterScript.setEnabled(false);
        this.instanceRetentionMode.select(0);
        this.instanceRetentionTime.setSelection(0);
    }
}

