/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.AgentTunnel;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.agentmanager.Activator;
import org.netxms.ui.eclipse.agentmanager.views.helpers.TunnelListComparator;
import org.netxms.ui.eclipse.agentmanager.views.helpers.TunnelListLabelProvider;
import org.netxms.ui.eclipse.agentmanager.views.helpers.TunnelManagerFilter;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectmanager.dialogs.CreateNodeDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TunnelManager
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.TunnelManager";
    public static final int COL_ID = 0;
    public static final int COL_STATE = 1;
    public static final int COL_NODE = 2;
    public static final int COL_IP_ADDRESS = 3;
    public static final int COL_CHANNELS = 4;
    public static final int COL_SYSNAME = 5;
    public static final int COL_HOSTNAME = 6;
    public static final int COL_PLATFORM = 7;
    public static final int COL_SYSINFO = 8;
    public static final int COL_AGENT_VERSION = 9;
    public static final int COL_AGENT_ID = 10;
    public static final int COL_AGENT_PROXY = 11;
    public static final int COL_SNMP_PROXY = 12;
    public static final int COL_SNMP_TRAP_PROXY = 13;
    public static final int COL_USER_AGENT = 14;
    private SortableTableViewer viewer;
    private TunnelManagerFilter filter;
    private boolean initShowfilter = true;
    private FilterText filterText;
    private Action actionRefresh;
    private Action actionCreateNode;
    private Action actionBind;
    private Action actionUnbind;
    private Action actionShowFilter;
    private Action actionHideNonProxy;
    private Action actionHideNonUA;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(parent, 0, null, true);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TunnelManager.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                TunnelManager.this.enableFilter(false);
                TunnelManager.this.actionShowFilter.setChecked(false);
            }
        });
        String[] names = new String[]{"ID", "State", "Node", "IP address", "Channels", "System name", "Hostname", "Platform", "System information", "Agent version", "Agent ID", "Agent proxy", "SNMP proxy", "SNMP trap proxy", "User agent"};
        int[] widths = new int[]{80, 80, 140, 150, 80, 150, 150, 250, 300, 150, 150, 80, 80, 80, 80};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TunnelListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new TunnelListComparator());
        this.filter = new TunnelManagerFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initShowfilter = settings.getBoolean("org.netxms.ui.eclipse.agentmanager.views.TunnelManagerinitShowFilter");
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)"TunnelManager");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)TunnelManager.this.viewer, (IDialogSettings)settings, (String)"TunnelManager");
                settings.put("org.netxms.ui.eclipse.agentmanager.views.TunnelManagerinitShowFilter", TunnelManager.this.initShowfilter);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
        if (this.initShowfilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.refresh();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.agentmanager.context.TunnelManager");
        }
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                TunnelManager.this.refresh();
            }
        };
        this.actionCreateNode = new Action("&Create node and bind..."){

            public void run() {
                TunnelManager.this.createNode();
            }
        };
        this.actionBind = new Action("&Bind to..."){

            public void run() {
                TunnelManager.this.bindTunnel();
            }
        };
        this.actionUnbind = new Action("&Unbind"){

            public void run() {
                TunnelManager.this.unbindTunnel();
            }
        };
        this.actionShowFilter = new Action("&Show filter", 2){

            public void run() {
                TunnelManager.this.enableFilter(TunnelManager.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.initShowfilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.agentmanager.commands.show_filter");
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
        this.actionHideNonProxy = new Action("Hide tunnels without proxy function", 2){

            public void run() {
                TunnelManager.this.filter.setHideNonProxy(TunnelManager.this.actionHideNonProxy.isChecked());
            }
        };
        this.actionHideNonUA = new Action("Hide tunnels without user agent", 2){

            public void run() {
                TunnelManager.this.filter.setHideNonUA(TunnelManager.this.actionHideNonUA.isChecked());
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IAction)this.actionHideNonProxy);
        manager.add((IAction)this.actionHideNonUA);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TunnelManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && !((AgentTunnel)selection.getFirstElement()).isBound()) {
            manager.add((IAction)this.actionBind);
            manager.add((IAction)this.actionCreateNode);
        } else {
            for (Object o : selection.toList()) {
                if (!((AgentTunnel)o).isBound()) continue;
                manager.add((IAction)this.actionUnbind);
                break;
            }
        }
        manager.add((IAction)this.actionShowFilter);
    }

    private void refresh() {
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get list of active agent tunnels", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List tunnels = session.getAgentTunnels();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TunnelManager.this.viewer.setInput((Object)tunnels);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of active agent tunnels";
            }
        }.start();
    }

    private void createNode() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final AgentTunnel tunnel = (AgentTunnel)selection.getFirstElement();
        if (tunnel.isBound()) {
            return;
        }
        CreateNodeDialog dlg = new CreateNodeDialog(this.getSite().getShell(), null);
        dlg.setEnableShowAgainFlag(false);
        dlg.setObjectName(tunnel.getSystemName());
        dlg.setZoneUIN(tunnel.getZoneUIN());
        if (dlg.open() != 0) {
            return;
        }
        final NXCObjectCreationData cd = new NXCObjectCreationData(2, dlg.getObjectName(), 2L);
        cd.setCreationFlags(dlg.getCreationFlags());
        cd.setPrimaryName(dlg.getHostName());
        cd.setAgentPort(dlg.getAgentPort());
        cd.setSnmpPort(dlg.getSnmpPort());
        cd.setAgentProxyId(dlg.getAgentProxy());
        cd.setSnmpProxyId(dlg.getSnmpProxy());
        cd.setIcmpProxyId(dlg.getIcmpProxy());
        cd.setSshProxyId(dlg.getSshProxy());
        cd.setZoneUIN(dlg.getZoneUIN());
        cd.setSshLogin(dlg.getSshLogin());
        cd.setSshPassword(dlg.getSshPassword());
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Create new node and bind tunnel", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                long nodeId = session.createObject(cd);
                session.bindAgentTunnel(tunnel.getId(), nodeId);
                final List tunnels = session.getAgentTunnels();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TunnelManager.this.viewer.setInput((Object)tunnels);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot create node and bind tunnel";
            }
        }.start();
    }

    private void bindTunnel() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final AgentTunnel tunnel = (AgentTunnel)selection.getFirstElement();
        if (tunnel.isBound()) {
            return;
        }
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        if (dlg.open() != 0) {
            return;
        }
        final long nodeId = ((AbstractObject)dlg.getSelectedObjects().get(0)).getObjectId();
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Bind tunnels", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.bindAgentTunnel(tunnel.getId(), nodeId);
                final List tunnels = session.getAgentTunnels();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TunnelManager.this.viewer.setInput((Object)tunnels);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot bind tunnel";
            }
        }.start();
    }

    private void unbindTunnel() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Unbind Tunnel", (String)"Selected tunnels will be unbound. Are you sure?")) {
            return;
        }
        final Object[] tunnels = selection.toArray();
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Unbind tunnels", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Object[] objectArray = tunnels;
                int n = tunnels.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    AgentTunnel t = (AgentTunnel)o;
                    if (t.isBound()) {
                        session.unbindAgentTunnel(t.getNodeId());
                    }
                    ++n2;
                }
                final List tunnels2 = session.getAgentTunnels();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TunnelManager.this.viewer.setInput((Object)tunnels2);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot unbind tunnel";
            }
        }.start();
    }

    private void enableFilter(boolean enable) {
        this.initShowfilter = enable;
        this.filterText.setVisible(this.initShowfilter);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.viewer.getTable().getParent().layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    private void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }
}

