/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.reporting.ReportDefinition;
import org.netxms.client.reporting.ReportParameter;
import org.netxms.client.reporting.ReportRenderFormat;
import org.netxms.client.reporting.ReportResult;
import org.netxms.client.reporting.ReportingJob;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.reporter.Activator;
import org.netxms.ui.eclipse.reporter.api.CustomControlFactory;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;
import org.netxms.ui.eclipse.reporter.widgets.StringFieldEditor;
import org.netxms.ui.eclipse.reporter.widgets.helpers.ReportResultLabelProvider;
import org.netxms.ui.eclipse.reporter.widgets.helpers.ScheduleLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ImageCache;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ReportExecutionForm
extends Composite {
    public static final int SCHEDULE_TYPE = 0;
    public static final int SCHEDULE_START_TIME = 1;
    public static final int SCHEDULE_OWNER = 2;
    public static final int SCHEDULE_COMMENTS = 3;
    public static final int RESULT_EXEC_TIME = 0;
    public static final int RESULT_STARTED_BY = 1;
    public static final int RESULT_STATUS = 2;
    private NXCSession session = ConsoleSharedData.getSession();
    private IWorkbenchPart workbenchPart = null;
    private FormToolkit toolkit;
    private Form form;
    private ImageCache imageCache;
    private SortableTableViewer resultList;
    private SortableTableViewer scheduleList;
    private ReportDefinition report;
    private List<ReportParameter> parameters;
    private List<FieldEditor> fields = new ArrayList<FieldEditor>();
    private Action actionDeleteSchedule;
    private Action actionDeleteResult;
    private Action actionRenderXLS;
    private Action actionRenderPDF;

    public ReportExecutionForm(Composite parent, int style, ReportDefinition report, IWorkbenchPart workbenchPart) {
        super(parent, style);
        this.report = report;
        this.workbenchPart = workbenchPart;
        this.createActions();
        this.imageCache = new ImageCache((Control)this);
        this.setLayout((Layout)new FillLayout());
        this.toolkit = new FormToolkit(this.getDisplay());
        this.form = this.toolkit.createForm((Composite)this);
        this.form.setText(report.getName());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        this.form.getBody().setLayout((Layout)layout);
        Section section = this.toolkit.createSection(this.form.getBody(), 482);
        section.setText("Parameters");
        section.setDescription("Provide parameters necessary to run this report in fields below");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        section.setLayoutData((Object)gd);
        Composite paramArea = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)paramArea);
        this.createParamEntryFields(paramArea);
        section = this.toolkit.createSection(this.form.getBody(), 482);
        section.setText("Schedules");
        section.setDescription("Scheduling of report generation");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        section.setLayoutData((Object)gd);
        Composite scheduleArea = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)scheduleArea);
        this.createSchedulesSection(scheduleArea);
        section = this.toolkit.createSection(this.form.getBody(), 482);
        section.setText("Results");
        section.setDescription("The following execution results are available for rendering");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gd);
        Composite resultArea = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)resultArea);
        this.createResultsSection(resultArea);
        this.session.addListener(new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 3000) {
                    ReportExecutionForm.this.refreshScheduleList();
                } else if (n.getCode() == 3001) {
                    ReportExecutionForm.this.refreshResultList();
                }
            }
        });
        this.refreshScheduleList();
        this.refreshResultList();
    }

    private void createActions() {
        this.actionDeleteSchedule = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                ReportExecutionForm.this.deleteSchedules();
            }
        };
        this.actionDeleteSchedule.setEnabled(false);
        this.actionDeleteResult = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                ReportExecutionForm.this.deleteResults();
            }
        };
        this.actionDeleteResult.setEnabled(false);
        this.actionRenderPDF = new Action("Render to &PDF", Activator.getImageDescriptor("icons/pdf.png")){

            public void run() {
                ReportExecutionForm.this.renderSelectedResult(ReportRenderFormat.PDF);
            }
        };
        this.actionRenderPDF.setEnabled(false);
        this.actionRenderXLS = new Action("Render to &XLS", Activator.getImageDescriptor("icons/xls.png")){

            public void run() {
                ReportExecutionForm.this.renderSelectedResult(ReportRenderFormat.XLS);
            }
        };
        this.actionRenderXLS.setEnabled(false);
    }

    private void createSchedulesSection(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        String[] names = new String[]{"Type", "Schedule", "Owner", "Comments"};
        int[] widths = new int[]{100, 140, 100, 300};
        this.scheduleList = new SortableTableViewer(parent, names, widths, 0, 1024, 67586);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.scheduleList.getControl().setLayoutData((Object)gd);
        this.scheduleList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.scheduleList.setLabelProvider((IBaseLabelProvider)new ScheduleLabelProvider());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.scheduleList, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ReportExecutionForm.ScheduleList");
        this.scheduleList.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ReportExecutionForm.this.scheduleList, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ReportExecutionForm.ScheduleList");
            }
        });
        ImageHyperlink link = this.toolkit.createImageHyperlink(parent, 64);
        link.setImage(this.imageCache.add(Activator.getImageDescriptor("icons/schedule.png")));
        link.setText("Add Schedule");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ReportExecutionForm.this.addSchedule();
            }
        });
        this.createSchedulesContextMenu();
        this.scheduleList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ReportExecutionForm.this.scheduleList.getSelection();
                ReportExecutionForm.this.actionDeleteSchedule.setEnabled(selection.size() > 0);
            }
        });
    }

    private void createSchedulesContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ReportExecutionForm.this.fillSchedulesContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.scheduleList.getControl());
        this.scheduleList.getControl().setMenu(menu);
    }

    private void fillSchedulesContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionDeleteSchedule);
    }

    private void createResultsSection(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        String[] names = new String[]{"Execution Time", "Started by", "Status"};
        int[] widths = new int[]{180, 140, 100};
        this.resultList = new SortableTableViewer(parent, names, widths, 0, 1024, 67586);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.resultList.getControl().setLayoutData((Object)gd);
        this.resultList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resultList.setLabelProvider((IBaseLabelProvider)new ReportResultLabelProvider());
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.resultList, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ReportExecutionForm.ResultList");
        this.resultList.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ReportExecutionForm.this.resultList, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ReportExecutionForm.ResultList");
            }
        });
        ImageHyperlink link = this.toolkit.createImageHyperlink(parent, 64);
        link.setImage(SharedIcons.IMG_EXECUTE);
        link.setText("Execute Report");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ReportExecutionForm.this.executeReport();
            }
        });
        this.createResultsContextMenu();
        this.resultList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ReportExecutionForm.this.resultList.getSelection();
                ReportExecutionForm.this.actionDeleteResult.setEnabled(selection.size() > 0);
                ReportExecutionForm.this.actionRenderPDF.setEnabled(selection.size() == 1);
                ReportExecutionForm.this.actionRenderXLS.setEnabled(selection.size() == 1);
            }
        });
    }

    private void createResultsContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ReportExecutionForm.this.fillResultsContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.resultList.getControl());
        this.resultList.getControl().setMenu(menu);
    }

    private void fillResultsContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRenderPDF);
        manager.add((IAction)this.actionRenderXLS);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDeleteResult);
    }

    private void createParamEntryFields(Composite parent) {
        FieldEditor editor;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        parent.setLayout((Layout)layout);
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.reporter.customfields");
        this.sortFieldProviders(elements);
        this.parameters = this.report.getParameters();
        HashMap<String, FieldEditor> editors = new HashMap<String, FieldEditor>();
        for (ReportParameter parameter : this.parameters) {
            editor = null;
            int i = 0;
            while (i < elements.length) {
                try {
                    CustomControlFactory provider = (CustomControlFactory)elements[i].createExecutableExtension("class");
                    editor = provider.editorForType(parent, parameter, this.toolkit);
                    if (editor != null) {
                        break;
                    }
                }
                catch (CoreException e) {
                    Activator.logError("Cannot create CustomControlFactory instance", (Exception)((Object)e));
                }
                ++i;
            }
            if (editor == null) {
                editor = new StringFieldEditor(parameter, this.toolkit, parent);
            }
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 128;
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = false;
            gd.horizontalSpan = parameter.getSpan();
            editor.setLayoutData(gd);
            if (layout.numColumns < parameter.getSpan()) {
                layout.numColumns = parameter.getSpan();
            }
            editors.put(parameter.getName(), editor);
            this.fields.add(editor);
        }
        for (ReportParameter parameter : this.parameters) {
            editor = (FieldEditor)((Object)editors.get(parameter.getName()));
            FieldEditor parentEditor = (FieldEditor)((Object)editors.get(parameter.getDependsOn()));
            if (editor == null || parentEditor == null) continue;
            parentEditor.setDependantEditor(editor);
        }
    }

    private void sortFieldProviders(IConfigurationElement[] elements) {
        Arrays.sort(elements, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                String attribute1 = o1.getAttribute("priority");
                String attribute2 = o2.getAttribute("priority");
                int priority1 = 0;
                int priority2 = 0;
                if (attribute1 != null) {
                    try {
                        priority1 = Integer.parseInt(attribute1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (attribute2 != null) {
                    try {
                        priority2 = Integer.parseInt(attribute2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return priority2 - priority1;
            }
        });
    }

    private void renderSelectedResult(ReportRenderFormat format) {
        IStructuredSelection selection = (IStructuredSelection)this.resultList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        ReportResult r = (ReportResult)selection.getFirstElement();
        this.renderReport(r.getJobId(), r.getExecutionTime(), format);
    }

    private void renderReport(final UUID jobId, Date executionTime, final ReportRenderFormat format) {
        StringBuilder nameTemplate = new StringBuilder();
        nameTemplate.append(this.report.getName());
        nameTemplate.append(" ");
        nameTemplate.append(new SimpleDateFormat("ddMMyyyy HHmm").format(executionTime));
        nameTemplate.append(".");
        nameTemplate.append(format.getExtension());
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        switch (format) {
            case PDF: {
                fileDialog.setFilterNames(new String[]{"PDF Files", "All Files"});
                fileDialog.setFilterExtensions(new String[]{"*.pdf", "*.*"});
                break;
            }
            case XLS: {
                fileDialog.setFilterNames(new String[]{"Excel Files", "All Files"});
                fileDialog.setFilterExtensions(new String[]{"*.xls", "*.*"});
                break;
            }
            default: {
                fileDialog.setFilterNames(new String[]{"All Files"});
                fileDialog.setFilterExtensions(new String[]{"*.*"});
            }
        }
        fileDialog.setFileName(nameTemplate.toString());
        final String fileName = fileDialog.open();
        if (fileName == null) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Rendering report", this.workbenchPart, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                File reportFile = session.renderReport(ReportExecutionForm.this.report.getId(), jobId, format);
                FileInputStream inputStream = null;
                FileOutputStream outputStream = null;
                try {
                    inputStream = new FileInputStream(reportFile);
                    outputStream = new FileOutputStream(fileName);
                    byte[] buffer = new byte[1024];
                    int size = 0;
                    do {
                        if ((size = inputStream.read(buffer)) <= 0) continue;
                        outputStream.write(buffer, 0, size);
                    } while (size == buffer.length);
                    outputStream.close();
                    outputStream = null;
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ReportExecutionForm.this.openReport(fileName, format);
                        }
                    });
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }

            protected String getErrorMessage() {
                return String.format("Cannot render report %1$s (job ID %2$s)", ReportExecutionForm.this.report.getName(), jobId);
            }
        }.start();
    }

    private void executeReport() {
        final HashMap<String, String> execParameters = new HashMap<String, String>();
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.size()) {
                execParameters.put(this.parameters.get(i).getName(), this.fields.get(i).getValue());
                ++i;
            }
        }
        new ConsoleJob("Execute report", this.workbenchPart, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ReportExecutionForm.this.session.executeReport(ReportExecutionForm.this.report.getId(), execParameters);
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialogHelper.openInformation((Shell)ReportExecutionForm.this.getShell(), (String)"Report Execution", (String)(String.valueOf(ReportExecutionForm.this.report.getName()) + " execution started successfully."));
                        ReportExecutionForm.this.refreshResultList();
                    }
                });
            }

            protected String getErrorMessage() {
                return String.format("Cannot execute report %s", ReportExecutionForm.this.report.getName());
            }
        }.start();
    }

    private void refreshResultList() {
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Refresh result list for report " + this.report.getName(), this.workbenchPart, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List results = session.listReportResults(ReportExecutionForm.this.report.getId());
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ReportExecutionForm.this.isDisposed()) {
                            return;
                        }
                        ReportExecutionForm.this.resultList.setInput((Object)results.toArray());
                        ReportExecutionForm.this.getParent().layout(true, true);
                    }
                });
            }

            protected String getErrorMessage() {
                return String.format("Cannot get result list for report %s", ReportExecutionForm.this.report.getName());
            }
        }.start();
    }

    private void refreshScheduleList() {
        new ConsoleJob(String.format("Refresh schedule list for report %s", this.report.getName()), this.workbenchPart, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List results = ReportExecutionForm.this.session.listScheduledJobs(ReportExecutionForm.this.report.getId());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!ReportExecutionForm.this.scheduleList.getControl().isDisposed()) {
                            ReportExecutionForm.this.scheduleList.setInput((Object)results.toArray());
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return String.format("Cannot get schedule list for report %s", ReportExecutionForm.this.report.getName());
            }
        }.start();
    }

    private void deleteResults() {
        IStructuredSelection selection = (IStructuredSelection)this.resultList.getSelection();
        if (selection.size() == 0) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getShell(), (String)"Delete Report Results", (String)"Do you really want to delete selected results?")) {
            return;
        }
        final ArrayList<UUID> resultIdList = new ArrayList<UUID>(selection.size());
        for (Object o : selection.toList()) {
            resultIdList.add(((ReportResult)o).getJobId());
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Delete report execution results", this.workbenchPart, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (UUID uuid : resultIdList) {
                    session.deleteReportResult(ReportExecutionForm.this.report.getId(), uuid);
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!ReportExecutionForm.this.isDisposed()) {
                            ReportExecutionForm.this.refreshResultList();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot delete report results";
            }
        }.start();
    }

    protected void addSchedule() {
        final HashMap<String, String> execParameters = new HashMap<String, String>();
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.size()) {
                execParameters.put(this.parameters.get(i).getName(), this.fields.get(i).getValue());
                ++i;
            }
        }
        final ReportingJob job = new ReportingJob(this.report);
        PropertyDialog dialog = PropertyDialog.createDialogOn((Shell)this.workbenchPart.getSite().getShell(), (String)"org.netxms.ui.eclipse.reporter.propertypages.General", (Object)job);
        dialog.getShell().setText("Report Execution Schedule");
        if (dialog.open() != 0) {
            return;
        }
        new ConsoleJob("Adding report schedule", this.workbenchPart, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ReportExecutionForm.this.session.scheduleReport(job, execParameters);
            }

            protected String getErrorMessage() {
                return String.format("Cannot schedule report %s", ReportExecutionForm.this.report.getName());
            }
        }.start();
    }

    private void deleteSchedules() {
        IStructuredSelection selection = (IStructuredSelection)this.scheduleList.getSelection();
        if (selection.size() == 0) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getShell(), (String)"Delete schedules", (String)"Do you really want to delete selected schedules?")) {
            return;
        }
        final ArrayList<UUID> schedulesIdList = new ArrayList<UUID>(selection.size());
        for (Object o : selection.toList()) {
            schedulesIdList.add(((ReportingJob)o).getJobId());
        }
        new ConsoleJob("Delete report schedules", this.workbenchPart, "org.netxms.ui.eclipse.reporter", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (UUID uuid : schedulesIdList) {
                    ReportExecutionForm.this.session.deleteReportSchedule(ReportExecutionForm.this.report.getId(), uuid);
                }
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ReportExecutionForm.this.isDisposed()) {
                            ReportExecutionForm.this.refreshResultList();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot delete report schedules";
            }
        }.start();
    }

    private void openReport(String fileName, ReportRenderFormat format) {
        Program program = Program.findProgram((String)format.getExtension());
        if (program != null) {
            program.execute(fileName);
        } else {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)"Report was rendered successfully, but external viewer cannot be opened");
        }
    }
}

