/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.client.NXCException;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Zone;
import org.netxms.client.server.ServerVariable;
import org.netxms.client.snmp.SnmpUsmCredential;

public class SnmpConfig {
    public static int SNMP_CONFIG_GLOBAL = -1;
    private Map<Integer, List<String>> communities;
    private Map<Integer, List<SnmpUsmCredential>> usmCredentials;
    private Map<Integer, List<String>> ports;

    private SnmpConfig() {
    }

    public static SnmpConfig load(NXCSession session) throws NXCException, IOException {
        SnmpConfig config = new SnmpConfig();
        config.communities = session.getSnmpCommunities();
        config.usmCredentials = session.getSnmpUsmCredentials();
        config.ports = SnmpConfig.loadPortConfig(session);
        return config;
    }

    private static Map<Integer, List<String>> loadPortConfig(NXCSession session) throws IOException, NXCException {
        List zones = session.getAllZones();
        HashMap<Integer, List<String>> ports = new HashMap<Integer, List<String>>();
        for (Zone z : zones) {
            if (z.getSnmpPorts().isEmpty()) continue;
            ports.put((int)z.getUIN(), z.getSnmpPorts());
        }
        Map variables = session.getServerVariables();
        ServerVariable v = (ServerVariable)variables.get("SNMPPorts");
        SnmpConfig.parsePorts(v != null ? v.getValue() : "", ports);
        return ports;
    }

    private static void parsePorts(String portList, Map<Integer, List<String>> ports) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(portList.split(",")));
        ports.put(SNMP_CONFIG_GLOBAL, list);
    }

    public String parsePorts() {
        StringBuilder str = new StringBuilder();
        List<String> list = this.ports.get(SNMP_CONFIG_GLOBAL);
        if (list == null) {
            return "";
        }
        int i = 0;
        while (i < list.size()) {
            str.append(list.get(i));
            if (i != list.size() - 1) {
                str.append(",");
            }
            ++i;
        }
        return str.toString();
    }

    public void save(NXCSession session) throws NXCException, IOException {
        session.updateSnmpCommunities(this.communities);
        session.updateSnmpUsmCredentials(this.usmCredentials);
        this.savePortConfig(session);
    }

    private void savePortConfig(NXCSession session) throws IOException, NXCException {
        session.setServerVariable("SNMPPorts", this.parsePorts());
        for (Integer i : this.ports.keySet()) {
            if (this.ports.get(i).isEmpty() || session.findZone((long)i.intValue()) == null) continue;
            NXCObjectModificationData data = new NXCObjectModificationData(session.findZone((long)i.intValue()).getObjectId());
            data.setSnmpPorts(this.ports.get(i));
            session.modifyObject(data);
        }
    }

    public List<String> getCommunities(long zoneUIN) {
        if (this.communities.containsKey((int)zoneUIN)) {
            return this.communities.get((int)zoneUIN);
        }
        return new ArrayList<String>();
    }

    public void addCommunityString(String communityString, long zoneUIN) {
        if (this.communities.containsKey((int)zoneUIN)) {
            this.communities.get((int)zoneUIN).add(communityString);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(communityString);
            this.communities.put((int)zoneUIN, list);
        }
    }

    public List<String> getPorts(long zoneUIN) {
        if (this.ports.containsKey((int)zoneUIN)) {
            return this.ports.get((int)zoneUIN);
        }
        return new ArrayList<String>();
    }

    public void addPort(String port, long zoneUIN) {
        if (this.ports.containsKey((int)zoneUIN)) {
            this.ports.get((int)zoneUIN).add(port);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(port);
            this.ports.put((int)zoneUIN, list);
        }
    }

    public List<SnmpUsmCredential> getUsmCredentials(long zoneUIN) {
        if (this.usmCredentials.containsKey((int)zoneUIN)) {
            return this.usmCredentials.get((int)zoneUIN);
        }
        return new ArrayList<SnmpUsmCredential>();
    }

    public void addUsmCredentials(SnmpUsmCredential credential, long zoneUIN) {
        if (this.usmCredentials.containsKey((int)zoneUIN)) {
            this.usmCredentials.get((int)zoneUIN).add(credential);
        } else {
            ArrayList<SnmpUsmCredential> list = new ArrayList<SnmpUsmCredential>();
            list.add(credential);
            this.usmCredentials.put((int)zoneUIN, list);
        }
    }
}

