/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.mt.MappingTable;
import org.netxms.client.mt.MappingTableEntry;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.views.helpers.MappingTableEntryComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.MappingTableEntryLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class MappingTableEditor
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.MappingTableEditor";
    public static final int COLUMN_KEY = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    private int mappingTableId;
    private MappingTable mappingTable;
    private NXCSession session;
    private SortableTableViewer viewer;
    private boolean modified = false;
    private Action actionNewRow;
    private Action actionDelete;
    private Action actionSave;
    private Action actionRefresh;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            this.mappingTableId = Integer.parseInt(site.getSecondaryId());
        }
        catch (Exception e) {
            throw new PartInitException("Internal error", (Throwable)e);
        }
        if (this.mappingTableId <= 0) {
            throw new PartInitException("Internal error");
        }
        Messages.get();
        this.setPartName(String.format(Messages.MappingTableEditor_InitialPartName, this.mappingTableId));
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        int[] widths = new int[]{200, 200, 400};
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.MappingTableEditor_ColKey;
        Messages.get();
        stringArray[1] = Messages.MappingTableEditor_ColValue;
        Messages.get();
        stringArray[2] = Messages.MappingTableEditor_ColComments;
        String[] names = stringArray;
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MappingTableEntryLabelProvider());
        this.viewer.setComparator((ViewerComparator)new MappingTableEntryComparator());
        this.viewer.setColumnProperties(new String[]{"key", "value", "comments"});
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.viewer.getTable()), new TextCellEditor((Composite)this.viewer.getTable()), new TextCellEditor((Composite)this.viewer.getTable())};
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier((ICellModifier)new CellModifier());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)MappingTableEditor.this.viewer.getSelection();
                MappingTableEditor.this.actionDelete.setEnabled(selection.size() > 0);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
        this.refresh();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.serverconfig.context.MappingTableEditor");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                if (MappingTableEditor.this.modified) {
                    Shell shell = MappingTableEditor.this.getSite().getShell();
                    Messages.get();
                    Messages.get();
                    if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.MappingTableEditor_RefreshConfirmation, (String)Messages.MappingTableEditor_RefreshConfirmationText)) {
                        return;
                    }
                }
                MappingTableEditor.this.refresh();
            }
        };
        Messages.get();
        this.actionNewRow = new Action(Messages.MappingTableEditor_NewRow, SharedIcons.ADD_OBJECT){

            public void run() {
                MappingTableEditor.this.addNewRow();
            }
        };
        this.actionNewRow.setEnabled(false);
        this.actionNewRow.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.add_new_row");
        handlerService.activateHandler(this.actionNewRow.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionNewRow));
        Messages.get();
        this.actionDelete = new Action(Messages.MappingTableEditor_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                MappingTableEditor.this.deleteRows();
            }
        };
        this.actionDelete.setEnabled(false);
        this.actionDelete.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.delete_rows");
        handlerService.activateHandler(this.actionDelete.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionDelete));
        Messages.get();
        this.actionSave = new Action(Messages.MappingTableEditor_Save, SharedIcons.SAVE){

            public void run() {
                new SaveJob().start();
            }
        };
        this.actionSave.setEnabled(false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNewRow);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNewRow);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                MappingTableEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNewRow);
        manager.add((IAction)this.actionDelete);
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
        SaveJob job = new SaveJob();
        job.start();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    public int promptToSaveOnClose() {
        return 3;
    }

    private void refresh() {
        Messages.get();
        new ConsoleJob(Messages.MappingTableEditor_LoadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final MappingTable t = MappingTableEditor.this.session.getMappingTable(MappingTableEditor.this.mappingTableId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        MappingTableEditor.this.mappingTable = t;
                        MappingTableEditor mappingTableEditor = MappingTableEditor.this;
                        Messages.get();
                        mappingTableEditor.setPartName(String.format(Messages.MappingTableEditor_PartName, MappingTableEditor.this.mappingTable.getName()));
                        MappingTableEditor.this.viewer.setInput((Object)MappingTableEditor.this.mappingTable.getData().toArray());
                        MappingTableEditor.this.actionNewRow.setEnabled(true);
                        MappingTableEditor.this.setModified(false);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.MappingTableEditor_LoadJobError;
            }
        }.start();
    }

    private void setModified(boolean m) {
        if (this.modified == m) {
            return;
        }
        this.modified = m;
        this.actionSave.setEnabled(m);
        this.firePropertyChange(257);
    }

    private void addNewRow() {
        if (this.mappingTable == null) {
            return;
        }
        MappingTableEntry e = new MappingTableEntry("", "", "");
        this.mappingTable.getData().add(e);
        this.viewer.setInput((Object)this.mappingTable.getData().toArray());
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)e));
        this.setModified(true);
        this.viewer.editElement((Object)e, 0);
    }

    private void deleteRows() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        for (Object o : selection.toList()) {
            this.mappingTable.getData().remove(o);
        }
        this.viewer.setInput((Object)this.mappingTable.getData().toArray());
        this.setModified(true);
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            MappingTableEntry e = (MappingTableEntry)element;
            boolean changed = false;
            if (property.equals("key")) {
                if (!e.getKey().equals(value)) {
                    e.setKey((String)value);
                    changed = true;
                }
            } else if (property.equals("value")) {
                if (!e.getValue().equals(value)) {
                    e.setValue((String)value);
                    changed = true;
                }
            } else if (property.equals("comments") && !e.getDescription().equals(value)) {
                e.setDescription((String)value);
                changed = true;
            }
            if (changed) {
                MappingTableEditor.this.viewer.refresh();
                MappingTableEditor.this.setModified(true);
            }
        }

        public Object getValue(Object element, String property) {
            MappingTableEntry e = (MappingTableEntry)element;
            if (property.equals("key")) {
                return e.getKey();
            }
            if (property.equals("value")) {
                return e.getValue();
            }
            if (property.equals("comments")) {
                return e.getDescription();
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }
    }

    private class SaveJob
    extends ConsoleJob {
        public SaveJob() {
            Messages.get();
            super(Messages.MappingTableEditor_SaveJobName, (IWorkbenchPart)MappingTableEditor.this, "org.netxms.ui.eclipse.serverconfig", null);
        }

        protected void runInternal(IProgressMonitor monitor) throws Exception {
            MappingTableEditor.this.session.updateMappingTable(MappingTableEditor.this.mappingTable);
            this.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    MappingTableEditor.this.setModified(false);
                }
            });
        }

        protected String getErrorMessage() {
            Messages.get();
            return Messages.MappingTableEditor_SaveJobError;
        }
    }
}

