/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.netxms.ui.eclipse.widgets.helpers.TreeSortingListener;

public class SortableTreeViewer
extends TreeViewer {
    public static final int DEFAULT_STYLE = -1;
    private boolean initialized = false;
    private TreeColumn[] columns;
    private TreeSortingListener sortingListener;

    public SortableTreeViewer(Composite parent, String[] names, int[] widths, int defaultSortingColumn, int defaultSortDir, int style) {
        super(new Tree(parent, style == -1 ? 65538 : style));
        this.getTree().setLinesVisible(true);
        this.getTree().setHeaderVisible(true);
        this.createColumns(names, widths, defaultSortingColumn, defaultSortDir);
    }

    public SortableTreeViewer(Composite parent, int style) {
        super(new Tree(parent, style == -1 ? 65538 : style));
        this.getTree().setLinesVisible(true);
        this.getTree().setHeaderVisible(true);
    }

    public void createColumns(String[] names, int[] widths, int defaultSortingColumn, int defaultSortDir) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.sortingListener = new TreeSortingListener(this);
        this.columns = new TreeColumn[names.length];
        int i = 0;
        while (i < names.length) {
            this.columns[i] = new TreeColumn(this.getTree(), 16384);
            this.columns[i].setText(names[i]);
            if (widths != null) {
                this.columns[i].setWidth(widths[i]);
            }
            this.columns[i].setData("ID", (Object)new Integer(i));
            this.columns[i].addSelectionListener((SelectionListener)this.sortingListener);
            ++i;
        }
        if (defaultSortingColumn >= 0 && defaultSortingColumn < names.length) {
            this.getTree().setSortColumn(this.columns[defaultSortingColumn]);
        }
        this.getTree().setSortDirection(defaultSortDir);
    }

    public TreeColumn getColumnById(int id) {
        int i = 0;
        while (i < this.columns.length) {
            if ((Integer)this.columns[i].getData("ID") == id) {
                return this.columns[i];
            }
            ++i;
        }
        return null;
    }

    public TreeColumn getColumnAtPoint(Point p) {
        TreeItem item = this.getTree().getItem(p);
        if (item == null) {
            return null;
        }
        int columnCount = this.getTree().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(p)) {
                return this.getTree().getColumn(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void disableSorting() {
        int i = 0;
        while (i < this.columns.length) {
            this.columns[i].removeSelectionListener((SelectionListener)this.sortingListener);
            ++i;
        }
        this.getTree().setSortColumn(null);
    }
}

