/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.GenericObject;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.DCIPropertyPageDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;

public class OtherOptions
extends DCIPropertyPageDialog {
    private DataCollectionItem dci;
    private Button checkShowOnTooltip;
    private Button checkShowInOverview;
    private Button checkCalculateStatus;
    private Button checkHideOnLastValues;
    private ObjectSelector relatedObject;

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkShowOnTooltip = new Button(dialogArea, 32);
        Messages.get();
        this.checkShowOnTooltip.setText(Messages.NetworkMaps_ShowInTooltips);
        this.checkShowOnTooltip.setSelection(this.dci.isShowOnObjectTooltip());
        this.checkShowInOverview = new Button(dialogArea, 32);
        Messages.get();
        this.checkShowInOverview.setText(Messages.OtherOptions_ShowlastValueInObjectOverview);
        this.checkShowInOverview.setSelection(this.dci.isShowInObjectOverview());
        this.checkCalculateStatus = new Button(dialogArea, 32);
        Messages.get();
        this.checkCalculateStatus.setText(Messages.OtherOptions_UseForStatusCalculation);
        this.checkCalculateStatus.setSelection(this.dci.isUsedForNodeStatusCalculation());
        this.checkHideOnLastValues = new Button(dialogArea, 32);
        this.checkHideOnLastValues.setText("Hide valie on \"Last Values\" page");
        this.checkHideOnLastValues.setSelection(this.dci.isHideOnLastValuesView());
        this.relatedObject = new ObjectSelector(dialogArea, 0, true);
        this.relatedObject.setLabel("Related object");
        this.relatedObject.setObjectClass(GenericObject.class);
        this.relatedObject.setObjectId(this.dci.getRelatedObject());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.relatedObject.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(boolean isApply) {
        this.dci.setShowOnObjectTooltip(this.checkShowOnTooltip.getSelection());
        this.dci.setShowInObjectOverview(this.checkShowInOverview.getSelection());
        this.dci.setUsedForNodeStatusCalculation(this.checkCalculateStatus.getSelection());
        this.dci.setHideOnLastValuesView(this.checkHideOnLastValues.getSelection());
        this.dci.setRelatedObject(this.relatedObject.getObjectId());
        this.editor.modify();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkShowOnTooltip.setSelection(false);
        this.checkShowInOverview.setSelection(false);
        this.checkCalculateStatus.setSelection(false);
        this.checkHideOnLastValues.setSelection(false);
        this.relatedObject.setObjectId(0L);
    }
}

