/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.IcmpStatCollectionMode;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ComparatorHelper;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ICMP
extends PropertyPage {
    private AbstractNode node;
    private ObjectSelector icmpProxy;
    private Button radioIcmpStatCollectionDefault;
    private Button radioIcmpStatCollectionOn;
    private Button radioIcmpStatCollectionOff;
    private TableViewer icmpTargets;
    private Set<InetAddress> icmpTargetSet = new HashSet<InetAddress>();

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        this.icmpTargetSet.addAll(Arrays.asList(this.node.getIcmpTargets()));
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.icmpProxy = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.icmpProxy.setLabel(Messages.Communication_Proxy);
        this.icmpProxy.setObjectId(this.node.getIcmpProxyId());
        this.icmpProxy.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group statCollectionGroup = new Group(dialogArea, 0);
        statCollectionGroup.setText("ICMP response statistic collection");
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        statCollectionGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        statCollectionGroup.setLayoutData((Object)gd);
        this.radioIcmpStatCollectionDefault = new Button((Composite)statCollectionGroup, 16);
        Messages.get();
        this.radioIcmpStatCollectionDefault.setText(Messages.NodePolling_Default);
        this.radioIcmpStatCollectionDefault.setSelection(this.node.getIcmpStatCollectionMode() == IcmpStatCollectionMode.DEFAULT);
        this.radioIcmpStatCollectionOn = new Button((Composite)statCollectionGroup, 16);
        Messages.get();
        this.radioIcmpStatCollectionOn.setText(Messages.NodePolling_On);
        this.radioIcmpStatCollectionOn.setSelection(this.node.getIcmpStatCollectionMode() == IcmpStatCollectionMode.ON);
        this.radioIcmpStatCollectionOff = new Button((Composite)statCollectionGroup, 16);
        Messages.get();
        this.radioIcmpStatCollectionOff.setText(Messages.NodePolling_Off);
        this.radioIcmpStatCollectionOff.setSelection(this.node.getIcmpStatCollectionMode() == IcmpStatCollectionMode.OFF);
        Group icmpTargetGroup = new Group(dialogArea, 0);
        icmpTargetGroup.setText("Additional ICMP poll targets");
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        icmpTargetGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        icmpTargetGroup.setLayout((Layout)layout);
        this.icmpTargets = new TableViewer((Composite)icmpTargetGroup, 67586);
        this.icmpTargets.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.icmpTargets.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((InetAddress)element).getHostAddress();
            }
        });
        this.icmpTargets.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ComparatorHelper.compareInetAddresses((InetAddress)((InetAddress)e1), (InetAddress)((InetAddress)e2));
            }
        });
        this.icmpTargets.setInput((Object)this.icmpTargetSet.toArray());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.icmpTargets.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)icmpTargetGroup, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        Messages.get();
        addButton.setText(Messages.AccessControl_Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                InputDialog dlg = new InputDialog(ICMP.this.getShell(), "Add IP Address", "IP address", "", null);
                if (dlg.open() == 0) {
                    try {
                        InetAddress addr = InetAddress.getByName(dlg.getValue().trim());
                        ICMP.this.icmpTargetSet.add(addr);
                        ICMP.this.icmpTargets.setInput((Object)ICMP.this.icmpTargetSet.toArray());
                    }
                    catch (UnknownHostException ex) {
                        MessageDialogHelper.openError((Shell)ICMP.this.getShell(), (String)"Invalid IP address", (String)"IP address is invalid");
                    }
                }
            }
        });
        final Button deleteButton = new Button(buttons, 8);
        Messages.get();
        deleteButton.setText(Messages.AccessControl_Delete);
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ICMP.this.icmpTargets.getSelection();
                for (Object addr : selection.toList()) {
                    ICMP.this.icmpTargetSet.remove(addr);
                }
                ICMP.this.icmpTargets.setInput((Object)ICMP.this.icmpTargetSet.toArray());
            }
        });
        this.icmpTargets.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteButton.setEnabled(!ICMP.this.icmpTargets.getSelection().isEmpty());
            }
        });
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        md.setIcmpProxy(this.icmpProxy.getObjectId());
        md.setIcmpTargets(this.icmpTargetSet);
        IcmpStatCollectionMode mode = this.radioIcmpStatCollectionOff.getSelection() ? IcmpStatCollectionMode.OFF : (this.radioIcmpStatCollectionOn.getSelection() ? IcmpStatCollectionMode.ON : IcmpStatCollectionMode.DEFAULT);
        md.setIcmpStatCollectionMode(mode);
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Updating ICMP settings for node %s", this.node.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return String.format("Cannot update ICMP settings for node %s", ICMP.this.node.getObjectName());
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ICMP.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.icmpProxy.setObjectId(0L);
    }
}

