/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.OverviewDciLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ViewRefreshController;
import org.netxms.ui.eclipse.tools.VisibilityValidator;

public class LastValues
extends OverviewPageElement {
    private TableViewer viewer;
    private ViewRefreshController refreshController = new ViewRefreshController((IViewPart)this.getObjectTab().getViewPart(), -1, new Runnable(){

        @Override
        public void run() {
            LastValues.this.refresh();
        }
    }, new VisibilityValidator(){

        public boolean isVisible() {
            return LastValues.this.getObjectTab().isActive();
        }
    });

    public LastValues(Composite parent, OverviewPageElement anchor, ObjectTab objectTab) {
        super(parent, anchor, objectTab);
    }

    @Override
    protected String getTitle() {
        Messages.get();
        return Messages.LastValues_Title;
    }

    @Override
    public boolean isApplicableForObject(AbstractObject object) {
        if (!(object instanceof DataCollectionTarget)) {
            return false;
        }
        return !((DataCollectionTarget)object).getOverviewDciData().isEmpty();
    }

    @Override
    protected Control createClientArea(Composite parent) {
        this.viewer = new TableViewer(parent, 98562);
        this.setupTable();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OverviewDciLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((DciValue)e1).getDescription().compareToIgnoreCase(((DciValue)e2).getDescription());
            }
        });
        this.viewer.setInput((Object)((DataCollectionTarget)this.getObject()).getOverviewDciData().toArray());
        this.viewer.getTable().getColumn(0).pack();
        this.viewer.getTable().getColumn(1).pack();
        this.createPopupMenu();
        this.refreshController.setInterval(30);
        this.refresh();
        return this.viewer.getTable();
    }

    private void setupTable() {
        TableColumn tc = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        tc.setText(Messages.LastValues_Description);
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        tc.setText(Messages.LastValues_Value);
        tc.setWidth(100);
        this.viewer.getTable().setHeaderVisible(false);
        this.viewer.getTable().setLinesVisible(false);
        this.viewer.getTable().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                GC gc = event.gc;
                gc.setBackground(LastValues.this.getDisplay().getSystemColor(25));
                gc.fillRectangle(event.x, event.y, event.width, event.height);
            }
        });
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                LastValues.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getObjectTab().getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("secondary"));
    }

    @Override
    protected void onObjectChange() {
        this.viewer.setInput((Object)((DataCollectionTarget)this.getObject()).getOverviewDciData().toArray());
        this.viewer.getTable().getColumn(0).pack();
        this.viewer.getTable().getColumn(1).pack();
    }

    private void refresh() {
        final NXCSession session = ConsoleSharedData.getSession();
        final long nodeId = this.getObject().getObjectId();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.LastValues_JobName, (IWorkbenchPart)this.getObjectTab().getViewPart(), "org.netxms.ui.eclipse.objectview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    final DciValue[] list = session.getLastValues(nodeId, false, true, false);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (LastValues.this.viewer.getControl().isDisposed() || LastValues.this.getObject().getObjectId() != nodeId) {
                                return;
                            }
                            LastValues.this.viewer.setInput((Object)list);
                            LastValues.this.viewer.getTable().getColumn(0).pack();
                            LastValues.this.viewer.getTable().getColumn(1).pack();
                        }
                    });
                }
                catch (Exception e) {
                    Activator.log("Exception in last values overview element", e);
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.LastValues_JobErrorMsg;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }
}

