/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.GenericObject;

public class Zone
extends GenericObject {
    private long uin;
    private long[] proxyNodes;
    private List<String> snmpPorts;

    public Zone(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.uin = msg.getFieldAsInt64(147L);
        this.proxyNodes = msg.getFieldAsUInt32Array(637L);
        this.snmpPorts = new ArrayList<String>(msg.getFieldAsInt32(607L));
        int i = 0;
        while (i < msg.getFieldAsInt32(607L)) {
            this.snmpPorts.add(msg.getFieldAsString(0x10000000L + (long)i));
            ++i;
        }
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public long getUIN() {
        return this.uin;
    }

    public List<AbstractObject> getProxyNodes() {
        return this.session.findMultipleObjects(this.proxyNodes, true);
    }

    @Override
    public String getObjectClassName() {
        return "Zone";
    }

    public List<String> getSnmpPorts() {
        return this.snmpPorts;
    }
}

