/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.ui.eclipse.datacollection.widgets.AbstractPolicyEditor;
import org.netxms.ui.eclipse.datacollection.widgets.LogParserEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserModifyListener;

public class LogParserPolicyEditor
extends AbstractPolicyEditor {
    private LogParserEditor editor;

    public LogParserPolicyEditor(Composite parent, int style, AgentPolicy policy, IViewPart viewPart) {
        super(parent, style, policy, viewPart);
        this.setLayout((Layout)new FillLayout());
        this.editor = new LogParserEditor(this, 0, false);
        this.editor.addModifyListener(new LogParserModifyListener(){

            @Override
            public void modifyParser() {
                LogParserPolicyEditor.this.fireModifyListeners();
            }
        });
        this.updateControlFromPolicy();
    }

    @Override
    protected void updateControlFromPolicy() {
        this.editor.setParserXml(this.getPolicy().getContent());
    }

    @Override
    public AgentPolicy updatePolicyFromControl() {
        this.getPolicy().setContent(this.editor.getParserXml());
        return this.getPolicy();
    }

    public boolean setFocus() {
        return this.editor.setFocus();
    }

    @Override
    public boolean isFindAndReplaceRequired() {
        return this.editor.isEditorTabSelected();
    }

    @Override
    public void setFindAndReplaceAction(FindReplaceAction actionFindReplace) {
        super.setFindAndReplaceAction(actionFindReplace);
        this.editor.setFindAndReplaceAction(actionFindReplace);
    }

    public boolean canPerformFind() {
        return this.editor.isEditorTabSelected();
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.editor.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
    }

    public Point getSelection() {
        return this.editor.getSelection();
    }

    public String getSelectionText() {
        return this.editor.getSelectionText();
    }

    public boolean isEditable() {
        return this.editor.isEditable();
    }

    public void replaceSelection(String text) {
        this.editor.replaceSelection(text);
    }
}

