/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.internal.databinding.observable.IStalenessConsumer;
import org.eclipse.core.internal.databinding.observable.StalenessTracker;

public final class UnionSet<E>
extends ObservableSet<E> {
    private Set<IObservableSet<? extends E>> childSets;
    private boolean stale = false;
    private HashMap<E, Integer> refCounts = null;
    private StalenessTracker stalenessTracker;
    private ISetChangeListener<E> childSetChangeListener = event -> this.processAddsAndRemoves(event.diff.getAdditions(), event.diff.getRemovals());
    private IStalenessConsumer stalenessConsumer = stale -> {
        boolean oldStale = this.stale;
        this.stale = stale;
        if (stale && !oldStale) {
            this.fireStale();
        }
    };

    public UnionSet(IObservableSet<? extends E>[] childSets) {
        this(new HashSet<IObservableSet<? extends E>>(Arrays.asList(childSets)));
    }

    public UnionSet(Set<IObservableSet<? extends E>> childSets) {
        this((Set<IObservableSet<? extends E>>)childSets, childSets.iterator().next().getElementType());
    }

    public UnionSet(IObservableSet<? extends E>[] childSets, Object elementType) {
        this((Set<IObservableSet<? extends E>>)new HashSet<IObservableSet<? extends E>>(Arrays.asList(childSets)), elementType);
    }

    public UnionSet(Set<IObservableSet<? extends E>> childSets, Object elementType) {
        super(childSets.iterator().next().getRealm(), null, elementType);
        this.childSets = childSets;
        this.stalenessTracker = new StalenessTracker(childSets.toArray(new IObservableSet[0]), this.stalenessConsumer);
    }

    @Override
    public boolean isStale() {
        this.getterCalled();
        if (this.refCounts != null) {
            return this.stale;
        }
        for (IObservableSet<E> childSet : this.childSets) {
            if (!childSet.isStale()) continue;
            return true;
        }
        return false;
    }

    private void processAddsAndRemoves(Set<? extends E> adds, Set<? extends E> removes) {
        int refs;
        Integer refCount;
        HashSet<E> addsToFire = new HashSet<E>();
        HashSet<E> removesToFire = new HashSet<E>();
        for (E added : adds) {
            refCount = this.refCounts.get(added);
            if (refCount == null) {
                this.refCounts.put(added, 1);
                addsToFire.add(added);
                continue;
            }
            refs = refCount;
            refCount = refs + 1;
            this.refCounts.put(added, refCount);
        }
        for (E removed : removes) {
            refCount = this.refCounts.get(removed);
            if (refCount == null) continue;
            refs = refCount;
            if (refs <= 1) {
                removesToFire.add(removed);
                this.refCounts.remove(removed);
                continue;
            }
            refCount = refCount - 1;
            this.refCounts.put(removed, refCount);
        }
        addsToFire.removeAll(removesToFire);
        if (addsToFire.size() > 0 || removesToFire.size() > 0) {
            this.fireSetChange(Diffs.createSetDiff(addsToFire, removesToFire));
        }
    }

    @Override
    protected void firstListenerAdded() {
        super.firstListenerAdded();
        this.refCounts = new HashMap();
        for (IObservableSet<E> childSet : this.childSets) {
            childSet.addSetChangeListener(this.childSetChangeListener);
            this.incrementRefCounts(childSet);
        }
        this.stalenessTracker = new StalenessTracker(this.childSets.toArray(new IObservable[0]), this.stalenessConsumer);
        this.setWrappedSet(this.refCounts.keySet());
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        for (IObservableSet<E> childSet : this.childSets) {
            childSet.removeSetChangeListener(this.childSetChangeListener);
            this.stalenessTracker.removeObservable(childSet);
        }
        this.refCounts = null;
        this.stalenessTracker = null;
        this.setWrappedSet(null);
    }

    private ArrayList<E> incrementRefCounts(Collection<? extends E> added) {
        ArrayList<E> adds = new ArrayList<E>();
        for (E next : added) {
            Integer refCount = this.refCounts.get(next);
            if (refCount == null) {
                adds.add(next);
                refCount = 1;
                this.refCounts.put(next, refCount);
                continue;
            }
            refCount = refCount + 1;
            this.refCounts.put(next, refCount);
        }
        return adds;
    }

    @Override
    protected void getterCalled() {
        super.getterCalled();
        if (this.refCounts == null) {
            this.setWrappedSet(this.computeElements());
        }
    }

    private Set<E> computeElements() {
        if (this.refCounts == null) {
            HashSet<? extends E> result = new HashSet<E>();
            for (IObservableSet<? extends E> iObservableSet : this.childSets) {
                result.addAll(iObservableSet);
            }
            return result;
        }
        return this.refCounts.keySet();
    }
}

