/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.maps.MapDCIInstance;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LinkDciValueProvider {
    private static LinkDciValueProvider instance;
    private Set<MapDCIInstance> dciIDList = Collections.synchronizedSet(new HashSet());
    private Map<Long, DciValue> cachedDciValues = new HashMap<Long, DciValue>();
    private NXCSession session = ConsoleSharedData.getSession();
    private Thread syncThread = new Thread(new Runnable(){

        @Override
        public void run() {
            LinkDciValueProvider.this.syncLastValues();
        }
    });
    private volatile boolean syncRunning = true;

    public static LinkDciValueProvider getInstance() {
        if (instance == null) {
            instance = new LinkDciValueProvider();
        }
        return instance;
    }

    public LinkDciValueProvider() {
        this.syncThread.setDaemon(true);
        this.syncThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncLastValues() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        while (this.syncRunning) {
            Map<Long, DciValue> map = this.cachedDciValues;
            synchronized (map) {
                Set<MapDCIInstance> set = this.dciIDList;
                synchronized (set) {
                    try {
                        if (this.dciIDList.size() > 0) {
                            DciValue[] values;
                            DciValue[] dciValueArray = values = this.session.getLastValues(this.dciIDList);
                            int n = values.length;
                            int n2 = 0;
                            while (n2 < n) {
                                DciValue v = dciValueArray[n2];
                                this.cachedDciValues.put(v.getId(), v);
                                ++n2;
                            }
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DciValue getDciLastValue(long dciID) {
        DciValue value;
        Map<Long, DciValue> map = this.cachedDciValues;
        synchronized (map) {
            value = this.cachedDciValues.get(dciID);
        }
        return value;
    }

    public void dispose() {
        this.syncRunning = false;
        this.syncThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDci(long nodeID, long dciID, NetworkMapPage mapPage) {
        Set<MapDCIInstance> set = this.dciIDList;
        synchronized (set) {
            boolean exists = false;
            for (MapDCIInstance item : this.dciIDList) {
                if (item.getDciID() != dciID) continue;
                item.addMap(mapPage.getId());
                exists = true;
                break;
            }
            if (!exists) {
                this.dciIDList.add(new MapDCIInstance(dciID, nodeID, 1, mapPage.getId()));
                this.syncThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDci(long nodeID, long dciID, String column, String instance, NetworkMapPage mapPage) {
        Set<MapDCIInstance> set = this.dciIDList;
        synchronized (set) {
            boolean exists = false;
            for (MapDCIInstance item : this.dciIDList) {
                if (item.getDciID() != dciID) continue;
                item.addMap(mapPage.getId());
                exists = true;
                break;
            }
            if (!exists) {
                this.dciIDList.add(new MapDCIInstance(dciID, nodeID, column, instance, 2, mapPage.getId()));
                this.syncThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDcis(NetworkMapPage mapPage) {
        Set<MapDCIInstance> set = this.dciIDList;
        synchronized (set) {
            ArrayList<MapDCIInstance> forRemove = new ArrayList<MapDCIInstance>();
            for (MapDCIInstance item : this.dciIDList) {
                if (!item.removeMap(mapPage.getId())) continue;
                forRemove.add(item);
            }
            for (MapDCIInstance item : forRemove) {
                this.dciIDList.remove(item);
            }
        }
    }

    public String getDciDataAsString(NetworkMapLink link) {
        if (!link.hasDciData()) {
            return "";
        }
        String result = "";
        SingleDciConfig[] dciList = link.getDciList();
        int i = 0;
        while (i < dciList.length) {
            DciValue v = this.getDciLastValue(dciList[i].dciId);
            if (v != null) {
                String formatString = dciList[i].getFormatString();
                result = String.valueOf(result) + v.format(formatString.isEmpty() ? "%s" : formatString);
            }
            if (++i == dciList.length) continue;
            result = String.valueOf(result) + "\n";
        }
        return result;
    }

    public String getDciDataAsString(List<SingleDciConfig> DCIList) {
        String result = "";
        int i = 0;
        while (i < DCIList.size()) {
            DciValue v = this.getDciLastValue(DCIList.get((int)i).dciId);
            if (v != null) {
                String formatString = DCIList.get(i).getFormatString();
                result = String.valueOf(result) + v.format(formatString.isEmpty() ? "%s" : formatString);
            }
            if (++i == DCIList.size()) continue;
            result = String.valueOf(result) + "\n";
        }
        return result;
    }

    public List<DciValue> getDciData(List<SingleDciConfig> DCIList) {
        ArrayList<DciValue> result = new ArrayList<DciValue>();
        int i = 0;
        while (i < DCIList.size()) {
            result.add(this.getDciLastValue(DCIList.get((int)i).dciId));
            ++i;
        }
        return result;
    }

    public DciValue getLastDciData(SingleDciConfig dci) {
        return this.getDciLastValue(dci.dciId);
    }
}

