/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.constants.DataType;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.ServiceContainer;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.charts.api.DataComparisonChart;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.AvailabilityChartConfig;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AvailabilityChartElement
extends ElementWidget
implements DisposeListener,
SessionListener {
    private AvailabilityChartConfig config;
    private DataComparisonChart chart;

    public AvailabilityChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = AvailabilityChartConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new AvailabilityChartConfig();
        }
        this.setLayout((Layout)new FillLayout());
        this.chart = ChartFactory.createPieChart((Composite)this, (int)0);
        this.chart.setTitleVisible(this.config.isShowTitle());
        this.chart.setChartTitle(this.config.getTitle());
        this.chart.setLegendPosition(this.config.getLegendPosition());
        this.chart.setLegendVisible(this.config.isShowLegend());
        this.chart.set3DModeEnabled(this.config.isShowIn3D());
        this.chart.setTranslucent(this.config.isTranslucent());
        this.chart.setRotation(225.0);
        Messages.get();
        Messages.get();
        this.chart.addParameter(new GraphItem(0L, 0L, 0, DataType.FLOAT, Messages.AvailabilityChartElement_Up, Messages.AvailabilityChartElement_Uptime, "%s"), 100.0);
        Messages.get();
        Messages.get();
        this.chart.addParameter(new GraphItem(0L, 0L, 0, DataType.FLOAT, Messages.AvailabilityChartElement_Down, Messages.AvailabilityChartElement_Downtime, "%s"), 0.0);
        this.chart.setPaletteEntry(0, new ChartColor(127, 154, 72));
        this.chart.setPaletteEntry(1, new ChartColor(158, 65, 62));
        this.chart.initializationComplete();
        this.addDisposeListener(this);
        ConsoleSharedData.getSession().addListener((SessionListener)this);
        this.refreshChart();
    }

    private void refreshChart() {
        NXCSession session = ConsoleSharedData.getSession();
        ServiceContainer service = (ServiceContainer)session.findObjectById(this.config.getObjectId(), ServiceContainer.class);
        if (service != null) {
            this.chart.updateParameter(0, service.getUptimeForDay(), false);
            this.chart.updateParameter(1, 100.0 - service.getUptimeForDay(), true);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        ConsoleSharedData.getSession().removeListener((SessionListener)this);
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 4 && n.getSubCode() == this.config.getObjectId() && !this.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AvailabilityChartElement.this.refreshChart();
                }
            });
        }
    }
}

