/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.TableElement;

public class Capabilities
extends TableElement {
    public Capabilities(Composite parent, OverviewPageElement anchor, ObjectTab objectTab) {
        super(parent, anchor, objectTab);
    }

    @Override
    protected String getTitle() {
        Messages.get();
        return Messages.Capabilities_Title;
    }

    @Override
    protected void fillTable() {
        if (!(this.getObject() instanceof AbstractNode)) {
            return;
        }
        AbstractNode node = (AbstractNode)this.getObject();
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsAgent, (node.getCapabilities() & 2) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsBridge, (node.getCapabilities() & 4) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsCDP, (node.getCapabilities() & 0x100) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsDot1x, (node.getCapabilities() & 0x2000) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsLLDP, (node.getCapabilities() & 0x400) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsNDP, (node.getCapabilities() & 0x200) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsPrinter, (node.getCapabilities() & 0x20) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsRouter, (node.getCapabilities() & 8) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsSMCLP, (node.getCapabilities() & 0x100000) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsSNMP, (node.getCapabilities() & 1) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsSTP, (node.getCapabilities() & 0x4000) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsVRRP, (node.getCapabilities() & 0x800) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagHasEntityMIB, (node.getCapabilities() & 0x8000) != 0);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagHasIfXTable, (node.getCapabilities() & 0x10000) != 0);
        this.addFlag("isUserAgent", (node.getCapabilities() & 0x400000) != 0);
        if ((node.getCapabilities() & 1) != 0) {
            Messages.get();
            this.addPair(Messages.Capabilities_SNMPPort, Integer.toString(node.getSnmpPort()));
            Messages.get();
            this.addPair(Messages.Capabilities_SNMPVersion, this.getSnmpVersionName(node.getSnmpVersion()));
        }
    }

    private void addFlag(String name, boolean value) {
        String string;
        if (value) {
            Messages.get();
            string = Messages.Capabilities_Yes;
        } else {
            Messages.get();
            string = Messages.Capabilities_No;
        }
        this.addPair(name, string);
    }

    private String getSnmpVersionName(int version) {
        switch (version) {
            case 0: {
                return "1";
            }
            case 1: {
                return "2c";
            }
            case 3: {
                return "3";
            }
        }
        return "???";
    }

    @Override
    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof AbstractNode;
    }
}

