/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;

public class Alarm {
    public static final int STATE_OUTSTANDING = 0;
    public static final int STATE_ACKNOWLEDGED = 1;
    public static final int STATE_RESOLVED = 2;
    public static final int STATE_TERMINATED = 3;
    public static final int STATE_MASK = 15;
    public static final int HELPDESK_STATE_IGNORED = 0;
    public static final int HELPDESK_STATE_OPEN = 1;
    public static final int HELPDESK_STATE_CLOSED = 2;
    private long id;
    private Severity currentSeverity;
    private Severity originalSeverity;
    private int repeatCount;
    private int state;
    private boolean sticky;
    private int acknowledgedByUser;
    private int resolvedByUser;
    private int terminatedByUser;
    private long sourceEventId;
    private int sourceEventCode;
    private long sourceObjectId;
    private long dciId;
    private Date creationTime;
    private Date lastChangeTime;
    private String message;
    private String key;
    private int helpdeskState;
    private String helpdeskReference;
    private int timeout;
    private int timeoutEvent;
    private int commentsCount;
    private int ackTime;
    private long[] categories;

    public Alarm(NXCPMessage msg) {
        this.id = msg.getFieldAsInt64(93L);
        this.currentSeverity = Severity.getByValue(msg.getFieldAsInt32(244L));
        this.originalSeverity = Severity.getByValue(msg.getFieldAsInt32(245L));
        this.repeatCount = msg.getFieldAsInt32(248L);
        this.state = msg.getFieldAsInt32(243L);
        this.sticky = msg.getFieldAsBoolean(420L);
        this.acknowledgedByUser = msg.getFieldAsInt32(95L);
        this.resolvedByUser = msg.getFieldAsInt32(419L);
        this.terminatedByUser = msg.getFieldAsInt32(242L);
        this.sourceEventId = msg.getFieldAsInt64(123L);
        this.sourceEventCode = msg.getFieldAsInt32(24L);
        this.sourceObjectId = msg.getFieldAsInt64(3L);
        this.dciId = msg.getFieldAsInt64(43L);
        this.creationTime = new Date(msg.getFieldAsInt64(240L) * 1000L);
        this.lastChangeTime = new Date(msg.getFieldAsInt64(241L) * 1000L);
        this.message = msg.getFieldAsString(66L);
        this.key = msg.getFieldAsString(64L);
        this.helpdeskState = msg.getFieldAsInt32(246L);
        this.helpdeskReference = msg.getFieldAsString(247L);
        this.timeout = msg.getFieldAsInt32(65L);
        this.timeoutEvent = msg.getFieldAsInt32(283L);
        this.commentsCount = msg.getFieldAsInt32(409L);
        this.ackTime = msg.getFieldAsInt32(94L);
        this.categories = msg.getFieldAsUInt32Array(641L);
    }

    public void setResolved(int userId, Date changeTime) {
        this.state = 2;
        this.lastChangeTime = changeTime;
        this.resolvedByUser = userId;
    }

    public long getId() {
        return this.id;
    }

    public Severity getCurrentSeverity() {
        return this.currentSeverity;
    }

    public Severity getOriginalSeverity() {
        return this.originalSeverity;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public int getState() {
        return this.state;
    }

    public int getAcknowledgedByUser() {
        return this.acknowledgedByUser;
    }

    public int getTerminatedByUser() {
        return this.terminatedByUser;
    }

    public long getSourceEventId() {
        return this.sourceEventId;
    }

    public int getSourceEventCode() {
        return this.sourceEventCode;
    }

    public long getSourceObjectId() {
        return this.sourceObjectId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getLastChangeTime() {
        return this.lastChangeTime;
    }

    public String getMessage() {
        return this.message;
    }

    public String getKey() {
        return this.key;
    }

    public int getHelpdeskState() {
        return this.helpdeskState;
    }

    public String getHelpdeskReference() {
        return this.helpdeskReference;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTimeoutEvent() {
        return this.timeoutEvent;
    }

    public int getCommentsCount() {
        return this.commentsCount;
    }

    public int getResolvedByUser() {
        return this.resolvedByUser;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public int getAckTime() {
        return this.ackTime;
    }

    public long[] getCategories() {
        return this.categories != null ? this.categories : new long[]{};
    }
}

