/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.dialogs;

import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.DateTimeSelector;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class SendUserAgentNotificationDialog
extends Dialog {
    private LabeledText textMessage;
    private Button checkStartup;
    private Button radioOneTime;
    private Button radioInterval;
    private DateTimeSelector startDateSelector;
    private Group retentionGroup;
    private LabeledSpinner days;
    private LabeledSpinner hours;
    private LabeledSpinner minutes;
    private String message;
    private Date startTime;
    private Date endTime;
    private boolean startupNotification;

    public SendUserAgentNotificationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Send user agent notification");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.textMessage = new LabeledText(dialogArea, 0, 2050);
        this.textMessage.setLabel("Message text:");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 200;
        gd.horizontalSpan = 2;
        this.textMessage.setLayoutData((Object)gd);
        this.textMessage.setFocus();
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SendUserAgentNotificationDialog.this.startDateSelector.setEnabled(SendUserAgentNotificationDialog.this.radioInterval.getSelection());
                SendUserAgentNotificationDialog.this.days.setEnabled(SendUserAgentNotificationDialog.this.radioInterval.getSelection());
                SendUserAgentNotificationDialog.this.hours.setEnabled(SendUserAgentNotificationDialog.this.radioInterval.getSelection());
                SendUserAgentNotificationDialog.this.minutes.setEnabled(SendUserAgentNotificationDialog.this.radioInterval.getSelection());
                if (SendUserAgentNotificationDialog.this.radioOneTime.getSelection()) {
                    SendUserAgentNotificationDialog.this.checkStartup.setSelection(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.checkStartup = new Button(dialogArea, 32);
        this.checkStartup.setText("Startup notification");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkStartup.setLayoutData((Object)gd);
        this.checkStartup.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (SendUserAgentNotificationDialog.this.checkStartup.getSelection()) {
                    SendUserAgentNotificationDialog.this.radioInterval.setSelection(true);
                    SendUserAgentNotificationDialog.this.radioOneTime.setSelection(false);
                    SendUserAgentNotificationDialog.this.startDateSelector.setEnabled(SendUserAgentNotificationDialog.this.radioInterval.getSelection());
                    SendUserAgentNotificationDialog.this.days.setEnabled(SendUserAgentNotificationDialog.this.radioInterval.getSelection());
                    SendUserAgentNotificationDialog.this.hours.setEnabled(SendUserAgentNotificationDialog.this.radioInterval.getSelection());
                    SendUserAgentNotificationDialog.this.minutes.setEnabled(SendUserAgentNotificationDialog.this.radioInterval.getSelection());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.radioOneTime = new Button(dialogArea, 16);
        this.radioOneTime.setText("One time");
        this.radioOneTime.setSelection(true);
        this.radioOneTime.addSelectionListener(listener);
        this.radioInterval = new Button(dialogArea, 16);
        this.radioInterval.setText("Interval");
        this.radioInterval.setSelection(false);
        this.radioInterval.addSelectionListener(listener);
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new DateTimeSelector(parent, style);
            }
        };
        this.startDateSelector = (DateTimeSelector)WidgetHelper.createLabeledControl((Composite)dialogArea, (int)0, (WidgetFactory)factory, (String)"", (Object)"WidgetHelper::default_layout_data");
        this.startDateSelector.setValue(new Date());
        this.retentionGroup = new Group(dialogArea, 0);
        Messages.get();
        this.retentionGroup.setText(Messages.ScheduleSelector_Schedule);
        layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.horizontalSpacing = 16;
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 3;
        this.retentionGroup.setLayout((Layout)layout);
        this.days = new LabeledSpinner((Composite)this.retentionGroup, 0);
        this.days.setLabel("Days");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.days.setLayoutData((Object)gridData);
        this.days.setRange(0, 999);
        this.days.setSelection(0);
        this.hours = new LabeledSpinner((Composite)this.retentionGroup, 0);
        this.hours.setLabel("Hours");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.hours.setLayoutData((Object)gridData);
        this.hours.setRange(0, 23);
        this.hours.setSelection(0);
        this.minutes = new LabeledSpinner((Composite)this.retentionGroup, 0);
        this.minutes.setLabel("Minutes");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.minutes.setLayoutData((Object)gridData);
        this.minutes.setRange(0, 59);
        this.minutes.setSelection(0);
        this.startDateSelector.setEnabled(false);
        this.days.setEnabled(false);
        this.hours.setEnabled(false);
        this.minutes.setEnabled(false);
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get default user agent notification retention time", null, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final int defaultTime = session.getPublicServerVariableAsInt("UserAgent.DefaultMessageRetentionTime");
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (defaultTime > 0) {
                            int d = defaultTime / 60 / 24;
                            int h = defaultTime / 60 - d * 24;
                            int m = defaultTime - (d * 24 + h) * 60;
                            SendUserAgentNotificationDialog.this.days.setSelection(d);
                            SendUserAgentNotificationDialog.this.hours.setSelection(h);
                            SendUserAgentNotificationDialog.this.minutes.setSelection(m);
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Error getting user agent default retention time";
            }
        }.start();
        return dialogArea;
    }

    protected void okPressed() {
        this.message = this.textMessage.getText();
        this.startupNotification = this.checkStartup.getSelection();
        if (this.radioInterval.getSelection()) {
            this.startTime = this.startDateSelector.getValue();
            this.endTime = new Date(new Date().getTime() + ((long)this.days.getSelection() * 86400L + (long)this.hours.getSelection() * 3600L + (long)this.minutes.getSelection() * 60L) * 1000L);
        } else {
            this.startTime = new Date(0L);
            this.endTime = new Date(0L);
        }
        super.okPressed();
    }

    public String getMessage() {
        return this.message;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isStartupNotification() {
        return this.startupNotification;
    }
}

