/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServiceRoot;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.DashboardGroup;
import org.netxms.client.objects.DashboardRoot;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.NetworkMapGroup;
import org.netxms.client.objects.NetworkMapRoot;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objects.TemplateRoot;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectActionValidator;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectOpenHandlerRegistry;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectOpenListener;
import org.netxms.ui.eclipse.objectbrowser.api.SubtreeType;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectTree;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.CommandBridge;
import org.netxms.ui.eclipse.tools.FilteringMenuManager;

public class ObjectBrowser
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.view.navigation.objectbrowser";
    private ObjectTree objectTree;
    private Action actionShowFilter;
    private Action actionShowStatusIndicator;
    private Action actionHideUnmanaged;
    private Action actionHideTemplateChecks;
    private Action actionHideSubInterfaces;
    private Action actionMoveObject;
    private Action actionMoveTemplate;
    private Action actionMoveBusinessService;
    private Action actionMoveDashboard;
    private Action actionMoveMap;
    private Action actionMovePolicy;
    private Action actionRefresh;
    private Action actionRenameObject;
    private Action actionHideNodeComponents;
    private boolean initHideUnmanaged = false;
    private boolean initHideTemplateChecks = false;
    private boolean initHideSubInterfaces = false;
    private boolean initShowFilter = true;
    private boolean initShowStatus = false;
    private boolean initHideNodeComponents = true;
    private String initialObjectSelection = null;
    private ObjectOpenHandlerRegistry openHandlers;
    private ObjectActionValidator[] actionValidators;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.initHideUnmanaged = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.hideUnmanaged"), false);
            this.initHideTemplateChecks = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.hideTemplateChecks"), false);
            this.initHideSubInterfaces = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.hideSubInterfaces"), false);
            this.initHideNodeComponents = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.hideNodeComponents"), true);
            this.initShowStatus = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.showStatusIndicator"), false);
            this.initialObjectSelection = memento.getString("ObjectBrowser.selectedObject");
        }
        this.openHandlers = new ObjectOpenHandlerRegistry();
        this.registerActionValidators();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = ObjectBrowser.safeCast(settings.get("ObjectBrowser.showFilter"), settings.getBoolean("ObjectBrowser.showFilter"), this.initShowFilter);
    }

    private static boolean safeCast(Boolean b, boolean defval) {
        return b != null ? b : defval;
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putBoolean("ObjectBrowser.hideUnmanaged", this.objectTree.isHideUnmanaged());
        memento.putBoolean("ObjectBrowser.hideTemplateChecks", this.objectTree.isHideTemplateChecks());
        memento.putBoolean("ObjectBrowser.hideSubInterfaces", this.objectTree.isHideSubInterfaces());
        memento.putBoolean("ObjectBrowser.showStatusIndicator", this.objectTree.isStatusIndicatorEnabled());
        memento.putBoolean("ObjectBrowser.hideNodeComponents", this.objectTree.isHideNodeComponents());
        this.saveSelection(memento);
    }

    public void createPartControl(Composite parent) {
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        long[] rootObjects = null;
        Object value = ConsoleSharedData.getProperty((String)"ObjectBrowser.rootObjects");
        if (value != null && value instanceof long[]) {
            rootObjects = (long[])value;
        }
        this.objectTree = new ObjectTree(parent, 0, 2, rootObjects, null, true, true, this.initHideNodeComponents);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.objectTree.setLayoutData(fd);
        this.objectTree.setHideSubInterfaces(this.initHideSubInterfaces);
        this.objectTree.setHideTemplateChecks(this.initHideTemplateChecks);
        this.objectTree.setHideUnmanaged(this.initHideUnmanaged);
        this.objectTree.enableFilter(this.initShowFilter);
        this.objectTree.enableStatusIndicator(this.initShowStatus);
        this.objectTree.addOpenListener(new ObjectOpenListener(){

            @Override
            public boolean openObject(AbstractObject object) {
                return ObjectBrowser.this.openHandlers.callOpenObjectHandler(object);
            }
        });
        this.createActions();
        this.createMenu();
        this.createToolBar();
        this.createPopupMenu();
        this.objectTree.enableDropSupport(this);
        this.objectTree.enableDragSupport();
        this.getSite().setSelectionProvider((ISelectionProvider)this.objectTree.getTreeViewer());
        this.objectTree.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)ObjectBrowser.this.objectTree.getTreeViewer().getSelection()).size();
                ObjectBrowser.this.actionMoveObject.setEnabled(size == 1);
            }
        });
        this.objectTree.setFilterCloseAction(new Action(){

            public void run() {
                ObjectBrowser.this.actionShowFilter.setChecked(false);
                ObjectBrowser.this.objectTree.enableFilter(false);
            }
        });
        TreeViewer tree = this.objectTree.getTreeViewer();
        TreeViewerEditor.create((TreeViewer)tree, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)tree){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 4;
            }
        }, (int)1);
        TextCellEditor editor = new TextCellEditor((Composite)tree.getTree(), 2048);
        editor.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
                ObjectBrowser.this.objectTree.enableRefresh();
            }

            public void applyEditorValue() {
            }
        });
        tree.setCellEditors(new CellEditor[]{editor});
        tree.setColumnProperties(new String[]{"name"});
        tree.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                Object data;
                Object object = data = element instanceof Item ? ((Item)element).getData() : element;
                if (property.equals("name") && data instanceof AbstractObject) {
                    final NXCSession session = ConsoleSharedData.getSession();
                    final String newName = value.toString();
                    Messages.get();
                    new ConsoleJob(Messages.ObjectBrowser_RenameJobName, null, "org.netxms.ui.eclipse.objectbrowser", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            session.setObjectName(((AbstractObject)data).getObjectId(), newName);
                        }

                        protected String getErrorMessage() {
                            Messages.get();
                            return String.format(Messages.ObjectBrowser_RenameJobError, ((AbstractObject)data).getObjectName());
                        }
                    }.start();
                }
                ObjectBrowser.this.objectTree.enableRefresh();
            }

            public Object getValue(Object element, String property) {
                if (property.equals("name") && element instanceof AbstractObject) {
                    return ((AbstractObject)element).getObjectName();
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                if (property.equals("name")) {
                    ObjectBrowser.this.objectTree.disableRefresh();
                    return true;
                }
                return false;
            }
        });
        this.activateContext();
        this.restoreSelection();
    }

    private void saveSelection(IMemento memento) {
        ITreeSelection selection = (ITreeSelection)this.objectTree.getTreeViewer().getSelection();
        if (selection.size() == 1) {
            TreePath path = selection.getPaths()[0];
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < path.getSegmentCount()) {
                sb.append('/');
                sb.append(((AbstractObject)path.getSegment(i)).getObjectId());
                ++i;
            }
            memento.putString("ObjectBrowser.selectedObject", sb.toString());
        } else {
            memento.putString("ObjectBrowser.selectedObject", "");
        }
    }

    private void restoreSelection() {
        if (this.initialObjectSelection == null || this.initialObjectSelection.isEmpty() || !this.initialObjectSelection.startsWith("/")) {
            return;
        }
        NXCSession session = ConsoleSharedData.getSession();
        String[] parts = this.initialObjectSelection.split("/");
        final Object[] elements = new Object[parts.length - 1];
        int i = 1;
        while (i < parts.length) {
            long id;
            try {
                id = Long.parseLong(parts[i]);
            }
            catch (NumberFormatException e) {
                return;
            }
            elements[i - 1] = session.findObjectById(id);
            if (elements[i - 1] == null) {
                return;
            }
            ++i;
        }
        this.objectTree.getTreeViewer().setSelection((ISelection)new TreeSelection(new TreePath(elements)), true);
        final Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                while (display.readAndDispatch()) {
                }
                CommandBridge.getInstance().execute("TabbedObjectView/changeObject", (Object)((AbstractObject)elements[elements.length - 1]).getObjectId());
            }
        });
    }

    public void setSelection(long objectId, String tabId) {
        NXCSession session = ConsoleSharedData.getSession();
        AbstractObject object = session.findObjectById(objectId);
        if (object != null) {
            this.objectTree.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)object), true);
            CommandBridge.getInstance().execute("TabbedObjectView/changeObject", (Object)objectId);
            if (tabId != null) {
                CommandBridge.getInstance().execute("TabbedObjectView/selectTab", (Object)tabId);
            }
        }
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objectbrowser.context.ObjectBrowser");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ObjectBrowser.this.objectTree.refresh();
            }
        };
        Messages.get();
        this.actionMoveObject = new Action(Messages.ObjectBrowser_MoveObject){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.INFRASTRUCTURE);
            }
        };
        this.actionMoveObject.setId("org.netxms.ui.eclipse.objectbrowser.actions.moveObject");
        Messages.get();
        this.actionMoveTemplate = new Action(Messages.ObjectBrowser_MoveTemplate){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.TEMPLATES);
            }
        };
        this.actionMoveTemplate.setId("org.netxms.ui.eclipse.objectbrowser.actions.moveTemplate");
        Messages.get();
        this.actionMoveBusinessService = new Action(Messages.ObjectBrowser_MoveService){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.BUSINESS_SERVICES);
            }
        };
        this.actionMoveBusinessService.setId("org.netxms.ui.eclipse.objectbrowser.actions.moveBusinessService");
        Messages.get();
        this.actionMoveDashboard = new Action(Messages.ObjectBrowser_MoveDashboard){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.DASHBOARDS);
            }
        };
        this.actionMoveDashboard.setId("org.netxms.ui.eclipse.objectbrowser.actions.moveDashboard");
        Messages.get();
        this.actionMoveMap = new Action(Messages.ObjectBrowser_MoveMap){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.MAPS);
            }
        };
        this.actionMoveMap.setId("org.netxms.ui.eclipse.objectbrowser.actions.moveMap");
        Messages.get();
        this.actionMovePolicy = new Action(Messages.ObjectBrowser_MovePolicy){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.POLICIES);
            }
        };
        this.actionMovePolicy.setId("org.netxms.ui.eclipse.objectbrowser.actions.movePolicy");
        Messages.get();
        this.actionHideUnmanaged = new Action(Messages.ObjectBrowser_HideUnmanaged, 2){

            public void run() {
                ObjectBrowser.this.objectTree.setHideUnmanaged(ObjectBrowser.this.actionHideUnmanaged.isChecked());
            }
        };
        this.actionHideUnmanaged.setId("org.netxms.ui.eclipse.objectbrowser.actions.hideUnmanaged");
        this.actionHideUnmanaged.setChecked(this.objectTree.isHideUnmanaged());
        Messages.get();
        this.actionHideTemplateChecks = new Action(Messages.ObjectBrowser_HideCheckTemplates, 2){

            public void run() {
                ObjectBrowser.this.objectTree.setHideTemplateChecks(ObjectBrowser.this.actionHideTemplateChecks.isChecked());
            }
        };
        this.actionHideTemplateChecks.setId("org.netxms.ui.eclipse.objectbrowser.actions.hideTemplateChecks");
        this.actionHideTemplateChecks.setChecked(this.objectTree.isHideTemplateChecks());
        Messages.get();
        this.actionHideSubInterfaces = new Action(Messages.ObjectBrowser_HideSubInterfaces, 2){

            public void run() {
                ObjectBrowser.this.objectTree.setHideSubInterfaces(ObjectBrowser.this.actionHideSubInterfaces.isChecked());
            }
        };
        this.actionHideSubInterfaces.setId("org.netxms.ui.eclipse.objectbrowser.actions.hideSubInterfaces");
        this.actionHideSubInterfaces.setChecked(this.objectTree.isHideSubInterfaces());
        Messages.get();
        this.actionShowFilter = new Action(Messages.ObjectBrowser_ShowFilter, 2){

            public void run() {
                ObjectBrowser.this.objectTree.enableFilter(ObjectBrowser.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setId("org.netxms.ui.eclipse.objectbrowser.actions.showFilter");
        this.actionShowFilter.setChecked(this.objectTree.isFilterEnabled());
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.objectbrowser.commands.show_object_filter");
        ActionHandler showFilterHandler = new ActionHandler((IAction)this.actionShowFilter);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)showFilterHandler);
        Messages.get();
        this.actionShowStatusIndicator = new Action(Messages.ObjectBrowser_ShowStatusIndicator, 2){

            public void run() {
                ObjectBrowser.this.objectTree.enableStatusIndicator(ObjectBrowser.this.actionShowStatusIndicator.isChecked());
            }
        };
        this.actionShowStatusIndicator.setId("org.netxms.ui.eclipse.objectbrowser.actions.showStatusIndicator");
        this.actionShowStatusIndicator.setChecked(this.objectTree.isStatusIndicatorEnabled());
        this.actionShowStatusIndicator.setActionDefinitionId("org.netxms.ui.eclipse.objectbrowser.commands.show_status_indicator");
        ActionHandler showStatusIndicatorHandler = new ActionHandler((IAction)this.actionShowStatusIndicator);
        handlerService.activateHandler(this.actionShowStatusIndicator.getActionDefinitionId(), (IHandler)showStatusIndicatorHandler);
        Messages.get();
        this.actionRenameObject = new Action(Messages.ObjectBrowser_Rename){

            public void run() {
                TreeItem[] selection = ObjectBrowser.this.objectTree.getTreeControl().getSelection();
                if (selection.length != 1) {
                    return;
                }
                ObjectBrowser.this.objectTree.getTreeViewer().editElement(selection[0].getData(), 0);
            }
        };
        this.actionRenameObject.setId("org.netxms.ui.eclipse.objectbrowser.actions.rename");
        this.actionRenameObject.setActionDefinitionId("org.netxms.ui.eclipse.objectbrowser.commands.rename_object");
        ActionHandler renameObjectHandler = new ActionHandler((IAction)this.actionRenameObject);
        handlerService.activateHandler(this.actionRenameObject.getActionDefinitionId(), (IHandler)renameObjectHandler);
        this.actionHideNodeComponents = new Action("Hide node components", 2){

            public void run() {
                ObjectBrowser.this.objectTree.setHideNodeComponent(ObjectBrowser.this.actionHideNodeComponents.isChecked());
            }
        };
        this.actionHideNodeComponents.setId("org.netxms.ui.eclipse.objectbrowser.actions.showHideNodeComponents");
        this.actionHideNodeComponents.setChecked(this.objectTree.isHideNodeComponents());
    }

    private void createMenu() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        FilteringMenuManager.add((IMenuManager)manager, (IAction)this.actionShowFilter, (String)"org.netxms.ui.eclipse.objectbrowser");
        FilteringMenuManager.add((IMenuManager)manager, (IAction)this.actionShowStatusIndicator, (String)"org.netxms.ui.eclipse.objectbrowser");
        FilteringMenuManager.add((IMenuManager)manager, (IAction)this.actionHideSubInterfaces, (String)"org.netxms.ui.eclipse.objectbrowser");
        FilteringMenuManager.add((IMenuManager)manager, (IAction)this.actionHideUnmanaged, (String)"org.netxms.ui.eclipse.objectbrowser");
        FilteringMenuManager.add((IMenuManager)manager, (IAction)this.actionHideTemplateChecks, (String)"org.netxms.ui.eclipse.objectbrowser");
        FilteringMenuManager.add((IMenuManager)manager, (IAction)this.actionHideNodeComponents, (String)"org.netxms.ui.eclipse.objectbrowser");
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        FilteringMenuManager.add((IMenuManager)manager, (IAction)this.actionRefresh, (String)"org.netxms.ui.eclipse.objectbrowser");
    }

    private void createToolBar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        FilteringMenuManager manager = new FilteringMenuManager("org.netxms.ui.eclipse.objectbrowser");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectBrowser.this.fillContextMenu(mgr);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.objectTree.getTreeControl());
        this.objectTree.getTreeControl().setMenu(menu);
        this.getSite().registerContextMenu((MenuManager)manager, (ISelectionProvider)this.objectTree.getTreeViewer());
    }

    protected void fillContextMenu(IMenuManager manager) {
        ObjectContextMenu.fill(manager, (IShellProvider)this.getSite(), (ISelectionProvider)this.objectTree.getTreeViewer());
        if (this.isValidSelectionForMove(SubtreeType.INFRASTRUCTURE)) {
            manager.insertAfter("objectbinding", (IAction)this.actionMoveObject);
        }
        if (this.isValidSelectionForMove(SubtreeType.TEMPLATES)) {
            manager.insertAfter("objectbinding", (IAction)this.actionMoveTemplate);
        }
        if (this.isValidSelectionForMove(SubtreeType.BUSINESS_SERVICES)) {
            manager.insertAfter("objectbinding", (IAction)this.actionMoveBusinessService);
        }
        if (this.isValidSelectionForMove(SubtreeType.DASHBOARDS)) {
            manager.insertAfter("objectbinding", (IAction)this.actionMoveDashboard);
        }
        if (this.isValidSelectionForMove(SubtreeType.MAPS)) {
            manager.insertAfter("objectbinding", (IAction)this.actionMoveMap);
        }
        if (this.isValidSelectionForMove(SubtreeType.POLICIES)) {
            manager.insertAfter("objectbinding", (IAction)this.actionMovePolicy);
        }
    }

    public void setFocus() {
        this.objectTree.setFocus();
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("ObjectBrowser.showFilter", this.objectTree.isFilterEnabled());
        super.dispose();
    }

    public boolean isValidSelectionForMove(SubtreeType subtree) {
        TreeItem[] selection = this.objectTree.getTreeControl().getSelection();
        if (selection.length < 1) {
            return false;
        }
        int i = 0;
        while (i < selection.length) {
            if (!this.isValidObjectForMove(selection, i, subtree) || ((AbstractObject)selection[0].getParentItem().getData()).getObjectId() != ((AbstractObject)selection[i].getParentItem().getData()).getObjectId()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isValidObjectForMove(TreeItem[] selection, int i, SubtreeType subtree) {
        if (selection[i].getParentItem() == null) {
            return false;
        }
        AbstractObject currentObject = (AbstractObject)selection[i].getData();
        AbstractObject parentObject = (AbstractObject)selection[i].getParentItem().getData();
        ObjectActionValidator[] objectActionValidatorArray = this.actionValidators;
        int n = this.actionValidators.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectActionValidator v = objectActionValidatorArray[n2];
            int result = v.isValidSelectionForMove(subtree, currentObject, parentObject);
            if (result == 0) {
                return true;
            }
            if (result == 1) {
                return false;
            }
            ++n2;
        }
        return false;
    }

    private void moveObject(SubtreeType subtree) {
        Set<Integer> filter;
        if (!this.isValidSelectionForMove(subtree)) {
            return;
        }
        ArrayList<Object> currentObject = new ArrayList<Object>();
        ArrayList<Object> parentObject = new ArrayList<Object>();
        TreeItem[] selection = this.objectTree.getTreeControl().getSelection();
        int i = 0;
        while (i < selection.length) {
            currentObject.add(selection[i].getData());
            parentObject.add(selection[i].getParentItem().getData());
            ++i;
        }
        switch (subtree) {
            case INFRASTRUCTURE: {
                filter = ObjectSelectionDialog.createContainerSelectionFilter();
                break;
            }
            case TEMPLATES: {
                filter = ObjectSelectionDialog.createTemplateGroupSelectionFilter();
                break;
            }
            case BUSINESS_SERVICES: {
                filter = ObjectSelectionDialog.createBusinessServiceSelectionFilter();
                break;
            }
            case DASHBOARDS: {
                filter = ObjectSelectionDialog.createDashboardGroupSelectionFilter();
                break;
            }
            case MAPS: {
                filter = ObjectSelectionDialog.createNetworkMapGroupsSelectionFilter();
                break;
            }
            case POLICIES: {
                filter = ObjectSelectionDialog.createPolicyGroupSelectionFilter();
                break;
            }
            default: {
                filter = null;
            }
        }
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, filter, currentObject);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            AbstractObject target = dlg.getSelectedObjects().get(0);
            int i2 = 0;
            while (i2 < selection.length) {
                this.performObjectMove(target, parentObject.get(i2), currentObject.get(i2), true);
                ++i2;
            }
        }
    }

    public void performObjectMove(final AbstractObject target, final Object parentObject, final Object currentObject, final boolean isMove) {
        if (target.getObjectId() != ((AbstractObject)parentObject).getObjectId()) {
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(String.valueOf(Messages.ObjectBrowser_MoveJob_Title) + ((AbstractObject)currentObject).getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectbrowser", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long objectId = ((AbstractObject)currentObject).getObjectId();
                    session.bindObject(target.getObjectId(), objectId);
                    if (isMove) {
                        session.unbindObject(((AbstractObject)parentObject).getObjectId(), objectId);
                    }
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return String.valueOf(Messages.ObjectBrowser_MoveJob_Error) + ((AbstractObject)currentObject).getObjectName();
                }
            }.start();
        }
    }

    private void registerActionValidators() {
        ArrayList<ActionValidatorData> list = new ArrayList<ActionValidatorData>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objectbrowser.objectActionValidators");
        int i = 0;
        while (i < elements.length) {
            try {
                ActionValidatorData v = new ActionValidatorData();
                v.validator = (ObjectActionValidator)elements[i].createExecutableExtension("class");
                v.priority = ObjectBrowser.safeParseInt(elements[i].getAttribute("priority"));
                list.add(v);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Collections.sort(list, new Comparator<ActionValidatorData>(){

            @Override
            public int compare(ActionValidatorData arg0, ActionValidatorData arg1) {
                return arg0.priority - arg1.priority;
            }
        });
        this.actionValidators = new ObjectActionValidator[list.size() + 1];
        i = 0;
        for (ActionValidatorData v : list) {
            this.actionValidators[i++] = v.validator;
        }
        this.actionValidators[i] = new ObjectActionValidator(){

            @Override
            public int isValidSelectionForMove(SubtreeType subtree, AbstractObject currentObject, AbstractObject parentObject) {
                switch (subtree) {
                    case INFRASTRUCTURE: {
                        return !(!(currentObject instanceof Node) && !(currentObject instanceof Cluster) && !(currentObject instanceof Subnet) && !(currentObject instanceof Condition) && !(currentObject instanceof Rack) && !(currentObject instanceof MobileDevice) && !(currentObject instanceof Container) && !(currentObject instanceof Sensor) || !(parentObject instanceof Container) && !(parentObject instanceof ServiceRoot)) ? 0 : 1;
                    }
                    case TEMPLATES: {
                        return !(!(currentObject instanceof Template) && !(currentObject instanceof TemplateGroup) || !(parentObject instanceof TemplateGroup) && !(parentObject instanceof TemplateRoot)) ? 0 : 1;
                    }
                    case BUSINESS_SERVICES: {
                        return currentObject instanceof BusinessService && (parentObject instanceof BusinessService || parentObject instanceof BusinessServiceRoot) ? 0 : 1;
                    }
                    case MAPS: {
                        return !(!(currentObject instanceof NetworkMap) && !(currentObject instanceof NetworkMapGroup) || !(parentObject instanceof NetworkMapGroup) && !(parentObject instanceof NetworkMapRoot)) ? 0 : 1;
                    }
                    case DASHBOARDS: {
                        return !(!(currentObject instanceof Dashboard) && !(currentObject instanceof DashboardGroup) || !(parentObject instanceof DashboardRoot) && !(parentObject instanceof DashboardGroup) && !(parentObject instanceof Dashboard)) ? 0 : 1;
                    }
                }
                return 1;
            }
        };
    }

    private static int safeParseInt(String s) {
        if (s == null) {
            return 65535;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 65535;
        }
    }

    private class ActionValidatorData {
        ObjectActionValidator validator;
        int priority;

        private ActionValidatorData() {
        }
    }
}

