/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.AvailabilityChart;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Capabilities;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Commands;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Comments;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.Connection;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.ExternalResources;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.GeneralInfo;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.LastValues;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;

public class ObjectOverview
extends ObjectTab {
    private Set<OverviewPageElement> elements = new HashSet<OverviewPageElement>();
    private ScrolledComposite scroller;
    private Composite viewArea;
    private Composite leftColumn;
    private Composite rightColumn;

    @Override
    protected void createTabContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 512);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        this.scroller.getVerticalBar().setIncrement(20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ObjectOverview.this.scroller.getClientArea();
                ObjectOverview.this.scroller.setMinSize(ObjectOverview.this.viewArea.computeSize(r.width, -1));
                ObjectOverview.this.objectChanged(ObjectOverview.this.getObject());
            }
        });
        this.viewArea = new Composite((Composite)this.scroller, 0);
        this.viewArea.setBackground(parent.getDisplay().getSystemColor(25));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.viewArea.setLayout((Layout)layout);
        this.scroller.setContent((Control)this.viewArea);
        this.leftColumn = new Composite(this.viewArea, 0);
        this.leftColumn.setLayout(this.createColumnLayout());
        this.leftColumn.setBackground(this.viewArea.getBackground());
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.leftColumn.setLayoutData((Object)gd);
        this.rightColumn = new Composite(this.viewArea, 0);
        this.rightColumn.setLayout(this.createColumnLayout());
        this.rightColumn.setBackground(this.viewArea.getBackground());
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = -1;
        this.rightColumn.setLayoutData((Object)gd);
        OverviewPageElement e = new GeneralInfo(this.leftColumn, null, this);
        this.elements.add(e);
        e = new LastValues(this.leftColumn, e, this);
        this.elements.add(e);
        e = new Commands(this.leftColumn, e, this);
        this.elements.add(e);
        e = new AvailabilityChart(this.leftColumn, e, this);
        this.elements.add(e);
        e = new ExternalResources(this.leftColumn, e, this);
        this.elements.add(e);
        e = new Comments(this.leftColumn, e, this);
        this.elements.add(e);
        e = new Capabilities(this.rightColumn, null, this);
        this.elements.add(e);
        e = new Connection(this.rightColumn, e, this);
        this.elements.add(e);
    }

    private Layout createColumnLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        return layout;
    }

    @Override
    public void currentObjectUpdated(AbstractObject object) {
        this.changeObject(object);
    }

    @Override
    public void objectChanged(AbstractObject object) {
        this.viewArea.setRedraw(false);
        for (OverviewPageElement element : this.elements) {
            if (object != null && element.isApplicableForObject(object)) {
                element.setObject(object);
                continue;
            }
            element.dispose();
        }
        for (OverviewPageElement element : this.elements) {
            element.fixPlacement();
        }
        this.viewArea.layout(true, true);
        this.viewArea.setRedraw(true);
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.viewArea.computeSize(r.width, -1));
        Point s = this.viewArea.getSize();
        this.viewArea.redraw(0, 0, s.x, s.y, true);
    }

    @Override
    public void refresh() {
        this.objectChanged(this.getObject());
    }
}

