/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.ZoneMember;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AlarmListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color FOREGROUND_COLOR_DARK = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private static final Color FOREGROUND_COLOR_LIGHT = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color[] FOREGROUND_COLORS = new Color[]{FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_LIGHT};
    private static final String[] stateText;
    private NXCSession session;
    private Image[] stateImages = new Image[5];
    private Image commentsImage;
    private boolean blinkState = true;
    private boolean showColor = true;
    private WorkbenchLabelProvider wbLabelProvider;
    private TableViewer viewer;

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.AlarmListLabelProvider_AlarmState_Outstanding;
        Messages.get();
        stringArray[1] = Messages.AlarmListLabelProvider_AlarmState_Acknowledged;
        Messages.get();
        stringArray[2] = Messages.AlarmListLabelProvider_AlarmState_Resolved;
        Messages.get();
        stringArray[3] = Messages.AlarmListLabelProvider_AlarmState_Terminated;
        stateText = stringArray;
    }

    public AlarmListLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
        this.session = ConsoleSharedData.getSession();
        this.stateImages[0] = Activator.getImageDescriptor("icons/outstanding.png").createImage();
        this.stateImages[1] = Activator.getImageDescriptor("icons/acknowledged.png").createImage();
        this.stateImages[2] = Activator.getImageDescriptor("icons/resolved.png").createImage();
        this.stateImages[3] = Activator.getImageDescriptor("icons/terminated.png").createImage();
        this.stateImages[4] = Activator.getImageDescriptor("icons/acknowledged_sticky.png").createImage();
        this.commentsImage = Activator.getImageDescriptor("icons/comments.png").createImage();
        this.wbLabelProvider = new WorkbenchLabelProvider();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        switch ((Integer)this.viewer.getTable().getColumn(columnIndex).getData("ID")) {
            case 0: {
                return StatusDisplayInfo.getStatusImage((Severity)((Alarm)element).getCurrentSeverity());
            }
            case 1: {
                if (((Alarm)element).getState() == 0) {
                    return this.blinkState ? this.stateImages[0] : SharedIcons.IMG_EMPTY;
                }
                if (((Alarm)element).getState() == 1 && ((Alarm)element).isSticky()) {
                    return this.stateImages[4];
                }
                return this.stateImages[((Alarm)element).getState()];
            }
            case 2: {
                AbstractObject object = this.session.findObjectById(((Alarm)element).getSourceObjectId());
                return object != null ? this.wbLabelProvider.getImage((Object)object) : null;
            }
            case 6: {
                return ((Alarm)element).getCommentsCount() > 0 ? this.commentsImage : null;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch ((Integer)this.viewer.getTable().getColumn(columnIndex).getData("ID")) {
            case 0: {
                return StatusDisplayInfo.getStatusText((Severity)((Alarm)element).getCurrentSeverity());
            }
            case 1: {
                int time = ((Alarm)element).getAckTime();
                String timeString = time > 0 ? " (" + RegionalSettings.getDateTimeFormat().format(System.currentTimeMillis() + (long)(time * 1000)) + ")" : "";
                return String.valueOf(stateText[((Alarm)element).getState()]) + timeString;
            }
            case 2: {
                AbstractObject object = this.session.findObjectById(((Alarm)element).getSourceObjectId());
                return object != null ? object.getObjectName() : "[" + Long.toString(((Alarm)element).getSourceObjectId()) + "]";
            }
            case 3: {
                if (this.session.isZoningEnabled()) {
                    ZoneMember zm = (ZoneMember)this.session.findObjectById(((Alarm)element).getSourceObjectId(), ZoneMember.class);
                    return zm != null ? zm.getZoneName() : "";
                }
                return "";
            }
            case 4: {
                return ((Alarm)element).getMessage();
            }
            case 5: {
                return Integer.toString(((Alarm)element).getRepeatCount());
            }
            case 6: {
                return ((Alarm)element).getCommentsCount() > 0 ? Integer.toString(((Alarm)element).getCommentsCount()) : null;
            }
            case 8: {
                if (((Alarm)element).getState() == 0) {
                    return null;
                }
                long userId = ((Alarm)element).getState() == 1 ? ((Alarm)element).getAcknowledgedByUser() : ((Alarm)element).getResolvedByUser();
                AbstractUserObject user = this.session.findUserDBObjectById(userId);
                return user != null ? user.getName() : "[" + Long.toString(((Alarm)element).getAcknowledgedByUser()) + "]";
            }
            case 9: {
                return RegionalSettings.getDateTimeFormat().format(((Alarm)element).getCreationTime());
            }
            case 10: {
                return RegionalSettings.getDateTimeFormat().format(((Alarm)element).getLastChangeTime());
            }
            case 7: {
                switch (((Alarm)element).getHelpdeskState()) {
                    case 1: {
                        return ((Alarm)element).getHelpdeskReference();
                    }
                    case 2: {
                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(((Alarm)element).getHelpdeskReference()));
                        Messages.get();
                        return stringBuilder.append(Messages.AlarmListLabelProvider_Closed).toString();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public void dispose() {
        int i = 0;
        while (i < this.stateImages.length) {
            this.stateImages[i].dispose();
            ++i;
        }
        super.dispose();
    }

    public void toggleBlinkState() {
        this.blinkState = !this.blinkState;
    }

    public Color getForeground(Object element) {
        return this.showColor ? FOREGROUND_COLORS[((Alarm)element).getCurrentSeverity().getValue()] : null;
    }

    public Color getBackground(Object element) {
        return this.showColor ? StatusDisplayInfo.getStatusColor((Severity)((Alarm)element).getCurrentSeverity()) : null;
    }

    public boolean isShowColor() {
        return this.showColor;
    }

    public void setShowColor(boolean showColor) {
        this.showColor = showColor;
    }
}

