/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.CreateSnmpDciDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.shared.MibCache;

public class CreateSnmpDci
implements IObjectActionDelegate {
    private Shell shell;
    private ViewPart viewPart;
    private List<SnmpValue> objects = new ArrayList<SnmpValue>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        CreateSnmpDciDialog dlg;
        String description;
        if (this.objects.size() == 0) {
            return;
        }
        MibObject mibObject = MibCache.findObject((String)this.objects.get(0).getName(), (boolean)false);
        String string = description = mibObject != null ? mibObject.getName() : this.objects.get(0).getName();
        if (this.objects.size() > 1) {
            description = String.valueOf(description) + " @@instance@@";
        }
        if ((dlg = new CreateSnmpDciDialog(this.shell, description)).open() != 0) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final ArrayList<SnmpValue> values = new ArrayList<SnmpValue>(this.objects);
        HashSet<AbstractNode> nodes = new HashSet<AbstractNode>();
        for (SnmpValue v : values) {
            AbstractNode node = (AbstractNode)session.findObjectById(v.getNodeId(), AbstractNode.class);
            if (node == null) continue;
            nodes.add(node);
        }
        final HashMap<Long, Boolean> lockRequired = new HashMap<Long, Boolean>(nodes.size());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        for (AbstractNode n : nodes) {
            IViewReference ref = page.findViewReference("org.netxms.ui.eclipse.datacollection.view.data_collection_editor", Long.toString(n.getObjectId()));
            lockRequired.put(n.getObjectId(), ref == null || ref.getView(false) == null);
        }
        Messages.get();
        new ConsoleJob(Messages.CreateSnmpDci_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", null){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.CreateSnmpDci_ErrorMessage;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Messages.get();
                monitor.beginTask(Messages.CreateSnmpDci_TaskTitle, values.size());
                for (SnmpValue v : values) {
                    String description = dlg.getDescription().replaceAll("@@instance@@", Long.toString(v.getObjectId().getIdFromPos(v.getObjectId().getLength() - 1)));
                    CreateSnmpDci.createDci(session, v, description, dlg.getPollingInterval(), dlg.getRetentionTime(), dlg.getDeltaCalculation(), lockRequired);
                    monitor.worked(1);
                }
                monitor.done();
            }
        }.start();
    }

    private static void createDci(NXCSession session, SnmpValue value, String description, int pollingInterval, int retentionTime, int deltaCalculation, Map<Long, Boolean> lockRequired) throws Exception {
        AbstractNode node = (AbstractNode)session.findObjectById(value.getNodeId(), AbstractNode.class);
        if (node == null) {
            throw new NXCException(46);
        }
        DataCollectionConfiguration dcc = lockRequired.get(node.getObjectId()) != false ? session.openDataCollectionConfiguration(node.getObjectId()) : new DataCollectionConfiguration(session, node.getObjectId());
        DataCollectionItem dci = new DataCollectionItem(dcc, 0L);
        dci.setPollingScheduleType(1);
        dci.setPollingInterval(Integer.toString(pollingInterval));
        dci.setRetentionType(1);
        dci.setRetentionTime(Integer.toString(retentionTime));
        dci.setOrigin(2);
        dci.setDataType(CreateSnmpDci.dciTypeFromAsnType(value.getType()));
        dci.setStatus(0);
        dci.setDescription(description);
        dci.setDeltaCalculation(deltaCalculation);
        dci.setName(value.getName());
        dcc.modifyObject((DataCollectionObject)dci);
        if (lockRequired.get(node.getObjectId()).booleanValue()) {
            dcc.close();
        }
    }

    private static DataType dciTypeFromAsnType(int type) {
        switch (type) {
            case 65: {
                return DataType.COUNTER32;
            }
            case 70: {
                return DataType.COUNTER64;
            }
            case 66: 
            case 67: 
            case 71: {
                return DataType.UINT32;
            }
            case 2: {
                return DataType.INT32;
            }
        }
        return DataType.STRING;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.objects.clear();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof SnmpValue)) continue;
                this.objects.add((SnmpValue)o);
            }
            action.setEnabled(this.objects.size() > 0);
        } else {
            action.setEnabled(false);
        }
    }
}

