/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateChassisDialog
extends Dialog {
    private LabeledText objectNameField;
    private ObjectSelector controllerSelector;
    private Button checkCreateAnother;
    private String objectName;
    private long controllerId = 0L;
    private boolean showAgain = false;

    public CreateChassisDialog(Shell parentShell, CreateChassisDialog prev) {
        super(parentShell);
        if (prev != null) {
            this.controllerId = prev.controllerId;
            this.showAgain = prev.showAgain;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create Chassis");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.objectNameField = new LabeledText(dialogArea, 0);
        this.objectNameField.setLabel("Name");
        this.objectNameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.objectNameField.setLayoutData((Object)gd);
        Composite ipAddrGroup = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        ipAddrGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        ipAddrGroup.setLayoutData((Object)gd);
        this.controllerSelector = new ObjectSelector(dialogArea, 0, true);
        this.controllerSelector.setLabel("Controller");
        this.controllerSelector.setObjectClass(Node.class);
        this.controllerSelector.setObjectId(this.controllerId);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.controllerSelector.setLayoutData((Object)gd);
        this.checkCreateAnother = new Button(dialogArea, 32);
        this.checkCreateAnother.setText("Show this dialog again to &create another chassis");
        this.checkCreateAnother.setSelection(this.showAgain);
        return dialogArea;
    }

    protected void okPressed() {
        this.objectName = this.objectNameField.getText().trim();
        if (this.objectName.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please provide non-empty object name");
            return;
        }
        this.controllerId = this.controllerSelector.getObjectId();
        this.showAgain = this.checkCreateAnother.getSelection();
        super.okPressed();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public long getControllerId() {
        return this.controllerId;
    }

    public boolean isShowAgain() {
        return this.showAgain;
    }
}

