/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class StackDropAgent
extends DropAgent {
    private Rectangle tabArea;
    private MPartStack dropStack;
    private CTabFolder dropCTF;

    public StackDropAgent(DnDManager manager) {
        super(manager);
    }

    @Override
    public boolean canDrop(MUIElement dragElement, DnDInfo info) {
        MWindow dropWin;
        if (!(dragElement instanceof MStackElement) && !(dragElement instanceof MPartStack)) {
            return false;
        }
        if (!(info.curElement instanceof MPartStack)) {
            return false;
        }
        MPartStack stack = (MPartStack)info.curElement;
        if (stack.getTags().contains("Standalone")) {
            return false;
        }
        if (!(stack.getWidget() instanceof CTabFolder)) {
            return false;
        }
        if (stack == dragElement) {
            return false;
        }
        EModelService ms = this.dndManager.getModelService();
        MWindow dragElementWin = ms.getTopLevelWindowFor(dragElement);
        if (dragElementWin != (dropWin = ms.getTopLevelWindowFor((MUIElement)stack))) {
            return false;
        }
        Rectangle areaRect = this.getTabAreaRect((CTabFolder)stack.getWidget());
        boolean inArea = areaRect.contains(info.cursorPos);
        if (inArea) {
            this.tabArea = areaRect;
            this.dropStack = (MPartStack)info.curElement;
            this.dropCTF = (CTabFolder)this.dropStack.getWidget();
        }
        return inArea;
    }

    private Rectangle getTabAreaRect(CTabFolder theCTF) {
        Rectangle ctfBounds = theCTF.getBounds();
        ctfBounds.height = theCTF.getTabHeight();
        Rectangle displayBounds = Display.getCurrent().map((Control)theCTF.getParent(), null, ctfBounds);
        return displayBounds;
    }

    private static List<CTabItem> getVisibleItems(CTabFolder dropCTF) {
        return Stream.of(dropCTF.getItems()).filter(i -> i.isShowing()).collect(Collectors.toList());
    }

    private static ArrayList<Rectangle> getItemRects(CTabFolder dropCTF, List<CTabItem> visibleItems, Rectangle tabArea) {
        ArrayList<Rectangle> itemRects = new ArrayList<Rectangle>();
        if (visibleItems.size() > 0) {
            CTabItem item = visibleItems.get(0);
            Rectangle itemRect = item.getBounds();
            int centerX = itemRect.x + itemRect.width / 2;
            itemRect.width /= 2;
            int curX = itemRect.x + itemRect.width;
            Rectangle insertRect = dropCTF.getDisplay().map((Control)dropCTF, null, itemRect);
            itemRects.add(insertRect);
            int i = 1;
            while (i < visibleItems.size()) {
                item = visibleItems.get(i);
                itemRect = item.getBounds();
                centerX = itemRect.x + itemRect.width / 2;
                itemRect.width = centerX - curX;
                itemRect.x = curX;
                curX = centerX;
                insertRect = dropCTF.getDisplay().map((Control)dropCTF, null, itemRect);
                itemRects.add(insertRect);
                ++i;
            }
            itemRect.x = curX;
            itemRect.width = dropCTF.getBounds().width - curX;
            insertRect = dropCTF.getDisplay().map((Control)dropCTF, null, itemRect);
            itemRects.add(insertRect);
        } else {
            itemRects.add(tabArea);
        }
        return itemRects;
    }

    private ArrayList<Rectangle> computeInsertRects() {
        List<CTabItem> visibleItems = StackDropAgent.getVisibleItems(this.dropCTF);
        return StackDropAgent.getItemRects(this.dropCTF, visibleItems, this.tabArea);
    }

    private int getDropIndex(DnDInfo info) {
        ArrayList<Rectangle> itemRects = this.computeInsertRects();
        for (Rectangle itemRect : itemRects) {
            if (!itemRect.contains(info.cursorPos)) continue;
            return itemRects.indexOf(itemRect);
        }
        return -1;
    }

    @Override
    public void dragLeave(MUIElement dragElement, DnDInfo info) {
        this.dndManager.clearOverlay();
        if (this.dndManager.getFeedbackStyle() == 1) {
            if (dragElement.getParent() != null) {
                this.dndManager.hostElement(dragElement, 16, 10);
            }
        } else {
            this.dndManager.setHostBounds(null);
        }
        this.tabArea = null;
        super.dragLeave(dragElement, info);
    }

    @Override
    public boolean track(MUIElement dragElement, DnDInfo info) {
        if (!this.tabArea.contains(info.cursorPos) || this.dropStack == null || !this.dropStack.isToBeRendered()) {
            return false;
        }
        int dropIndex = this.getDropIndex(info);
        if (dropIndex == -1) {
            return true;
        }
        this.dndManager.setCursor(Display.getCurrent().getSystemCursor(21));
        if (this.dropStack.getChildren().indexOf(dragElement) == dropIndex) {
            return true;
        }
        if (this.dndManager.getFeedbackStyle() == 1) {
            this.dock(dragElement, dropIndex);
            Display.getCurrent().update();
            this.showFrame(dragElement);
        } else {
            Rectangle itemBounds;
            List<CTabItem> visibleItems = StackDropAgent.getVisibleItems(this.dropCTF);
            if (dropIndex < visibleItems.size()) {
                itemBounds = visibleItems.get(dropIndex).getBounds();
                itemBounds.width = 2;
                itemBounds = Display.getCurrent().map((Control)this.dropCTF, null, itemBounds);
                this.dndManager.frameRect(itemBounds);
            } else if (visibleItems.size() > 0) {
                itemBounds = visibleItems.get(dropIndex - 1).getBounds();
                itemBounds.x += itemBounds.width;
                itemBounds.width = 2;
                itemBounds = Display.getCurrent().map((Control)this.dropCTF, null, itemBounds);
                this.dndManager.frameRect(itemBounds);
            } else {
                Rectangle fr = new Rectangle(this.tabArea.x, this.tabArea.y, this.tabArea.width, this.tabArea.height);
                fr.width = 2;
                this.dndManager.frameRect(fr);
            }
            if (this.dndManager.getFeedbackStyle() == 2) {
                Rectangle ca = this.dropCTF.getClientArea();
                ca = Display.getCurrent().map((Control)this.dropCTF, null, ca);
                this.dndManager.setHostBounds(ca);
            }
        }
        return true;
    }

    private void dock(MUIElement dragElement, int dropIndex) {
        MUIElement itemModel;
        CTabItem item;
        List<CTabItem> vItems = StackDropAgent.getVisibleItems(this.dropCTF);
        boolean hiddenTabs = vItems.size() < this.dropCTF.getChildren().length;
        List dropChildren = this.dropStack.getChildren();
        int elementIndex = dropChildren.indexOf(dragElement);
        MStackElement viewWithSameId = null;
        if (elementIndex == -1 && !dragElement.getTags().contains("Editor")) {
            for (MStackElement stackElement : dropChildren) {
                String id = stackElement.getElementId();
                if (id == null || !id.equals(dragElement.getElementId())) continue;
                viewWithSameId = stackElement;
                break;
            }
        }
        if (elementIndex != -1 && !(dragElement instanceof MPartStack)) {
            Control dragCtrl = (Control)dragElement.getWidget();
            CTabItem[] cTabItemArray = this.dropCTF.getItems();
            int n = cTabItemArray.length;
            int id = 0;
            while (id < n) {
                CTabItem cti = cTabItemArray[id];
                if (dragCtrl == cti.getControl()) {
                    int itemIndex = this.dropCTF.indexOf(cti);
                    if (dropIndex > 0 && itemIndex < dropIndex) {
                        --dropIndex;
                    }
                }
                ++id;
            }
        }
        if (hiddenTabs) {
            int nVisibleItems = vItems.size();
            if (dropIndex < nVisibleItems) {
                item = vItems.get(dropIndex);
                itemModel = (MUIElement)item.getData("modelElement");
                if (itemModel == dragElement) {
                    return;
                }
                dropIndex = itemModel.getParent().getChildren().indexOf(itemModel);
            } else if (dropIndex == nVisibleItems) {
                dropIndex = dropChildren.size();
            }
        } else {
            int ctfItemCount = this.dropCTF.getItemCount();
            if (dropIndex < ctfItemCount) {
                item = this.dropCTF.getItem(dropIndex);
                itemModel = (MUIElement)item.getData("modelElement");
                if (itemModel == dragElement) {
                    return;
                }
                dropIndex = itemModel.getParent().getChildren().indexOf(itemModel);
            } else if (dropIndex == ctfItemCount) {
                dropIndex = dropChildren.size();
            }
        }
        if (dragElement instanceof MStackElement) {
            if (dragElement.getParent() != null) {
                dragElement.getParent().getChildren().remove(dragElement);
            }
            if (dropIndex >= 0 && dropIndex < dropChildren.size()) {
                dropChildren.add(dropIndex, (MStackElement)dragElement);
            } else {
                dropChildren.add((MStackElement)dragElement);
            }
            if (viewWithSameId != null) {
                dropChildren.remove(viewWithSameId);
            }
            this.dropStack.setSelectedElement((MUIElement)((MStackElement)dragElement));
        } else {
            MPartStack stack = (MPartStack)dragElement;
            MStackElement curSel = (MStackElement)stack.getSelectedElement();
            List kids = stack.getChildren();
            int selIndex = kids.indexOf(curSel);
            boolean curSelProcessed = false;
            while (kids.size() > 1) {
                MStackElement kid;
                MStackElement mStackElement = kid = curSelProcessed ? (MStackElement)kids.get(kids.size() - 2) : (MStackElement)kids.get(kids.size() - 1);
                if (kid == curSel) {
                    curSelProcessed = true;
                    continue;
                }
                kids.remove(kid);
                if (dropIndex >= 0 && dropIndex < dropChildren.size()) {
                    dropChildren.add(dropIndex, kid);
                    continue;
                }
                dropChildren.add(kid);
            }
            kids.remove(curSel);
            if ((dropIndex += selIndex) >= 0 && dropIndex < dropChildren.size()) {
                dropChildren.add(dropIndex, curSel);
            } else {
                dropChildren.add(curSel);
            }
            this.dropStack.setSelectedElement((MUIElement)curSel);
        }
    }

    private void showFrame(MUIElement dragElement) {
        CTabFolder ctf = (CTabFolder)this.dropStack.getWidget();
        CTabItem[] items = ctf.getItems();
        CTabItem item = null;
        CTabItem[] cTabItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tabItem = cTabItemArray[n2];
            if (tabItem.getData("modelElement") == dragElement) {
                item = tabItem;
                break;
            }
            ++n2;
        }
        Rectangle bounds = item.getBounds();
        bounds = Display.getCurrent().map((Control)this.dropCTF, null, bounds);
        Rectangle outerBounds = new Rectangle(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6);
        this.dndManager.frameRect(outerBounds);
    }

    @Override
    public boolean drop(MUIElement dragElement, DnDInfo info) {
        int dropIndex;
        if (this.dndManager.getFeedbackStyle() != 1 && (dropIndex = this.getDropIndex(info)) != -1) {
            MUIElement toActivate = dragElement instanceof MPartStack ? ((MPartStack)dragElement).getSelectedElement() : dragElement;
            this.dock(dragElement, dropIndex);
            this.reactivatePart(toActivate);
        }
        return true;
    }
}

