/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.ProgressListener;
import org.netxms.client.objects.AgentPolicy;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.widgets.AbstractPolicyEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.FileDeliveryPolicy;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.FileDeliveryPolicyContentProvider;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.FileDeliveryPolicyLabelProvider;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.PathElement;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class FileDeliveryPolicyEditor
extends AbstractPolicyEditor {
    private TreeViewer fileTree;
    private Set<PathElement> rootElements = new HashSet<PathElement>();
    private Action actionAddRoot;
    private Action actionAddDirectory;
    private Action actionAddFile;
    private Action actionDelete;
    private Action actionRename;
    private Action actionUpdate;

    public FileDeliveryPolicyEditor(Composite parent, int style, AgentPolicy policy, IViewPart viewPart) {
        super(parent, style, policy, viewPart);
        this.setLayout((Layout)new FillLayout());
        this.fileTree = new TreeViewer((Composite)this, 0);
        this.fileTree.setContentProvider((IContentProvider)new FileDeliveryPolicyContentProvider());
        this.fileTree.setLabelProvider((IBaseLabelProvider)new FileDeliveryPolicyLabelProvider());
        this.fileTree.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                PathElement p1 = (PathElement)e1;
                PathElement p2 = (PathElement)e2;
                if (p1.isFile() && !p2.isFile()) {
                    return 1;
                }
                if (!p1.isFile() && p2.isFile()) {
                    return -1;
                }
                return p1.getName().compareToIgnoreCase(p2.getName());
            }
        });
        this.actionAddRoot = new Action("&Add root directory...", SharedIcons.ADD_OBJECT){

            public void run() {
                FileDeliveryPolicyEditor.this.addElement(null);
            }
        };
        this.actionAddDirectory = new Action("Add d&irectory..."){

            public void run() {
                FileDeliveryPolicyEditor.this.addDirectory();
            }
        };
        this.actionAddFile = new Action("Add &file..."){

            public void run() {
                FileDeliveryPolicyEditor.this.addFile();
            }
        };
        this.actionRename = new Action("&Rename..."){

            public void run() {
                FileDeliveryPolicyEditor.this.renameElement();
            }
        };
        this.actionDelete = new Action("&Delete"){

            public void run() {
                FileDeliveryPolicyEditor.this.deleteElements();
            }
        };
        this.actionUpdate = new Action("&Update..."){

            public void run() {
                FileDeliveryPolicyEditor.this.updateFile();
            }
        };
        this.createPopupMenu();
        this.updateControlFromPolicy();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FileDeliveryPolicyEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fileTree.getControl());
        this.fileTree.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.isEmpty()) {
            manager.add((IAction)this.actionAddRoot);
        } else if (selection.size() == 1) {
            PathElement e = (PathElement)selection.getFirstElement();
            if (e.isFile()) {
                manager.add((IAction)this.actionUpdate);
            } else {
                manager.add((IAction)this.actionAddDirectory);
                manager.add((IAction)this.actionAddFile);
            }
            manager.add((IAction)this.actionRename);
            manager.add((IAction)this.actionDelete);
        } else {
            manager.add((IAction)this.actionDelete);
        }
    }

    @Override
    protected void updateControlFromPolicy() {
        this.rootElements.clear();
        try {
            FileDeliveryPolicy policyData = FileDeliveryPolicy.createFromXml(this.getPolicy().getContent());
            this.rootElements.addAll(Arrays.asList(policyData.elements));
        }
        catch (Exception e) {
            Activator.logError("Cannot parse file delivery policy XML", e);
        }
        this.fileTree.setInput((Object)this.rootElements.toArray());
    }

    @Override
    public AgentPolicy updatePolicyFromControl() {
        FileDeliveryPolicy data = new FileDeliveryPolicy();
        data.elements = this.rootElements.toArray(new PathElement[this.rootElements.size()]);
        try {
            this.getPolicy().setContent(data.createXml());
        }
        catch (Exception e) {
            Activator.logError("Error serializing file delivery policy", e);
        }
        return this.getPolicy();
    }

    private void addDirectory() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1 || ((PathElement)selection.getFirstElement()).isFile()) {
            return;
        }
        this.addElement((PathElement)selection.getFirstElement());
    }

    private void addFile() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1 || ((PathElement)selection.getFirstElement()).isFile()) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getShell(), 4098);
        if (dlg.open() == null) {
            return;
        }
        final ArrayList<PathElement> uploadList = new ArrayList<PathElement>();
        String[] stringArray = dlg.getFileNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File f = new File(dlg.getFilterPath(), name);
            if (f.exists()) {
                PathElement e = new PathElement((PathElement)selection.getFirstElement(), f.getName(), f, UUID.randomUUID());
                uploadList.add(e);
            }
            ++n2;
        }
        if (!uploadList.isEmpty()) {
            this.fileTree.refresh();
            this.fireModifyListeners();
            final NXCSession session = ConsoleSharedData.getSession();
            new ConsoleJob("Upload files", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.datacollection", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    monitor.beginTask("Upload files", uploadList.size());
                    for (PathElement e : uploadList) {
                        monitor.subTask(e.getName());
                        session.uploadFileToServer(e.getLocalFile(), "FileDelivery-" + e.getGuid().toString(), null);
                        monitor.worked(1);
                    }
                    monitor.done();
                }

                protected String getErrorMessage() {
                    return "Cannot upload file";
                }
            }.start();
        }
    }

    private void updateFile() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1 || !((PathElement)selection.getFirstElement()).isFile()) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        final File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        final UUID guid = ((PathElement)selection.getFirstElement()).getGuid();
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Upload file", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(final IProgressMonitor monitor) throws Exception {
                session.uploadFileToServer(file, "FileDelivery-" + guid.toString(), new ProgressListener(){

                    public void setTotalWorkAmount(long workTotal) {
                        monitor.beginTask("Upload file", (int)file.length());
                    }

                    public void markProgress(long workDone) {
                        monitor.worked((int)workDone);
                    }
                });
                monitor.done();
            }

            protected String getErrorMessage() {
                return "Cannot upload file";
            }
        }.start();
    }

    private void addElement(PathElement parent) {
        InputDialog dlg = new InputDialog(this.getShell(), parent == null ? "New root directory" : "New directory", "Enter name for new directory", "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.isEmpty()) {
                    return "Name cannot be empty";
                }
                return null;
            }
        });
        if (dlg.open() != 0) {
            return;
        }
        PathElement e = new PathElement(parent, dlg.getValue());
        if (parent == null) {
            this.rootElements.add(e);
            this.fileTree.setInput((Object)this.rootElements.toArray());
        } else {
            this.fileTree.refresh();
        }
        this.fireModifyListeners();
    }

    private void renameElement() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        PathElement element = (PathElement)selection.getFirstElement();
        InputDialog dlg = new InputDialog(this.getShell(), element.isFile() ? "Rename file" : "Rename directory", "Enter new name", element.getName(), new IInputValidator(){

            public String isValid(String newText) {
                if (newText.isEmpty()) {
                    return "Name cannot be empty";
                }
                return null;
            }
        });
        if (dlg.open() != 0) {
            return;
        }
        if (element.getParent() == null) {
            this.rootElements.remove(element);
            element.setName(dlg.getValue());
            this.rootElements.add(element);
            this.fileTree.refresh();
        } else {
            element.setName(dlg.getValue());
            this.fileTree.update((Object)element, null);
        }
        this.fireModifyListeners();
    }

    private void deleteElements() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)"Delete confirmation", (String)"Delete selected files?")) {
            return;
        }
        boolean inputChanged = false;
        for (Object o : selection.toList()) {
            if (((PathElement)o).getParent() == null) {
                this.rootElements.remove(o);
                inputChanged = true;
                continue;
            }
            ((PathElement)o).remove();
        }
        if (inputChanged) {
            this.fileTree.setInput((Object)this.rootElements.toArray());
        } else {
            this.fileTree.refresh();
        }
        this.fireModifyListeners();
    }

    @Override
    public void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAddRoot);
    }

    @Override
    public void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAddRoot);
    }

    public boolean canPerformFind() {
        return false;
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return 0;
    }

    public Point getSelection() {
        return null;
    }

    public String getSelectionText() {
        return null;
    }

    public boolean isEditable() {
        return false;
    }

    public void replaceSelection(String text) {
    }

    @Override
    public boolean isFindAndReplaceRequired() {
        return false;
    }
}

