/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.jira.admin;

import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.radensolutions.jira.NetxmsConnector;
import com.radensolutions.jira.SettingsManager;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationAction
extends JiraWebActionSupport {
    private SettingsManager settingsManager;
    private String login;
    private String password = "";
    private String server1 = "";
    private String server2 = "";
    private String server3 = "";
    private String forced;
    private String enabled;
    private String projectKey = "";
    private String jiraAccount = "";
    private boolean success;

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServer1() {
        return this.server1;
    }

    public void setServer1(String server) {
        this.server1 = server;
    }

    public String getServer2() {
        return this.server2;
    }

    public void setServer2(String server) {
        this.server2 = server;
    }

    public String getServer3() {
        return this.server3;
    }

    public void setServer3(String server) {
        this.server3 = server;
    }

    public String getEnabled() {
        return this.enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    public void setForced(String forced) {
        this.forced = forced;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getJiraAccount() {
        return this.jiraAccount;
    }

    public void setJiraAccount(String jiraAccount) {
        this.jiraAccount = jiraAccount;
    }

    public ConfigurationAction(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
        List<String> servers = settingsManager.getServers();
        if (servers != null) {
            switch (servers.size()) {
                case 3: {
                    this.server3 = servers.get(2);
                }
                case 2: {
                    this.server2 = servers.get(1);
                }
                case 1: {
                    this.server1 = servers.get(0);
                }
            }
        }
        this.login = settingsManager.getLogin();
        this.password = settingsManager.getPassword();
        this.enabled = settingsManager.isEnabled() ? "on" : "off";
        this.projectKey = settingsManager.getProjectKey();
        this.jiraAccount = settingsManager.getJiraAccount();
    }

    protected void doValidation() {
        if ("on".equals(this.forced)) {
            this.forced = "";
            return;
        }
        if (this.projectKey.isEmpty()) {
            this.addErrorMessage("Project Key is not set");
        }
        if (this.server1.isEmpty() && this.server2.isEmpty() && this.server3.isEmpty()) {
            this.addErrorMessage("Server is not set");
            return;
        }
        if (this.login.isEmpty()) {
            this.addErrorMessage("Login is not set");
        }
        if (this.jiraAccount.isEmpty()) {
            this.addErrorMessage("Jira Account is not set");
        }
        if (this.enabled.equals("on")) {
            this.checkConnection(this.server1);
            this.checkConnection(this.server2);
            this.checkConnection(this.server3);
        }
    }

    private void checkConnection(String server) {
        StringBuffer error;
        if (!server.isEmpty() && !new NetxmsConnector(null).testConnection(server, this.login, this.password, error = new StringBuffer())) {
            this.addErrorMessage("Connection attempt to " + server + " failed: " + error.toString());
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ArrayList<String> servers = new ArrayList<String>();
        if (!this.server1.isEmpty()) {
            servers.add(this.server1);
        }
        if (!this.server2.isEmpty()) {
            servers.add(this.server2);
        }
        if (!this.server3.isEmpty()) {
            servers.add(this.server3);
        }
        this.settingsManager.setServers(servers);
        this.settingsManager.setLogin(this.login);
        this.settingsManager.setPassword(this.password);
        this.settingsManager.setEnabled(this.enabled.equals("on"));
        this.settingsManager.setProjectKey(this.projectKey);
        this.settingsManager.setJiraAccount(this.jiraAccount);
        this.success = true;
        return super.doDefault();
    }

    public boolean isSuccess() {
        return this.success;
    }
}

