/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.base.ElementStore;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.base.VirtualElementsData;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.VirtualizationObjectInputStream;
import net.sf.jasperreports.engine.fill.VirtualizationObjectOutputStream;
import net.sf.jasperreports.engine.util.DeepPrintElementCounter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementsBlock
implements JRVirtualizable<VirtualElementsData>,
ElementStore,
Serializable {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(ElementsBlock.class);
    private static final AtomicInteger uidCounter = new AtomicInteger();
    private static final Random uidRandom = new Random();
    private JRVirtualizationContext context;
    private String uid;
    private List<JRPrintElement> elements;
    private volatile transient int size;
    private transient VirtualElementsData virtualData;
    private transient int deepElementCount;
    private transient JRVirtualPrintPage page;

    public ElementsBlock(JRVirtualizationContext context, JRVirtualPrintPage page) {
        this.context = context;
        this.page = page;
        this.uid = this.makeUID();
        if (log.isDebugEnabled()) {
            log.debug((Object)("generated uid " + this.uid + " for " + this));
        }
        this.elements = new ArrayList<JRPrintElement>();
        this.size = 0;
        this.deepElementCount = 0;
    }

    public ElementsBlock(JRVirtualizationContext context, JRVirtualPrintPage page, String uid, int size) {
        this.context = context;
        this.page = page;
        this.uid = uid;
        this.size = size;
    }

    private void lockContext() {
        this.context.lock();
    }

    private void unlockContext() {
        this.context.unlock();
    }

    private void register() {
        if (this.context.getVirtualizer() != null) {
            this.context.getVirtualizer().registerObject(this);
        }
    }

    private String makeUID() {
        return System.identityHashCode(this.context) + "_" + System.identityHashCode(this) + "_" + uidCounter.incrementAndGet() + "_" + uidRandom.nextInt();
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public JRPrintElement get(int index) {
        this.lockContext();
        try {
            this.ensureDataAndTouch();
            JRPrintElement jRPrintElement = this.elements.get(index);
            return jRPrintElement;
        }
        finally {
            this.unlockContext();
        }
    }

    protected boolean preAdd(JRPrintElement element, boolean force) {
        int pageSize;
        boolean empty;
        boolean bl = empty = this.elements != null && this.elements.isEmpty();
        if (empty) {
            this.register();
        } else {
            this.ensureDataAndTouch();
        }
        int elementCount = DeepPrintElementCounter.count(element);
        if (!force && !this.elements.isEmpty() && (pageSize = this.context.getPageElementSize()) > 0 && this.deepElementCount + elementCount > pageSize) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("overflow of block with size " + this.deepElementCount + ", adding " + elementCount));
            }
            return false;
        }
        this.deepElementCount += elementCount;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(JRPrintElement element, boolean force) {
        this.lockContext();
        try {
            boolean adding = this.preAdd(element, force);
            if (adding) {
                this.elements.add(element);
                ++this.size;
            }
            boolean bl = adding;
            return bl;
        }
        finally {
            this.unlockContext();
        }
    }

    @Override
    public boolean add(JRPrintElement element) {
        return this.add(element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int index, JRPrintElement element, boolean force) {
        this.lockContext();
        try {
            boolean adding = this.preAdd(element, force);
            if (adding) {
                this.elements.add(index, element);
                ++this.size;
            }
            boolean bl = adding;
            return bl;
        }
        finally {
            this.unlockContext();
        }
    }

    @Override
    public boolean add(int index, JRPrintElement element) {
        return this.add(index, element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPrintElement set(int index, JRPrintElement element) {
        this.lockContext();
        try {
            this.ensureDataAndTouch();
            JRPrintElement oldElement = this.elements.get(index);
            this.deepElementCount -= DeepPrintElementCounter.count(oldElement);
            this.deepElementCount += DeepPrintElementCounter.count(element);
            JRPrintElement jRPrintElement = this.elements.set(index, element);
            return jRPrintElement;
        }
        finally {
            this.unlockContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPrintElement remove(int index) {
        this.lockContext();
        try {
            this.ensureDataAndTouch();
            JRPrintElement element = this.elements.remove(index);
            --this.size;
            this.deepElementCount -= DeepPrintElementCounter.count(element);
            if (this.elements.isEmpty()) {
                this.deregister();
            }
            JRPrintElement jRPrintElement = element;
            return jRPrintElement;
        }
        finally {
            this.unlockContext();
        }
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    private void ensureDataAndTouch() {
        if (this.elements == null) {
            this.ensureData();
        } else if (this.context.getVirtualizer() != null) {
            this.context.getVirtualizer().touch(this);
        }
    }

    @Override
    public void ensureVirtualData() {
        this.lockContext();
        try {
            if (this.elements == null) {
                this.ensureData();
            }
        }
        finally {
            this.unlockContext();
        }
    }

    private void ensureData() {
        if (this.context.getVirtualizer() != null) {
            this.context.getVirtualizer().requestData(this);
        }
    }

    @Override
    public void setVirtualData(VirtualElementsData virtualData) {
        this.lockContext();
        try {
            this.virtualData = virtualData;
            this.elements = virtualData.getElements();
        }
        finally {
            this.unlockContext();
        }
    }

    @Override
    public VirtualElementsData getVirtualData() {
        return this.virtualData;
    }

    @Override
    public void removeVirtualData() {
        this.lockContext();
        try {
            this.virtualData = null;
            this.elements = null;
        }
        finally {
            this.unlockContext();
        }
    }

    @Override
    public void beforeExternalization() {
        this.lockContext();
        try {
            this.virtualData = new VirtualElementsData(this.elements);
            this.context.beforeExternalization(this);
        }
        finally {
            this.unlockContext();
        }
    }

    @Override
    public void afterExternalization() {
        this.lockContext();
        try {
            this.context.afterExternalization(this);
        }
        finally {
            this.unlockContext();
        }
    }

    @Override
    public void afterInternalization() {
        this.lockContext();
        try {
            this.context.afterInternalization(this);
            this.virtualData = null;
        }
        finally {
            this.unlockContext();
        }
    }

    @Override
    public JRVirtualizationContext getContext() {
        return this.context;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String oldUid = (String)in.readObject();
        this.uid = this.makeUID();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Original uid " + oldUid + "; new uid " + this.uid));
        }
        this.context = (JRVirtualizationContext)in.readObject();
        int length = in.readInt();
        byte[] buffer = new byte[length];
        in.readFully(buffer);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, buffer.length);
        VirtualizationObjectInputStream elementsStream = new VirtualizationObjectInputStream(inputStream, this.context);
        this.elements = (List)elementsStream.readObject();
        this.size = this.elements.size();
        if (!this.elements.isEmpty()) {
            this.register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        this.lockContext();
        try {
            this.ensureDataAndTouch();
            this.beforeExternalization();
            try {
                out.writeObject(this.uid);
                out.writeObject(this.context);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                VirtualizationObjectOutputStream stream = new VirtualizationObjectOutputStream(bout, this.context);
                stream.writeObject(this.elements);
                stream.flush();
                byte[] bytes = bout.toByteArray();
                out.writeInt(bytes.length);
                out.write(bytes);
            }
            finally {
                this.afterExternalization();
            }
        }
        finally {
            this.unlockContext();
        }
    }

    @Override
    public void dispose() {
        this.lockContext();
        try {
            if (this.elements == null || !this.elements.isEmpty()) {
                this.deregister();
            }
        }
        finally {
            this.unlockContext();
        }
    }

    private void deregister() {
        if (this.context.getVirtualizer() != null) {
            this.context.getVirtualizer().deregisterObject(this);
        }
    }

    @Override
    public JRVirtualPrintPage getPage() {
        return this.page;
    }
}

