/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.util.ObjectUtils;

public abstract class JRTemplateGraphicElement
extends JRTemplateElement
implements JRCommonGraphicElement {
    private static final long serialVersionUID = 10200L;
    protected JRPen linePen;
    private FillEnum fillValue;
    private int PSEUDO_SERIAL_VERSION_UID = 30702;
    private Byte fill;

    protected JRTemplateGraphicElement(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        super(origin, defaultStyleProvider);
    }

    protected JRTemplateGraphicElement(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRGraphicElement graphicElement) {
        super(origin, defaultStyleProvider);
        this.setGraphicElement(graphicElement);
    }

    protected void setGraphicElement(JRGraphicElement graphicElement) {
        super.setElement(graphicElement);
        this.copyLinePen(graphicElement.getLinePen());
        this.setFill(graphicElement.getOwnFillValue());
    }

    public void copyLinePen(JRPen pen) {
        this.linePen = pen.clone(this);
    }

    @Override
    public JRPen getLinePen() {
        return this.linePen;
    }

    @Override
    public FillEnum getFillValue() {
        return this.getStyleResolver().getFillValue(this);
    }

    @Override
    public FillEnum getOwnFillValue() {
        return this.fillValue;
    }

    @Override
    public void setFill(FillEnum fillValue) {
        this.fillValue = fillValue;
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_1;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.fillValue = FillEnum.getByValue(this.fill);
            this.fill = null;
        }
    }

    protected void addGraphicHash(ObjectUtils.HashCode hash) {
        this.addTemplateHash(hash);
        hash.addIdentical(this.linePen);
        hash.add(this.fillValue);
    }

    protected boolean graphicIdentical(JRTemplateGraphicElement template) {
        return this.templateIdentical(template) && ObjectUtils.identical(this.linePen, template.linePen) && ObjectUtils.equals(this.fillValue, template.fillValue);
    }
}

