/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum IcmpStatCollectionMode {
    DEFAULT(0),
    ON(1),
    OFF(2);

    private int value;
    private static Map<Integer, IcmpStatCollectionMode> lookupTable;

    private IcmpStatCollectionMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static IcmpStatCollectionMode getByValue(int value) {
        IcmpStatCollectionMode element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)IcmpStatCollectionMode.class.getName(), (String)("Unknown element " + value));
            return DEFAULT;
        }
        return element;
    }

    static {
        lookupTable = new HashMap<Integer, IcmpStatCollectionMode>();
        for (IcmpStatCollectionMode element : IcmpStatCollectionMode.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

