/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.IllegalFormatException;
import org.netxms.client.constants.DataType;

public class DataFormatter {
    private String formatString;
    private boolean useBinaryMultipliers;
    private DataType dataType;
    private static final long[] DECIMAL_MULTIPLIERS = new long[]{1L, 1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L};
    private static final long[] BINARY_MULTIPLIERS = new long[]{1L, 1024L, 0x100000L, 0x40000000L, 0x10000000000L, 0x1000000000000000L};
    private static final String[] SUFFIX = new String[]{"", " k", " M", " G", " T", " P"};
    private static final String[] BINARY_SUFFIX = new String[]{"", " Ki", " Mi", " Gi", " Ti", " Pi"};

    public DataFormatter(String formatString, DataType dataType, boolean useBinaryMultipliers) {
        this.formatString = formatString;
        this.dataType = dataType;
        this.useBinaryMultipliers = useBinaryMultipliers;
    }

    public DataFormatter(String formatString, DataType dataType) {
        this(formatString, dataType, false);
    }

    public String format(String value) {
        StringBuilder sb = new StringBuilder();
        char[] format = this.formatString.toCharArray();
        for (int i = 0; i < format.length; ++i) {
            if (format[i] == '%') {
                int j;
                if (format[++i] == '%') {
                    sb.append('%');
                    continue;
                }
                for (j = i; j < format.length && !Character.isLetter(format[j]); ++j) {
                }
                if (j + 1 < format.length && (format[j] == 't' || format[j] == 'T') && Character.isLetter(format[j + 1])) {
                    ++j;
                }
                boolean useMultipliers = false;
                if (format[i] == '*') {
                    ++i;
                    useMultipliers = true;
                }
                String f = "%" + new String(Arrays.copyOfRange(format, i, j + 1));
                i = j;
                try {
                    Value v = this.getValueForFormat(value, useMultipliers, format[j] == 's' || format[j] == 'S', format[j] == 'd');
                    sb.append(String.format(f, v.value));
                    sb.append(v.suffix);
                }
                catch (IndexOutOfBoundsException | IllegalFormatException e) {
                    sb.append("<INVALID FORMAT> (");
                    sb.append(f.trim());
                    sb.append(")");
                }
                continue;
            }
            sb.append(format[i]);
        }
        return sb.toString();
    }

    private Value getValueForFormat(String value, boolean useMultipliers, boolean stringOutput, boolean decimalOutput) {
        Value v = new Value();
        if (this.dataType != DataType.INT32 && this.dataType != DataType.UINT32 && this.dataType != DataType.COUNTER32 && this.dataType != DataType.INT64 && this.dataType != DataType.UINT64 && this.dataType != DataType.COUNTER64 && this.dataType != DataType.FLOAT) {
            v.value = value;
            return v;
        }
        try {
            if (useMultipliers) {
                int i;
                long[] multipliers = this.useBinaryMultipliers ? BINARY_MULTIPLIERS : DECIMAL_MULTIPLIERS;
                Double d = Double.parseDouble(value);
                for (i = multipliers.length - 1; i >= 0 && !(d >= (double)multipliers[i]) && !(d <= (double)(-multipliers[i])); --i) {
                }
                if (i >= 0) {
                    if (stringOutput) {
                        NumberFormat nf = NumberFormat.getNumberInstance();
                        nf.setMaximumFractionDigits(2);
                        v.value = nf.format(d / (double)multipliers[i]);
                    } else {
                        v.value = d / (double)multipliers[i];
                    }
                    v.suffix = this.useBinaryMultipliers ? BINARY_SUFFIX[i] : SUFFIX[i];
                } else {
                    v.value = stringOutput ? value : (this.dataType == DataType.FLOAT ? (Number)Double.parseDouble(value) : (Number)Long.parseLong(value));
                }
            } else {
                v.value = stringOutput ? value : (this.dataType == DataType.FLOAT ? (Number)Double.parseDouble(value) : (Number)Long.parseLong(value));
            }
        }
        catch (NumberFormatException e) {
            v.value = value;
        }
        if (decimalOutput && v.value instanceof Double) {
            v.value = ((Double)v.value).longValue();
        }
        return v;
    }

    private static int calculatePrecision(double number) {
        int i = 0;
        if (number == 0.0 || number >= 1.0) {
            return i;
        }
        for (i = 1; i < 1000; ++i) {
            double d;
            number *= 10.0;
            if (d >= 1.0) break;
        }
        return i;
    }

    public static String roundDecimalValue(double value, double step, int maxPrecision) {
        int i;
        if (value == 0.0) {
            return "0";
        }
        double absValue = Math.abs(value);
        long[] multipliers = DECIMAL_MULTIPLIERS;
        for (i = multipliers.length - 1; i >= 0 && !(absValue >= (double)multipliers[i]); --i) {
        }
        int precision = step < 1.0 || i < 0 ? (DataFormatter.calculatePrecision(step) > maxPrecision ? maxPrecision : DataFormatter.calculatePrecision(step)) : (DataFormatter.calculatePrecision(step / (double)multipliers[i]) > maxPrecision ? maxPrecision : DataFormatter.calculatePrecision(step / (double)multipliers[i]));
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(precision);
        return df.format(i < 0 ? value : value / (double)multipliers[i]) + (i < 0 ? "" : SUFFIX[i]);
    }

    private class Value {
        Object value;
        String suffix = "";

        private Value() {
        }
    }
}

