/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.netxms.client.NXCException;
import org.netxms.client.constants.HistoricalDataType;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.websvc.handlers.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrafanaDataCollection
extends AbstractHandler {
    private List<AbstractObject> objects;
    private Logger log = LoggerFactory.getLogger(GrafanaDataCollection.class);

    protected Object getCollection(Map<String, String> query) throws Exception {
        if (!this.getSession().isObjectsSynchronized()) {
            this.getSession().syncObjects();
        }
        this.objects = this.getSession().getAllObjects();
        if (query.containsKey("targets")) {
            return this.getGraphData(query);
        }
        if (query.containsKey("target")) {
            return this.getDciList(query);
        }
        return this.getNodeList();
    }

    private JsonArray getGraphData(Map<String, String> query) throws Exception {
        JSONArray targets = new JSONArray(query.get("targets"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        Date from = format.parse(query.get("from").substring(1, query.get("from").length() - 1));
        Date to = format.parse(query.get("to").substring(1, query.get("to").length() - 1));
        JsonArray result = new JsonArray();
        for (Object o : targets) {
            String dciName;
            JSONObject object;
            if (!(o instanceof JSONObject) || !(object = (JSONObject)o).has("dciTarget") || !object.has("dci")) continue;
            JSONObject dciTarget = object.getJSONObject("dciTarget");
            JSONObject dci = object.getJSONObject("dci");
            long dciTargetId = dciTarget.optLong("id", 0L);
            long dciId = dci.optLong("id", 0L);
            String string = dciName = dci.getString("name").isEmpty() ? ".*" : dci.getString("name");
            if (dciId == 0L) {
                String dciTargetName = dciTarget.getString("name").isEmpty() ? ".*" : dciTarget.getString("name");
                boolean searchByName = object.optBoolean("searchByName");
                if (dciTargetName.startsWith("/") && dciTargetName.endsWith("/")) {
                    dciTargetName = dciTargetName.substring(1, dciTargetName.length() - 1);
                }
                if (dciName.startsWith("/") && dciName.endsWith("/")) {
                    dciName = dciName.substring(1, dciName.length() - 1);
                }
                List values = this.getSession().findMatchingDCI(dciTargetId, dciTargetName, dciName, searchByName ? 1 : 0);
                for (DciValue v : values) {
                    result.add((JsonElement)this.fillGraphData(Long.valueOf(v.getNodeId()), Long.valueOf(v.getId()), v.getDescription(), from, to));
                }
                continue;
            }
            if (dciTargetId == 0L || dciId == 0L) continue;
            String legend = object.getString("legend").isEmpty() ? dciName : object.getString("legend");
            result.add((JsonElement)this.fillGraphData(Long.valueOf(dciTargetId), Long.valueOf(dciId), legend, from, to));
        }
        return result;
    }

    private JsonObject fillGraphData(Long objectId, Long dciId, String legend, Date from, Date to) throws IOException, NXCException {
        DciData data = this.getSession().getCollectedData(objectId.longValue(), dciId.longValue(), from, to, 0, HistoricalDataType.PROCESSED);
        JsonObject root = new JsonObject();
        JsonArray datapoints = new JsonArray();
        DciDataRow[] values = data.getValues();
        for (int i = values.length - 1; i >= 0; --i) {
            DciDataRow r = values[i];
            JsonArray datapoint = new JsonArray();
            datapoint.add((Number)r.getValueAsDouble());
            datapoint.add((Number)r.getTimestamp().getTime());
            datapoints.add((JsonElement)datapoint);
        }
        root.addProperty("target", legend);
        root.add("datapoints", (JsonElement)datapoints);
        return root;
    }

    private Map<Long, String> getNodeList() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        for (AbstractObject o : this.objects) {
            if (!(o instanceof DataCollectionTarget)) continue;
            result.put(o.getObjectId(), o.getObjectName());
        }
        return result;
    }

    private Map<Long, String> getDciList(Map<String, String> query) throws Exception {
        HashMap<Long, String> result = new HashMap<Long, String>();
        if (!query.containsKey("target")) {
            return result;
        }
        try {
            DciValue[] values;
            long id = Long.parseLong(query.get("target"));
            for (DciValue v : values = this.getSession().getLastValues(id)) {
                result.put(v.getId(), v.getDescription());
            }
        }
        catch (NXCException e) {
            this.log.debug("DCI not found");
        }
        return result;
    }
}

