/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.handlers;

import java.util.Date;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.websvc.handlers.AbstractHandler;
import org.netxms.websvc.json.ResponseContainer;

public class UserAgentNotifications
extends AbstractHandler {
    protected Object getCollection(Map<String, String> query) throws Exception {
        NXCSession session = this.getSession();
        if (!session.isObjectsSynchronized()) {
            session.syncObjects();
        }
        return new ResponseContainer("notifications", (Object)session.getUserAgentNotifications());
    }

    protected Object create(JSONObject data) throws Exception {
        try {
            String message = data.getString("message");
            JSONArray objects = data.getJSONArray("objects");
            long startTime = data.has("startTime") ? data.getLong("startTime") * 1000L : 0L;
            long endTime = data.has("endTime") ? data.getLong("endTime") * 1000L : 0L;
            boolean onStartup = data.has("onStartup") ? data.getBoolean("onStartup") : false;
            long[] objectIds = new long[objects.length()];
            for (int i = 0; i < objects.length(); ++i) {
                objectIds[i] = objects.getLong(i);
            }
            this.getSession().createUserAgentNotification(message, objectIds, new Date(startTime), new Date(endTime), onStartup);
            return new JSONObject();
        }
        catch (JSONException e) {
            throw new NXCException(12);
        }
    }
}

